/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.Map;

public class GroupTypeDescription {
    private static final int SPLITERATORS_CLASS_STACK_TRACE_NUM = 5;
    private String groupTypeName;
    private String elementTypeName;

    public GroupTypeDescription(String groupTypeName, String elementTypeName) {
        this.groupTypeName = groupTypeName;
        this.elementTypeName = elementTypeName;
    }

    public String getElementTypeName() {
        return this.elementTypeName;
    }

    public String getGroupTypeName() {
        return this.groupTypeName;
    }

    public static GroupTypeDescription getGroupTypeDescription(Object actual) {
        return GroupTypeDescription.getGroupTypeDescription(actual.getClass());
    }

    public static GroupTypeDescription getGroupTypeDescription(Class<?> clazz) {
        if (Thread.currentThread().getStackTrace()[5].getClassName().contains("Spliterators")) {
            return new GroupTypeDescription("spliterator characteristics", "characteristics");
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return new GroupTypeDescription("map", "map entries");
        }
        if (clazz.isArray()) {
            return new GroupTypeDescription(clazz.getSimpleName(), clazz.getComponentType().getSimpleName().toLowerCase() + "(s)");
        }
        return new GroupTypeDescription(clazz.getSimpleName(), "element(s)");
    }
}

