/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.error.ShouldHaveValue;
import org.assertj.core.error.ShouldMatch;
import org.assertj.core.error.ShouldNotContainValue;
import org.assertj.core.presentation.PredicateDescription;

public class AtomicReferenceAssert<V>
extends AbstractAssert<AtomicReferenceAssert<V>, AtomicReference<V>> {
    public AtomicReferenceAssert(AtomicReference<V> actual) {
        super(actual, AtomicReferenceAssert.class);
    }

    public AtomicReferenceAssert<V> hasValue(V expectedValue) {
        this.isNotNull();
        Object actualValue = ((AtomicReference)this.actual).get();
        if (!this.objects.getComparisonStrategy().areEqual(actualValue, expectedValue)) {
            throw this.assertionError(ShouldHaveValue.shouldHaveValue(this.actual, expectedValue));
        }
        return (AtomicReferenceAssert)this.myself;
    }

    public AtomicReferenceAssert<V> doesNotHaveValue(V nonExpectedValue) {
        this.isNotNull();
        Object actualValue = ((AtomicReference)this.actual).get();
        if (this.objects.getComparisonStrategy().areEqual(actualValue, nonExpectedValue)) {
            throw this.assertionError(ShouldNotContainValue.shouldNotContainValue(this.actual, nonExpectedValue));
        }
        return (AtomicReferenceAssert)this.myself;
    }

    public AtomicReferenceAssert<V> hasValueMatching(Predicate<? super V> predicate) {
        return this.hasValueMatching(predicate, PredicateDescription.GIVEN);
    }

    public AtomicReferenceAssert<V> hasValueMatching(Predicate<? super V> predicate, String description) {
        return this.hasValueMatching(predicate, new PredicateDescription(description));
    }

    private AtomicReferenceAssert<V> hasValueMatching(Predicate<? super V> predicate, PredicateDescription description) {
        Objects.requireNonNull(predicate, "The predicate must not be null");
        this.isNotNull();
        Object actualValue = ((AtomicReference)this.actual).get();
        if (!predicate.test(actualValue)) {
            throw this.assertionError(ShouldMatch.shouldMatch(actualValue, predicate, description));
        }
        return (AtomicReferenceAssert)this.myself;
    }

    public AtomicReferenceAssert<V> hasValueSatisfying(Consumer<? super V> requirements) {
        Objects.requireNonNull(requirements, "The Consumer<? super V> expressing the assertions requirements must not be null");
        this.isNotNull();
        requirements.accept(((AtomicReference)this.actual).get());
        return (AtomicReferenceAssert)this.myself;
    }

    public AtomicReferenceAssert<V> hasNullValue() {
        return this.hasValue(null);
    }

    public AtomicReferenceAssert<V> doesNotHaveNullValue() {
        return this.doesNotHaveValue(null);
    }
}

