/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime.io.stream;

import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Objects;

public class WritableStreamingData
implements WritableSequentialData,
Closeable,
Flushable {
    private final OutputStream out;
    private long position = 0L;
    private long limit = Long.MAX_VALUE;
    private final long capacity;

    public WritableStreamingData(@NonNull OutputStream out) {
        this.out = Objects.requireNonNull(out);
        this.capacity = Long.MAX_VALUE;
    }

    public WritableStreamingData(@NonNull OutputStream out, long capacity) {
        this.out = Objects.requireNonNull(out);
        this.capacity = capacity;
        this.limit = capacity;
    }

    @Override
    public void close() throws IOException {
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long limit() {
        return this.limit;
    }

    @Override
    public void limit(long limit) {
        this.limit = Math.min(this.capacity(), Math.max(this.position, limit));
    }

    @Override
    public boolean hasRemaining() {
        return this.position < this.limit;
    }

    @Override
    public void skip(long count) {
        try {
            if (count > this.remaining()) {
                throw new BufferOverflowException();
            }
            if (count <= 0L) {
                return;
            }
            byte[] zeros = new byte[1024];
            int i = 0;
            while ((long)i < count) {
                int toWrite = (int)Math.min((long)zeros.length, count - (long)i);
                this.out.write(zeros, 0, toWrite);
                i += toWrite;
            }
            this.position += count;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeByte(byte b) {
        if (this.position >= this.limit) {
            throw new BufferOverflowException();
        }
        try {
            this.out.write(b);
            ++this.position;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeBytes(@NonNull byte[] src, int offset, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (length == 0) {
            return;
        }
        if ((long)length > this.remaining()) {
            throw new BufferOverflowException();
        }
        try {
            this.out.write(src, offset, length);
            this.position += (long)length;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeBytes(@NonNull byte[] src) {
        if ((long)src.length > this.remaining()) {
            throw new BufferOverflowException();
        }
        try {
            this.out.write(src);
            this.position += (long)src.length;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeBytes(@NonNull ByteBuffer src) {
        if (!src.hasArray()) {
            WritableSequentialData.super.writeBytes(src);
            return;
        }
        if (this.remaining() < (long)src.remaining()) {
            throw new BufferOverflowException();
        }
        long len = src.remaining();
        if (len == 0L) {
            return;
        }
        byte[] srcArr = src.array();
        int srcPos = src.position();
        try {
            this.out.write(srcArr, srcPos, Math.toIntExact(len));
            this.position += len;
            src.position(Math.toIntExact((long)srcPos + len));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeBytes(@NonNull BufferedData src) throws BufferOverflowException, UncheckedIOException {
        if (this.remaining() < src.remaining()) {
            throw new BufferOverflowException();
        }
        int pos = Math.toIntExact(src.position());
        int len = Math.toIntExact(src.remaining());
        src.writeTo(this.out, pos, len);
        this.position += (long)len;
    }

    @Override
    public void writeBytes(@NonNull RandomAccessData src) {
        long len = src.length();
        if (this.remaining() < len) {
            throw new BufferOverflowException();
        }
        src.writeTo(this.out);
        this.position += len;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }
}

