/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.migration;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import java.nio.ByteBuffer;
import java.util.Objects;

public class AccountID {
    private final long realmID;
    private final long shardID;
    private final long accountID;

    public AccountID() {
        this(0L, 0L, 0L);
    }

    public AccountID(long realmID, long shardID, long accountID) {
        this.realmID = realmID;
        this.shardID = shardID;
        this.accountID = accountID;
    }

    public Bytes toBytes() {
        byte[] bytes = new byte[24];
        ByteBuffer.wrap(bytes).putLong(this.realmID).putLong(this.shardID).putLong(this.accountID);
        return Bytes.wrap((byte[])bytes);
    }

    public String toString() {
        return "AccountVirtualMapKey{realmID=" + this.realmID + ", shardId=" + this.shardID + ", accountID=" + this.accountID + "}";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AccountID that = (AccountID)other;
        return this.realmID == that.realmID && this.shardID == that.shardID && this.accountID == that.accountID;
    }

    public int hashCode() {
        return Objects.hash(this.realmID, this.shardID, this.accountID);
    }
}

