/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.synchronization.task;

import com.swirlds.common.merkle.synchronization.task.CustomViewRootLesson;
import com.swirlds.common.merkle.synchronization.task.InternalDataLesson;
import com.swirlds.common.merkle.synchronization.task.LeafDataLesson;
import com.swirlds.common.merkle.synchronization.views.LearnerTreeView;
import java.io.IOException;
import java.util.List;
import org.hiero.base.Releasable;
import org.hiero.base.crypto.Hash;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class Lesson<T>
implements Releasable,
SelfSerializable {
    private static final long CLASS_ID = -7441057967105127907L;
    private byte lessonType;
    private SelfSerializable subLesson;
    private LearnerTreeView<T> learnerView;

    public Lesson() {
    }

    public Lesson(byte lessonType, SelfSerializable subLesson) {
        this.lessonType = lessonType;
        this.subLesson = subLesson;
    }

    public Lesson(LearnerTreeView<T> learnerTreeView) {
        this.learnerView = learnerTreeView;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeByte((int)this.lessonType);
        if (this.lessonType != 0) {
            this.subLesson.serialize(out);
        }
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.lessonType = in.readByte();
        switch (this.lessonType) {
            case 0: {
                return;
            }
            case 1: {
                this.subLesson = new LeafDataLesson<T>(this.learnerView);
                break;
            }
            case 2: {
                this.subLesson = new InternalDataLesson<T>(this.learnerView);
                break;
            }
            case 3: {
                this.subLesson = new CustomViewRootLesson();
                break;
            }
            default: {
                throw new IllegalStateException("unsupported lesson type " + this.lessonType);
            }
        }
        this.subLesson.deserialize(in, this.subLesson.getVersion());
    }

    public boolean isCurrentNodeUpToDate() {
        return this.lessonType == 0;
    }

    public boolean isLeafLesson() {
        return this.lessonType == 1;
    }

    public boolean isInternalLesson() {
        return this.lessonType == 2;
    }

    public boolean hasQueries() {
        return this.lessonType == 2;
    }

    public List<Hash> getQueries() {
        return ((InternalDataLesson)this.subLesson).getQueries();
    }

    public T getNode() {
        if (this.lessonType == 1) {
            return ((LeafDataLesson)this.subLesson).getLeaf();
        }
        return ((InternalDataLesson)this.subLesson).getInternal();
    }

    public boolean isCustomViewRoot() {
        return this.lessonType == 3;
    }

    public long getCustomViewClassId() {
        return ((CustomViewRootLesson)this.subLesson).getRootClassId();
    }

    public boolean release() {
        Object node;
        if (this.lessonType == 1 && this.learnerView != null && (node = ((LeafDataLesson)this.subLesson).getLeaf()) != null) {
            this.learnerView.releaseNode(node);
        }
        return true;
    }

    public long getClassId() {
        return -7441057967105127907L;
    }

    public int getVersion() {
        return 1;
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

