/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract.codec;

import com.hedera.hapi.node.contract.InternalCallContext;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class InternalCallContextJsonCodec
implements JsonCodec<InternalCallContext> {
    @NonNull
    public InternalCallContext parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            long temp_gas = 0L;
            long temp_value = 0L;
            Bytes temp_call_data = Bytes.EMPTY;
            block12: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "gas": {
                        temp_gas = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block12;
                    }
                    case "value": {
                        temp_value = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block12;
                    }
                    case "callData": {
                        temp_call_data = Bytes.fromBase64((String)JsonTools.checkSize((String)"call_data", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block12;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new InternalCallContext(temp_gas, temp_value, temp_call_data);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull InternalCallContext data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.gas() != 0L) {
            fieldLines.add(JsonTools.field((String)"gas", (long)data.gas()));
        }
        if (data.value() != 0L) {
            fieldLines.add(JsonTools.field((String)"value", (long)data.value()));
        }
        if (data.callData() != Bytes.EMPTY && data.callData() != null && data.callData().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"callData", (Bytes)data.callData()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

