/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.codec.PendingAirdropIdJsonCodec;
import com.hedera.hapi.node.base.codec.PendingAirdropIdProtoCodec;
import com.hedera.hapi.node.base.schema.PendingAirdropIdSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class PendingAirdropId {
    public static final Codec<PendingAirdropId> PROTOBUF = new PendingAirdropIdProtoCodec();
    public static final JsonCodec<PendingAirdropId> JSON = new PendingAirdropIdJsonCodec();
    public static final PendingAirdropId DEFAULT = PendingAirdropId.newBuilder().build();
    @Nullable
    private final AccountID senderId;
    @Nullable
    private final AccountID receiverId;
    private final OneOf<TokenReferenceOneOfType> tokenReference;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public PendingAirdropId(AccountID senderId, AccountID receiverId, OneOf<TokenReferenceOneOfType> tokenReference) {
        this.$unknownFields = null;
        this.senderId = senderId;
        this.receiverId = receiverId;
        if (tokenReference == null) {
            throw new NullPointerException("Parameter 'tokenReference' must be supplied and can not be null");
        }
        this.tokenReference = tokenReference;
    }

    public PendingAirdropId(AccountID senderId, AccountID receiverId, OneOf<TokenReferenceOneOfType> tokenReference, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.senderId = senderId;
        this.receiverId = receiverId;
        if (tokenReference == null) {
            throw new NullPointerException("Parameter 'tokenReference' must be supplied and can not be null");
        }
        this.tokenReference = tokenReference;
    }

    public AccountID senderId() {
        return this.senderId;
    }

    public AccountID receiverId() {
        return this.receiverId;
    }

    public OneOf<TokenReferenceOneOfType> tokenReference() {
        return this.tokenReference;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)PendingAirdropIdSchema.SENDER_ID, (Object)this.senderId, AccountID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)PendingAirdropIdSchema.RECEIVER_ID, (Object)this.receiverId, AccountID.PROTOBUF);
            if (this.tokenReference.kind() == TokenReferenceOneOfType.FUNGIBLE_TOKEN_TYPE) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)PendingAirdropIdSchema.FUNGIBLE_TOKEN_TYPE, (Object)((TokenID)this.tokenReference.as()), TokenID.PROTOBUF);
            }
            if (this.tokenReference.kind() == TokenReferenceOneOfType.NON_FUNGIBLE_TOKEN) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)PendingAirdropIdSchema.NON_FUNGIBLE_TOKEN, (Object)((NftID)this.tokenReference.as()), NftID.PROTOBUF);
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.senderId != null && !this.senderId.equals(PendingAirdropId.DEFAULT.senderId)) {
                result = 31 * result + this.senderId.hashCode();
            }
            if (this.receiverId != null && !this.receiverId.equals(PendingAirdropId.DEFAULT.receiverId)) {
                result = 31 * result + this.receiverId.hashCode();
            }
            if (this.tokenReference != null && !this.tokenReference.equals(PendingAirdropId.DEFAULT.tokenReference)) {
                result = 31 * result + this.tokenReference.hashCode();
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        PendingAirdropId thatObj = (PendingAirdropId)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.senderId == null && thatObj.senderId != null) {
            return false;
        }
        if (this.senderId != null && !this.senderId.equals(thatObj.senderId)) {
            return false;
        }
        if (this.receiverId == null && thatObj.receiverId != null) {
            return false;
        }
        if (this.receiverId != null && !this.receiverId.equals(thatObj.receiverId)) {
            return false;
        }
        if (this.tokenReference == null && thatObj.tokenReference != null) {
            return false;
        }
        if (this.tokenReference != null && !this.tokenReference.equals(thatObj.tokenReference)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "PendingAirdropId[senderId=" + String.valueOf(this.senderId) + ", receiverId=" + String.valueOf(this.receiverId) + ", tokenReference=" + String.valueOf(this.tokenReference) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasSenderId() {
        return this.senderId != null;
    }

    public AccountID senderIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasSenderId() ? this.senderId : defaultValue;
    }

    @NonNull
    public AccountID senderIdOrThrow() {
        return Objects.requireNonNull(this.senderId, "Field senderId is null");
    }

    public void ifSenderId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasSenderId()) {
            ifPresent.accept(this.senderId);
        }
    }

    public boolean hasReceiverId() {
        return this.receiverId != null;
    }

    public AccountID receiverIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasReceiverId() ? this.receiverId : defaultValue;
    }

    @NonNull
    public AccountID receiverIdOrThrow() {
        return Objects.requireNonNull(this.receiverId, "Field receiverId is null");
    }

    public void ifReceiverId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasReceiverId()) {
            ifPresent.accept(this.receiverId);
        }
    }

    @Nullable
    public TokenID fungibleTokenType() {
        return this.tokenReference.kind() == TokenReferenceOneOfType.FUNGIBLE_TOKEN_TYPE ? (TokenID)this.tokenReference.value() : null;
    }

    public boolean hasFungibleTokenType() {
        return this.tokenReference.kind() == TokenReferenceOneOfType.FUNGIBLE_TOKEN_TYPE;
    }

    public TokenID fungibleTokenTypeOrElse(@NonNull TokenID defaultValue) {
        return this.hasFungibleTokenType() ? this.fungibleTokenType() : defaultValue;
    }

    @NonNull
    public TokenID fungibleTokenTypeOrThrow() {
        return Objects.requireNonNull(this.fungibleTokenType(), "Field fungibleTokenType is null");
    }

    @Nullable
    public NftID nonFungibleToken() {
        return this.tokenReference.kind() == TokenReferenceOneOfType.NON_FUNGIBLE_TOKEN ? (NftID)this.tokenReference.value() : null;
    }

    public boolean hasNonFungibleToken() {
        return this.tokenReference.kind() == TokenReferenceOneOfType.NON_FUNGIBLE_TOKEN;
    }

    public NftID nonFungibleTokenOrElse(@NonNull NftID defaultValue) {
        return this.hasNonFungibleToken() ? this.nonFungibleToken() : defaultValue;
    }

    @NonNull
    public NftID nonFungibleTokenOrThrow() {
        return Objects.requireNonNull(this.nonFungibleToken(), "Field nonFungibleToken is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.senderId, this.receiverId, this.tokenReference, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum TokenReferenceOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        FUNGIBLE_TOKEN_TYPE(3, "fungible_token_type"),
        NON_FUNGIBLE_TOKEN(4, "non_fungible_token");

        private final int protoOrdinal;
        private final String protoName;

        private TokenReferenceOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static TokenReferenceOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 3 -> FUNGIBLE_TOKEN_TYPE;
                case 4 -> NON_FUNGIBLE_TOKEN;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static TokenReferenceOneOfType fromString(String name) {
            return switch (name) {
                case "fungible_token_type", "FUNGIBLE_TOKEN_TYPE" -> FUNGIBLE_TOKEN_TYPE;
                case "non_fungible_token", "NON_FUNGIBLE_TOKEN" -> NON_FUNGIBLE_TOKEN;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static final class Builder {
        @Nullable
        private AccountID senderId = null;
        @Nullable
        private AccountID receiverId = null;
        private OneOf<TokenReferenceOneOfType> tokenReference = PendingAirdropIdProtoCodec.TOKEN_REFERENCE_UNSET;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(AccountID senderId, AccountID receiverId, OneOf<TokenReferenceOneOfType> tokenReference) {
            this.$unknownFields = null;
            this.senderId = senderId;
            this.receiverId = receiverId;
            this.tokenReference = tokenReference;
        }

        public Builder(AccountID senderId, AccountID receiverId, OneOf<TokenReferenceOneOfType> tokenReference, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.senderId = senderId;
            this.receiverId = receiverId;
            this.tokenReference = tokenReference;
        }

        public PendingAirdropId build() {
            return new PendingAirdropId(this.senderId, this.receiverId, this.tokenReference);
        }

        public Builder senderId(@Nullable AccountID senderId) {
            this.senderId = senderId;
            return this;
        }

        public Builder senderId(AccountID.Builder builder) {
            this.senderId = builder.build();
            return this;
        }

        public Builder receiverId(@Nullable AccountID receiverId) {
            this.receiverId = receiverId;
            return this;
        }

        public Builder receiverId(AccountID.Builder builder) {
            this.receiverId = builder.build();
            return this;
        }

        public Builder fungibleTokenType(@Nullable TokenID fungibleTokenType) {
            this.tokenReference = new OneOf((Enum)TokenReferenceOneOfType.FUNGIBLE_TOKEN_TYPE, (Object)fungibleTokenType);
            return this;
        }

        public Builder fungibleTokenType(TokenID.Builder builder) {
            this.tokenReference = new OneOf((Enum)TokenReferenceOneOfType.FUNGIBLE_TOKEN_TYPE, (Object)builder.build());
            return this;
        }

        public Builder nonFungibleToken(@Nullable NftID nonFungibleToken) {
            this.tokenReference = new OneOf((Enum)TokenReferenceOneOfType.NON_FUNGIBLE_TOKEN, (Object)nonFungibleToken);
            return this;
        }

        public Builder nonFungibleToken(NftID.Builder builder) {
            this.tokenReference = new OneOf((Enum)TokenReferenceOneOfType.NON_FUNGIBLE_TOKEN, (Object)builder.build());
            return this;
        }
    }
}

