/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.iss.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.model.node.NodeId;

public class HashPartition {
    private final Hash hash;
    private long totalWeight = 0L;
    private final Set<NodeId> nodes = new HashSet<NodeId>();

    public HashPartition(Hash hash) {
        this.hash = hash;
    }

    public void addNodeHash(@NonNull NodeId nodeId, long weight) {
        Objects.requireNonNull(nodeId, "nodeId must not be null");
        boolean added = this.nodes.add(nodeId);
        if (!added) {
            throw new IllegalStateException("node " + String.valueOf(nodeId) + " is already in the partition");
        }
        this.totalWeight += weight;
    }

    public Hash getHash() {
        return this.hash;
    }

    public long getTotalWeight() {
        return this.totalWeight;
    }

    @NonNull
    public Set<NodeId> getNodes() {
        return this.nodes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Partition weight =  ").append(this.totalWeight).append(", hash = ").append(this.hash).append(", nodes = ");
        for (NodeId node : this.nodes) {
            sb.append(node).append(" ");
        }
        return sb.toString();
    }
}

