/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.stats;

import java.util.concurrent.atomic.AtomicLong;

public class AtomicMax {
    private static final long DEFAULT_UNINITIALIZED = 0L;
    private final AtomicLong max;
    private final long uninitializedValue;

    public AtomicMax(long uninitializedValue) {
        this.uninitializedValue = uninitializedValue;
        this.max = new AtomicLong(uninitializedValue);
    }

    public AtomicMax() {
        this(0L);
    }

    public long get() {
        return this.max.get();
    }

    public void reset() {
        this.max.set(this.uninitializedValue);
    }

    public long getAndReset() {
        return this.max.getAndSet(this.uninitializedValue);
    }

    public void update(long value) {
        this.max.accumulateAndGet(value, Math::max);
    }
}

