/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.signed;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.common.config.StateCommonConfig;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.io.utility.RecycleBin;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.crypto.MerkleCryptography;
import com.swirlds.common.merkle.utility.MerkleUtils;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.logging.legacy.payload.SavedStateLoadedPayload;
import com.swirlds.platform.config.BasicConfig;
import com.swirlds.platform.config.StateConfig;
import com.swirlds.platform.crypto.CryptoStatic;
import com.swirlds.platform.internal.SignedStateLoadingException;
import com.swirlds.platform.state.MerkleNodeState;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.state.signed.HashedReservedSignedState;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.state.signed.SignedState;
import com.swirlds.platform.state.snapshot.DeserializedSignedState;
import com.swirlds.platform.state.snapshot.SavedStateInfo;
import com.swirlds.platform.state.snapshot.SignedStateFilePath;
import com.swirlds.platform.state.snapshot.SignedStateFileReader;
import com.swirlds.state.State;
import com.swirlds.state.lifecycle.HapiUtils;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.roster.AddressBook;
import org.hiero.consensus.roster.RosterRetriever;
import org.hiero.consensus.roster.RosterUtils;

public final class StartupStateUtils {
    private static final Logger logger = LogManager.getLogger(StartupStateUtils.class);

    private StartupStateUtils() {
    }

    @Deprecated(forRemoval=true)
    @NonNull
    public static HashedReservedSignedState getInitialState(@NonNull RecycleBin recycleBin, @NonNull SemanticVersion softwareVersion, @NonNull Supplier<MerkleNodeState> genesisStateBuilder, @NonNull Function<VirtualMap, MerkleNodeState> createStateFromVirtualMap, @NonNull String mainClassName, @NonNull String swirldName, @NonNull NodeId selfId, @NonNull AddressBook configAddressBook, @NonNull PlatformStateFacade platformStateFacade, @NonNull PlatformContext platformContext) throws SignedStateLoadingException {
        ReservedSignedState genesisState;
        ReservedSignedState loadedState;
        Objects.requireNonNull(mainClassName);
        Objects.requireNonNull(swirldName);
        Objects.requireNonNull(selfId);
        Objects.requireNonNull(configAddressBook);
        Objects.requireNonNull(platformContext);
        Objects.requireNonNull(platformContext.getConfiguration());
        try (ReservedSignedState reservedSignedState = loadedState = StartupStateUtils.loadStateFile(recycleBin, selfId, mainClassName, swirldName, createStateFromVirtualMap, softwareVersion, platformStateFacade, platformContext);){
            if (loadedState.isNotNull()) {
                logger.info(LogMarker.STARTUP.getMarker(), (Object)new SavedStateLoadedPayload(loadedState.get().getRound(), loadedState.get().getConsensusTimestamp()));
                HashedReservedSignedState hashedReservedSignedState = StartupStateUtils.copyInitialSignedState(loadedState.get(), platformStateFacade, platformContext);
                return hashedReservedSignedState;
            }
        }
        try (ReservedSignedState reservedSignedState = genesisState = StartupStateUtils.buildGenesisState(configAddressBook, softwareVersion, genesisStateBuilder.get(), platformStateFacade, platformContext);){
            HashedReservedSignedState hashedReservedSignedState = StartupStateUtils.copyInitialSignedState(genesisState.get(), platformStateFacade, platformContext);
            return hashedReservedSignedState;
        }
    }

    @NonNull
    public static ReservedSignedState loadStateFile(@NonNull RecycleBin recycleBin, @NonNull NodeId selfId, @NonNull String mainClassName, @NonNull String swirldName, @NonNull Function<VirtualMap, MerkleNodeState> createStateFromVirtualMap, @NonNull SemanticVersion currentSoftwareVersion, @NonNull PlatformStateFacade platformStateFacade, @NonNull PlatformContext platformContext) {
        Configuration config = platformContext.getConfiguration();
        StateConfig stateConfig = (StateConfig)config.getConfigData(StateConfig.class);
        String actualMainClassName = stateConfig.getMainClassName(mainClassName);
        List<SavedStateInfo> savedStateFiles = new SignedStateFilePath((StateCommonConfig)config.getConfigData(StateCommonConfig.class)).getSavedStateFiles(actualMainClassName, selfId, swirldName);
        StartupStateUtils.logStatesFound(savedStateFiles);
        if (savedStateFiles.isEmpty()) {
            return ReservedSignedState.createNullReservation();
        }
        return StartupStateUtils.loadLatestState(recycleBin, currentSoftwareVersion, savedStateFiles, createStateFromVirtualMap, platformStateFacade, platformContext);
    }

    @NonNull
    public static HashedReservedSignedState copyInitialSignedState(@NonNull SignedState initialSignedState, @NonNull PlatformStateFacade platformStateFacade, @NonNull PlatformContext platformContext) {
        Objects.requireNonNull(platformContext);
        Objects.requireNonNull(platformContext.getConfiguration());
        Objects.requireNonNull(initialSignedState);
        MerkleNodeState stateCopy = initialSignedState.getState().copy();
        SignedState signedStateCopy = new SignedState(platformContext.getConfiguration(), CryptoStatic::verifySignature, stateCopy, "StartupStateUtils: copy initial state", false, false, false, platformStateFacade);
        signedStateCopy.init(platformContext);
        signedStateCopy.setSigSet(initialSignedState.getSigSet());
        Hash hash = platformContext.getMerkleCryptography().digestTreeSync(initialSignedState.getState().getRoot());
        return new HashedReservedSignedState(signedStateCopy.reserve("Copied initial state"), hash);
    }

    private static void logStatesFound(@NonNull List<SavedStateInfo> savedStateFiles) {
        if (savedStateFiles.isEmpty()) {
            logger.info(LogMarker.STARTUP.getMarker(), "No saved states were found on disk.");
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("The following saved states were found on disk:");
        for (SavedStateInfo savedStateFile : savedStateFiles) {
            sb.append("\n  - ").append(savedStateFile.stateFile());
        }
        logger.info(LogMarker.STARTUP.getMarker(), sb.toString());
    }

    public static ReservedSignedState loadLatestState(@NonNull RecycleBin recycleBin, @NonNull SemanticVersion currentSoftwareVersion, @NonNull List<SavedStateInfo> savedStateFiles, @NonNull Function<VirtualMap, MerkleNodeState> createStateFromVirtualMap, @NonNull PlatformStateFacade platformStateFacade, @NonNull PlatformContext platformContext) throws SignedStateLoadingException {
        logger.info(LogMarker.STARTUP.getMarker(), "Loading latest state from disk.");
        for (SavedStateInfo savedStateFile : savedStateFiles) {
            ReservedSignedState state = StartupStateUtils.loadStateFile(recycleBin, currentSoftwareVersion, savedStateFile, createStateFromVirtualMap, platformStateFacade, platformContext);
            if (state == null) continue;
            return state;
        }
        logger.warn(LogMarker.STARTUP.getMarker(), "No valid saved states were found on disk. Starting from genesis.");
        return ReservedSignedState.createNullReservation();
    }

    @Nullable
    private static ReservedSignedState loadStateFile(@NonNull RecycleBin recycleBin, @NonNull SemanticVersion currentSoftwareVersion, @NonNull SavedStateInfo savedStateFile, @NonNull Function<VirtualMap, MerkleNodeState> createStateFromVirtualMap, @NonNull PlatformStateFacade platformStateFacade, @NonNull PlatformContext platformContext) throws SignedStateLoadingException {
        DeserializedSignedState deserializedSignedState;
        logger.info(LogMarker.STARTUP.getMarker(), "Loading signed state from disk: {}", (Object)savedStateFile.stateFile());
        Configuration configuration = platformContext.getConfiguration();
        try {
            deserializedSignedState = SignedStateFileReader.readStateFile(savedStateFile.stateFile(), createStateFromVirtualMap, platformStateFacade, platformContext);
        }
        catch (IOException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "unable to load state file {}", (Object)savedStateFile.stateFile(), (Object)e);
            StateConfig stateConfig = (StateConfig)configuration.getConfigData(StateConfig.class);
            if (stateConfig.deleteInvalidStateFiles()) {
                StartupStateUtils.recycleState(recycleBin, savedStateFile);
                return null;
            }
            throw new SignedStateLoadingException("unable to load state, this is unrecoverable");
        }
        MerkleNodeState state = deserializedSignedState.reservedSignedState().get().getState();
        Hash oldHash = deserializedSignedState.originalHash();
        Hash newHash = MerkleUtils.rehashTree((MerkleCryptography)platformContext.getMerkleCryptography(), (MerkleNode)state.getRoot());
        SemanticVersion loadedVersion = platformStateFacade.creationSoftwareVersionOf(state);
        if (oldHash.equals((Object)newHash)) {
            logger.info(LogMarker.STARTUP.getMarker(), "Loaded state's hash is the same as when it was saved.");
        } else if (HapiUtils.SEMANTIC_VERSION_COMPARATOR.compare(loadedVersion, currentSoftwareVersion) == 0) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "The saved state file {} was created with the current version of the software, but the state hash has changed. Unless the state was intentionally modified, this is a good indicator that there is probably a bug.", (Object)savedStateFile.stateFile());
        } else {
            logger.warn(LogMarker.STARTUP.getMarker(), "The saved state file {} was created with version {}, which is different than the current version {}. The hash of the loaded state is different than the hash of the state when it was first created, which is not abnormal if there have been data migrations.", (Object)savedStateFile.stateFile(), (Object)loadedVersion, (Object)currentSoftwareVersion);
        }
        return deserializedSignedState.reservedSignedState();
    }

    private static void recycleState(@NonNull RecycleBin recycleBin, @NonNull SavedStateInfo stateInfo) {
        logger.warn(LogMarker.STARTUP.getMarker(), "Moving state {} to the recycle bin.", (Object)stateInfo.stateFile());
        try {
            recycleBin.recycle(stateInfo.getDirectory());
        }
        catch (IOException e) {
            throw new UncheckedIOException("unable to recycle state", e);
        }
    }

    private static ReservedSignedState buildGenesisState(@NonNull AddressBook addressBook, @NonNull SemanticVersion appVersion, @NonNull MerkleNodeState stateRoot, @NonNull PlatformStateFacade platformStateFacade, @NonNull PlatformContext platformContext) {
        StartupStateUtils.initGenesisState(platformContext.getConfiguration(), stateRoot, platformStateFacade, addressBook, appVersion);
        SignedState signedState = new SignedState(platformContext.getConfiguration(), CryptoStatic::verifySignature, stateRoot, "genesis state", false, false, false, platformStateFacade);
        signedState.init(platformContext);
        return signedState.reserve("initial reservation on genesis state");
    }

    private static void initGenesisState(Configuration configuration, State state, PlatformStateFacade platformStateFacade, AddressBook addressBook, SemanticVersion appVersion) {
        long round = 0L;
        platformStateFacade.bulkUpdateOf(state, v -> {
            v.setCreationSoftwareVersion(appVersion);
            v.setRound(0L);
            v.setLegacyRunningEventHash(null);
            v.setConsensusTimestamp(Instant.ofEpochSecond(0L));
            BasicConfig basicConfig = (BasicConfig)configuration.getConfigData(BasicConfig.class);
        });
        RosterUtils.setActiveRoster((State)state, (Roster)RosterRetriever.buildRoster((AddressBook)addressBook), (long)0L);
    }

    @NonNull
    public static HashedReservedSignedState loadInitialState(@NonNull RecycleBin recycleBin, @NonNull SemanticVersion softwareVersion, @NonNull Supplier<MerkleNodeState> stateRootSupplier, @NonNull String mainClassName, @NonNull String swirldName, @NonNull NodeId selfId, @NonNull PlatformStateFacade platformStateFacade, @NonNull PlatformContext platformContext, @NonNull Function<VirtualMap, MerkleNodeState> createStateFromVirtualMap) {
        ReservedSignedState reservedSignedState;
        ReservedSignedState loadedState;
        try (ReservedSignedState reservedSignedState2 = loadedState = StartupStateUtils.loadStateFile(recycleBin, selfId, mainClassName, swirldName, createStateFromVirtualMap, softwareVersion, platformStateFacade, platformContext);){
            if (loadedState.isNotNull()) {
                logger.info(LogMarker.STARTUP.getMarker(), (Object)new SavedStateLoadedPayload(loadedState.get().getRound(), loadedState.get().getConsensusTimestamp()));
                HashedReservedSignedState hashedReservedSignedState = StartupStateUtils.copyInitialSignedState(loadedState.get(), platformStateFacade, platformContext);
                return hashedReservedSignedState;
            }
        }
        MerkleNodeState stateRoot = stateRootSupplier.get();
        SignedState signedState = new SignedState(platformContext.getConfiguration(), CryptoStatic::verifySignature, stateRoot, "genesis state", false, false, false, platformStateFacade);
        signedState.init(platformContext);
        try (ReservedSignedState reservedSignedState3 = reservedSignedState = signedState.reserve("initial reservation on genesis state");){
            HashedReservedSignedState hashedReservedSignedState = StartupStateUtils.copyInitialSignedState(reservedSignedState.get(), platformStateFacade, platformContext);
            return hashedReservedSignedState;
        }
    }
}

