/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.platform;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.demo.platform.fs.stresstest.proto.ControlType;
import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class ControlAction
implements SelfSerializable {
    private static final long CLASS_ID = -7118251423743199491L;
    private Instant timestamp;
    private ControlType type;

    public ControlAction() {
    }

    public ControlAction(Instant timestamp, ControlType type) {
        this.timestamp = timestamp;
        this.type = type;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public ControlType getType() {
        return this.type;
    }

    public static ControlAction of(ControlType type) {
        return new ControlAction(Instant.EPOCH, type);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ControlAction that = (ControlAction)other;
        return this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type});
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("timestamp", (Object)this.timestamp).append("type", (Object)this.type).toString();
    }

    public long getClassId() {
        return -7118251423743199491L;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeInstant(this.timestamp);
        out.writeInt(this.type.getNumber());
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.timestamp = in.readInstant();
        this.type = ControlType.forNumber(in.readInt());
    }

    public int getVersion() {
        return 1;
    }
}

