/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.migration;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.pbj.runtime.ParseException;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.demo.migration.AccountID;
import com.swirlds.demo.migration.MapValue;
import com.swirlds.demo.migration.MigrationTestingToolConfig;
import com.swirlds.demo.migration.MigrationTestingToolMain;
import com.swirlds.demo.migration.MigrationTestingToolState;
import com.swirlds.demo.migration.MigrationTestingToolTransaction;
import com.swirlds.demo.migration.TransactionUtils;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.merkle.map.MerkleMap;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.system.InitTrigger;
import com.swirlds.platform.system.Platform;
import com.swirlds.state.State;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.event.ConsensusEvent;
import org.hiero.consensus.model.event.Event;
import org.hiero.consensus.model.hashgraph.Round;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.roster.AddressBook;
import org.hiero.consensus.model.transaction.ConsensusTransaction;
import org.hiero.consensus.model.transaction.ScopedSystemTransaction;
import org.hiero.consensus.model.transaction.Transaction;

public class MigrationTestToolConsensusStateEventHandler
implements ConsensusStateEventHandler<MigrationTestingToolState> {
    private static final Logger logger = LogManager.getLogger(MigrationTestToolConsensusStateEventHandler.class);
    public static final Duration DURATION = Duration.ofSeconds(10L);
    public NodeId selfId;
    private MigrationTestingToolConfig configData;

    public void onStateInitialized(@NonNull MigrationTestingToolState state, @NonNull Platform platform, @NonNull InitTrigger trigger, @Nullable SemanticVersion previousVersion) {
        VirtualMap virtualMap;
        MerkleMap<AccountID, MapValue> merkleMap = state.getMerkleMap();
        if (merkleMap != null) {
            logger.info(LogMarker.STARTUP.getMarker(), "MerkleMap initialized with {} values", (Object)merkleMap.size());
        }
        if ((virtualMap = state.getVirtualMap()) != null) {
            logger.info(LogMarker.STARTUP.getMarker(), "VirtualMap initialized with {} values", (Object)virtualMap.size());
        }
        this.selfId = platform.getSelfId();
        if (trigger == InitTrigger.GENESIS) {
            logger.warn(LogMarker.STARTUP.getMarker(), "InitTrigger was {} when expecting RESTART or RECONNECT", (Object)trigger);
            this.selfId = platform.getSelfId();
        }
        if (previousVersion == null || HapiUtils.SEMANTIC_VERSION_COMPARATOR.compare(previousVersion, MigrationTestingToolMain.PREVIOUS_SOFTWARE_VERSION) != 0) {
            logger.warn(LogMarker.STARTUP.getMarker(), "previousSoftwareVersion was {} when expecting it to be {}", (Object)previousVersion, (Object)MigrationTestingToolMain.PREVIOUS_SOFTWARE_VERSION);
        }
        if (trigger == InitTrigger.GENESIS) {
            logger.info(LogMarker.STARTUP.getMarker(), "Doing genesis initialization");
            state.genesisInit();
        }
        this.configData = (MigrationTestingToolConfig)platform.getContext().getConfiguration().getConfigData(MigrationTestingToolConfig.class);
    }

    public void onHandleConsensusRound(@NonNull Round round, @NonNull MigrationTestingToolState state, @NonNull Consumer<ScopedSystemTransaction<StateSignatureTransaction>> stateSignatureTransactionCallback) {
        state.throwIfImmutable();
        if (this.configData.applyFreezeTimeInRound() > 0L && round.getRoundNum() == this.configData.applyFreezeTimeInRound()) {
            Instant freezeTime = round.getConsensusTimestamp().plus(DURATION);
            logger.info(LogMarker.STARTUP.getMarker(), "Setting freeze time to {} seconds after:{}. Value:{}", (Object)DURATION.getSeconds(), (Object)round.getConsensusTimestamp(), (Object)freezeTime);
            PlatformStateFacade.DEFAULT_PLATFORM_STATE_FACADE.bulkUpdateOf((State)state, v -> v.setFreezeTime(freezeTime));
        }
        for (ConsensusEvent event : round) {
            Iterator transIt = event.consensusTransactionIterator();
            while (transIt.hasNext()) {
                ConsensusTransaction trans = (ConsensusTransaction)transIt.next();
                if (TransactionUtils.isSystemTransaction(trans.getApplicationTransaction())) {
                    this.consumeSystemTransaction((Transaction)trans, (Event)event, stateSignatureTransactionCallback);
                    continue;
                }
                MigrationTestingToolTransaction mTrans = TransactionUtils.parseTransaction(trans.getApplicationTransaction());
                mTrans.applyTo(state);
            }
        }
    }

    public void onPreHandle(@NonNull Event event, @NonNull MigrationTestingToolState state, @NonNull Consumer<ScopedSystemTransaction<StateSignatureTransaction>> stateSignatureTransactionCallback) {
        event.forEachTransaction(transaction -> {
            if (TransactionUtils.isSystemTransaction(transaction.getApplicationTransaction())) {
                this.consumeSystemTransaction((Transaction)transaction, event, stateSignatureTransactionCallback);
            }
        });
    }

    public boolean onSealConsensusRound(@NonNull Round round, @NonNull MigrationTestingToolState state) {
        return true;
    }

    public void onUpdateWeight(@NonNull MigrationTestingToolState state, @NonNull AddressBook configAddressBook, @NonNull PlatformContext context) {
    }

    public void onNewRecoveredState(@NonNull MigrationTestingToolState recoveredState) {
    }

    private void consumeSystemTransaction(@NonNull Transaction transaction, @NonNull Event event, @NonNull Consumer<ScopedSystemTransaction<StateSignatureTransaction>> stateSignatureTransactionCallback) {
        try {
            StateSignatureTransaction stateSignatureTransaction = (StateSignatureTransaction)StateSignatureTransaction.PROTOBUF.parse(transaction.getApplicationTransaction());
            stateSignatureTransactionCallback.accept((ScopedSystemTransaction<StateSignatureTransaction>)new ScopedSystemTransaction(event.getCreatorId(), event.getBirthRound(), (Object)stateSignatureTransaction));
        }
        catch (ParseException e) {
            logger.error("Failed to parse StateSignatureTransaction", (Throwable)e);
        }
    }
}

