/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.cli.logging;

import com.swirlds.cli.logging.CssDeclaration;
import com.swirlds.cli.logging.CssRuleSetFactory;
import com.swirlds.cli.logging.HtmlColors;
import com.swirlds.cli.logging.HtmlTagFactory;
import com.swirlds.cli.logging.LogLine;
import com.swirlds.cli.logging.LogProcessingUtils;
import com.swirlds.cli.logging.NodeIdColorizer;
import com.swirlds.cli.logging.PlatformStatusLog;
import com.swirlds.common.formatting.TextEffect;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import org.apache.logging.log4j.Level;
import org.hiero.consensus.model.node.NodeId;

public class HtmlGenerator {
    public static final String PAGE_BACKGROUND_COLOR = "#1e1e23";
    public static final String HIGHLIGHT_COLOR = "#353539";
    public static final String DEFAULT_TEXT_COLOR = "#bdbfc4";
    public static final String WHITELIST_RADIO_COLOR = "#6FD154";
    public static final String NEUTRALLIST_RADIO_COLOR = "#F3D412";
    public static final String BLACKLIST_RADIO_COLOR = "#DA4754";
    public static final String DEFAULT_FONT = "Jetbrains Mono, monospace";
    public static final String MIN_JS_SOURCE = "https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js";
    public static final String HIDEABLE_LABEL = "hideable";
    public static final String BLACKLIST_LABEL = "blacklist";
    public static final String NO_SHOW = "no-show";
    public static final String WHITELIST_LABEL = "whitelist";
    public static final String LOG_LINE_LABEL = "log-line";
    public static final String NODE_ID_COLUMN_LABEL = "node-id";
    public static final String ELAPSED_TIME_COLUMN_LABEL = "elapsed-time";
    public static final String TIMESTAMP_COLUMN_LABEL = "timestamp";
    public static final String LOG_NUMBER_COLUMN_LABEL = "log-number";
    public static final String LOG_LEVEL_COLUMN_LABEL = "log-level";
    public static final String MARKER_COLUMN_LABEL = "marker";
    public static final String THREAD_NAME_COLUMN_LABEL = "thread-name";
    public static final String CLASS_NAME_COLUMN_LABEL = "class-name";
    public static final String REMAINDER_OF_LINE_COLUMN_LABEL = "remainder";
    public static final String NON_STANDARD_LABEL = "non-standard";
    public static final String SELECT_MANY_BUTTON_LABEL = "select-many-button";
    public static final String DESELECT_MANY_BUTTON_LABEL = "deselect-many-button";
    public static final String SECLECT_COLUMN_BUTTON_LABEL = "select-column-button";
    public static final String SELECT_COMPACT_BUTTON_LABEL = "select-compact-button";
    public static final String FILTER_RADIO_LABEL = "filter-radio";
    public static final String WHITELIST_RADIO_LABEL = "whitelist-radio";
    public static final String NEUTRALLIST_RADIO_LABEL = "neutrallist-radio";
    public static final String BLACKLIST_RADIO_LABEL = "blacklist-radio";
    public static final String FILTER_CHECKBOX_LABEL = "filter-checkbox";
    public static final String NO_SHOW_CHECKBOX_LABEL = "no-show-checkbox";
    public static final String DOUBLE_COLUMNS_DIV_LABEL = "double-columns";
    public static final String INDEPENDENT_SCROLL_LABEL = "independent-scroll";
    public static final String TABLE_INDEPENDENT_SCROLL_LABEL = "table-independent-scroll";
    public static final String LOG_TABLE_LABEL = "log-table";
    private static final Map<String, String> logLevelLabels = Map.of("TRACE", "trace-label", "DEBUG", "debug-label", "INFO", "info-label", "WARN", "warn-label", "ERROR", "error-label", "FATAL", "fatal-label");
    public static final String FILTER_JS = "// the radio buttons that have the ability to hide things\nlet filterRadios = document.getElementsByClassName(\"filter-radio\");\n\n// create a map from radio name to previous value\nlet previousValues = new Map();\n\n// add a listener to each radio button\nfor (const element of filterRadios) {\n    // set defaults values to neutral\n    previousValues.set($(element).attr(\"name\"), \"2\");\n\n    element.addEventListener(\"change\", function() {\n        // the classes that exist on the checkbox that is clicked\n        let radioClasses = this.classList;\n\n        // the name of the class that should be hidden\n        let toggleClass;\n\n        // each radio button has 3 classes, \"filter-radio\", the type of radio button this is, and the name of the class to be hidden\n        for (const element of radioClasses) {\n            if (element === \"filter-radio\" || element.endsWith(\"filter-section\")) {\n                continue;\n            }\n\n            toggleClass = element;\n        }\n\n        let newCheckedValue = $(this).filter(\":checked\").val();\n        let previousCheckedValue = previousValues.get($(this).attr(\"name\"));\n\n        // record the current value of the radio button that was clicked\n        previousValues.set($(this).attr(\"name\"), $(this).filter(\":checked\").val());\n\n        // these are the objects on the page which match the class to toggle (discluding the input boxes)\n        let matchingObjects = $(\".\" + toggleClass).not(\"input\");\n\n        // go through each of the matching objects, and modify the hide count according to the value of the checkbox\n        for (const element of matchingObjects) {\n            let currentBlacklistCount = parseInt($(element).attr('blacklist')) || 0;\n            let currentWhitelistCount = parseInt($(element).attr('whitelist')) || 0;\n            let currentNoShowCount = parseInt($(element).attr('no-show')) || 0;\n\n            let newBlacklistCount;\n            let newWhitelistCount;\n            let newNoShowCount;\n\n            // modify blacklist and whitelist counts depending on the new checked value, and the previous checked value\n            if (newCheckedValue === \"1\") {\n                newWhitelistCount = currentWhitelistCount + 1;\n                if (previousCheckedValue === \"3\") {\n                    newBlacklistCount = currentBlacklistCount - 1;\n                } else if(previousCheckedValue === \"4\") {\n                    newNoShowCount = currentNoShowCount - 1;\n                }\n            } else if (newCheckedValue === \"2\") {\n                if (previousCheckedValue === \"1\") {\n                    newWhitelistCount = currentWhitelistCount - 1;\n                } else if (previousCheckedValue === \"3\") {\n                    newBlacklistCount = currentBlacklistCount - 1;\n                } else if(previousCheckedValue === \"4\") {\n                    newNoShowCount = currentNoShowCount - 1;\n                }\n            } else if (newCheckedValue === \"3\") {\n                newBlacklistCount = currentBlacklistCount + 1;\n                if (previousCheckedValue === \"1\") {\n                    newWhitelistCount = currentWhitelistCount - 1;\n                } else if(previousCheckedValue === \"4\") {\n                    newNoShowCount = currentNoShowCount - 1;\n                }\n            } else if (newCheckedValue === \"4\") {\n                newNoShowCount = currentNoShowCount + 1;\n                if (previousCheckedValue === \"1\") {\n                    newWhitelistCount = currentWhitelistCount - 1;\n                } else if(previousCheckedValue === \"3\") {\n                    newBlacklistCount = currentBlacklistCount - 1;\n                }\n            }\n\n            $(element).attr('whitelist', newWhitelistCount);\n            $(element).attr('blacklist', newBlacklistCount);\n            $(element).attr('no-show', newNoShowCount);\n        }\n    });\n}\n\n// the checkboxes that have the ability to hide things\nlet filterCheckboxes = document.getElementsByClassName(\"filter-checkbox\");\n\n// add a listener to each checkbox\nfor (const element of filterCheckboxes) {\n    element.addEventListener(\"change\", function() {\n        // the classes that exist on the checkbox that is clicked\n        let checkboxClasses = this.classList;\n\n        // the name of the class that should be hidden\n        let toggleClass;\n\n        for (const element of checkboxClasses) {\n            if (element === \"filter-checkbox\" ||\n            element === \"compact-show\" ||\n            element === \"compact-hide\" ||\n            element.endsWith(\"filter-section\")) {\n                continue;\n            }\n\n            toggleClass = element;\n        }\n\n        // these are the objects on the page which match the class to toggle (discluding the input boxes)\n        let matchingObjects = $(\".\" + toggleClass).not(\"input\");\n\n        // go through each of the matching objects, and modify the hide count according to the value of the checkbox\n        for (const element of matchingObjects) {\n            let currentBlacklistCount = parseInt($(element).attr('blacklist')) || 0;\n\n            let newBlacklistCount;\n            if ($(this).is(\":checked\")) {\n                newBlacklistCount = currentBlacklistCount - 1;\n            } else {\n                newBlacklistCount = currentBlacklistCount + 1;\n            }\n\n            $(element).attr('blacklist', newBlacklistCount);\n        }\n    });\n}\n\n// the checkboxes that have the ability to REALLY hide things\nlet noShowCheckboxes = document.getElementsByClassName(\"no-show-checkbox\");\n\n// add a listener to each checkbox\nfor (const element of noShowCheckboxes) {\n    element.addEventListener(\"change\", function() {\n        // the classes that exist on the checkbox that is clicked\n        let checkboxClasses = this.classList;\n\n        // the name of the class that should be hidden\n        let toggleClass;\n\n        for (const element of checkboxClasses) {\n            if (element === \"no-show-checkbox\" || element.endsWith(\"filter-section\")) {\n                continue;\n            }\n\n            toggleClass = element;\n        }\n\n        // these are the objects on the page which match the class to toggle (discluding the input boxes)\n        let matchingObjects = $(\".\" + toggleClass).not(\"input\");\n\n        // go through each of the matching objects, and modify the hide count according to the value of the checkbox\n        for (const element of matchingObjects) {\n            let currentNoShowCount = parseInt($(element).attr('no-show')) || 0;\n\n            let newNoShowCount;\n            if ($(this).is(\":checked\")) {\n                newNoShowCount = currentNoShowCount - 1;\n            } else {\n                newNoShowCount = currentNoShowCount + 1;\n            }\n\n            $(element).attr('no-show', newNoShowCount);\n        }\n    });\n}\n// the checkboxes that have the ability to \"select\" a line\nlet selectCheckboxes = document.getElementsByClassName(\"select-checkbox\");\n// add a listener to each checkbox\nfor (const element of selectCheckboxes) {\n    element.addEventListener(\"change\", function() {\n        let potentialTopLevelLine = $(this).parent();\n        // step up parents, until you find the main log line\n        while ($(potentialTopLevelLine).parent().hasClass(\"log-line\")) {\n            potentialTopLevelLine = $(potentialTopLevelLine).parent();\n        }\n        if ($(this).is(\":checked\")) {\n            $(potentialTopLevelLine).attr('selected', true);\n        } else {\n            $(potentialTopLevelLine).attr('selected', false);\n        }\n    });\n}\n\nlet selectManyButtons = document.getElementsByClassName(\"select-many-button\");\nfor (const selectManyButton of selectManyButtons) {\n    // get the other class name of the button\n    let selectManyButtonClasses = selectManyButton.classList;\n\n    // the name of the section\n    let sectionClass;\n\n    for (const buttonClass of selectManyButtonClasses) {\n        if (buttonClass === \"select-many-button\") {\n            continue;\n        }\n\n        sectionClass = buttonClass;\n    }\n\n    let sectionButtons = document.getElementsByClassName(sectionClass);\n\n    selectManyButton.addEventListener(\"click\", function() {\n        for (const button of sectionButtons) {\n            if ($(button).hasClass(\"select-many-button\")) {\n                continue;\n            }\n            if (!$(button).is(\":checked\")) {\n                button.click()\n            }\n        }\n    });\n}\n\nlet deselectManyButtons = document.getElementsByClassName(\"deselect-many-button\");\nfor (const deselectManyButton of deselectManyButtons) {\n    // get the other class name of the button\n    let deselectManyButtonClasses = deselectManyButton.classList;\n\n    // the name of the section\n    let sectionClass;\n\n    for (const buttonClass of deselectManyButtonClasses) {\n        if (buttonClass === \"deselect-many-button\") {\n            continue;\n        }\n\n        sectionClass = buttonClass;\n    }\n\n    let sectionButtons = document.getElementsByClassName(sectionClass);\n\n    deselectManyButton.addEventListener(\"click\", function() {\n        for (const button of sectionButtons) {\n            if ($(button).hasClass(\"deselect-many-button\")) {\n                continue;\n            }\n            if ($(button).is(\":checked\")) {\n                button.click()\n            }\n        }\n    });\n}\n\nlet selectCompactButtons = document.getElementsByClassName(\"select-compact-button\");\nfor (const selectCompactButton of selectCompactButtons) {\n    // get the other class name of the button\n    let selectCompactButtonClasses = selectCompactButton.classList;\n\n    // the name of the section\n    let sectionClass;\n\n    for (const buttonClass of selectCompactButtonClasses) {\n        if (buttonClass === \"select-compact-button\") {\n            continue;\n        }\n\n        console.log(buttonClass);\n        sectionClass = buttonClass;\n    }\n\n    let sectionButtons = document.getElementsByClassName(sectionClass);\n\n    selectCompactButton.addEventListener(\"click\", function() {\n        for (const button of sectionButtons) {\n            if ($(button).hasClass(\"select-compact-button\")) {\n                continue;\n            }\n            if (!$(button).is(\":checked\") && $(button).hasClass(\"compact-show\") ||\n            $(button).is(\":checked\") && $(button).hasClass(\"compact-hide\")) {\n                button.click()\n            }\n        }\n    });\n}\n\nlet columnSelectButtons = document.getElementsByClassName(\"select-column-button\");\nfor (const columnSelectButton of columnSelectButtons) {\n    // get the other class name of the button\n    let columnSelectButtonClasses = columnSelectButton.classList;\n\n    // the name of the section\n    let sectionClass;\n    let radioTypeClass;\n\n    for (const buttonClass of columnSelectButtonClasses) {\n        if (buttonClass === \"select-column-button\") {\n            continue;\n        }\n\n        if (buttonClass.endsWith(\"-radio\")) {\n            radioTypeClass = buttonClass;\n            continue;\n        }\n\n        sectionClass = buttonClass;\n    }\n\n    let sectionButtons = document.getElementsByClassName(sectionClass + \" \" + radioTypeClass);\n\n    columnSelectButton.addEventListener(\"click\", function() {\n        for (const button of sectionButtons) {\n            if ($(button).hasClass(\"select-column-button\")) {\n                continue;\n            }\n            button.click()\n        }\n    });\n}\n\n// set the compact view automatically\nlet compactHidden = document.getElementsByClassName(\"compact-hide\");\nfor (const element of compactHidden) {\n    element.click();\n}\n";

    private HtmlGenerator() {
    }

    @NonNull
    private static String createNodeIdCheckbox(@NonNull String sectionName, @NonNull String nodeId) {
        String nodeLogicLabel = "node" + nodeId;
        String nodeStylingLabel = "node-" + nodeId;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(new HtmlTagFactory("input").addClasses(List.of(NO_SHOW_CHECKBOX_LABEL, nodeLogicLabel, sectionName)).addAttribute("type", "checkbox").addAttribute("checked", "checked").generateTag()).append("\n");
        stringBuilder.append(new HtmlTagFactory("label", nodeLogicLabel).addClass(nodeStylingLabel).generateTag()).append("\n");
        stringBuilder.append(new HtmlTagFactory("br").generateTag()).append("\n");
        return stringBuilder.toString();
    }

    @NonNull
    private static String createCheckboxFilter(@NonNull String elementName, @NonNull String sectionName, boolean compactView) {
        HtmlTagFactory tagFactory = new HtmlTagFactory("input").addClasses(List.of(FILTER_CHECKBOX_LABEL, elementName, sectionName)).addAttribute("type", "checkbox").addAttribute("checked", "checked");
        if (compactView) {
            tagFactory.addClass("compact-show");
        } else {
            tagFactory.addClass("compact-hide");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(tagFactory.generateTag()).append("\n");
        stringBuilder.append(new HtmlTagFactory("label", elementName).generateTag()).append("\n");
        stringBuilder.append(new HtmlTagFactory("br").generateTag()).append("\n");
        return stringBuilder.toString();
    }

    @NonNull
    private static String createStandardRadioFilterWithoutLabelClass(@NonNull String sectionName, @NonNull String elementName) {
        return HtmlGenerator.createStandardRadioFilter(sectionName, elementName, null);
    }

    @NonNull
    private static String createStandardRadioFilter(@NonNull String sectionName, @NonNull String elementName, @Nullable String labelClass) {
        String commonRadioLabel = elementName + "-radio";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(new HtmlTagFactory("input").addClasses(List.of(FILTER_RADIO_LABEL, WHITELIST_LABEL, WHITELIST_RADIO_LABEL, elementName, sectionName)).addAttribute("type", "radio").addAttribute("name", commonRadioLabel).addAttribute("value", "1").generateTag()).append("\n");
        stringBuilder.append(new HtmlTagFactory("input").addClasses(List.of(FILTER_RADIO_LABEL, NEUTRALLIST_RADIO_LABEL, elementName, sectionName)).addAttribute("type", "radio").addAttribute("name", commonRadioLabel).addAttribute("checked", "checked").addAttribute("value", "2").generateTag()).append("\n");
        stringBuilder.append(new HtmlTagFactory("input").addClasses(List.of(FILTER_RADIO_LABEL, BLACKLIST_LABEL, BLACKLIST_RADIO_LABEL, elementName, sectionName)).addAttribute("type", "radio").addAttribute("name", commonRadioLabel).addAttribute("value", "3").generateTag()).append("\n");
        HtmlTagFactory labelTagFactory = new HtmlTagFactory("label", elementName);
        if (labelClass != null) {
            labelTagFactory.addClass(labelClass);
        }
        stringBuilder.append(labelTagFactory.generateTag()).append("\n");
        stringBuilder.append(new HtmlTagFactory("br").generateTag()).append("\n");
        return stringBuilder.toString();
    }

    @NonNull
    private static String createInputDiv(@NonNull String heading, @NonNull List<String> bodyElements) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(new HtmlTagFactory("h3", heading).generateTag()).append("\n");
        stringBuilder.append(new HtmlTagFactory("form", "\n" + String.join((CharSequence)"\n", bodyElements)).addAttribute("autocomplete", "off").generateTag()).append("\n");
        return new HtmlTagFactory("div", stringBuilder.toString()).generateTag();
    }

    @NonNull
    private static String createNodeIdFilterDiv(@NonNull List<String> filterValues) {
        ArrayList<String> elements = new ArrayList<String>();
        String sectionName = "node-filter-section";
        elements.add(new HtmlTagFactory("input").addClass("node-filter-section").addClass(SELECT_MANY_BUTTON_LABEL).addAttribute("type", "button").addAttribute("value", "All").generateTag());
        elements.add(new HtmlTagFactory("input").addClass("node-filter-section").addClass(DESELECT_MANY_BUTTON_LABEL).addAttribute("type", "button").addAttribute("value", "None").generateTag());
        elements.add(new HtmlTagFactory("br").generateTag());
        filterValues.forEach(filterValue -> elements.add(HtmlGenerator.createNodeIdCheckbox("node-filter-section", filterValue)));
        return HtmlGenerator.createInputDiv("Node ID", elements);
    }

    @NonNull
    private static String createColumnFilterDiv(@NonNull List<String> filterValues, @NonNull List<Boolean> compactView) {
        String sectionName = "column-filter-section";
        ArrayList<String> elements = new ArrayList<String>();
        elements.add(new HtmlTagFactory("input").addClass("column-filter-section").addClass(SELECT_MANY_BUTTON_LABEL).addAttribute("type", "button").addAttribute("value", "All").generateTag());
        elements.add(new HtmlTagFactory("input").addClass("column-filter-section").addClass(SELECT_COMPACT_BUTTON_LABEL).addAttribute("type", "button").addAttribute("value", "Compact").generateTag());
        elements.add(new HtmlTagFactory("br").generateTag());
        for (int i = 0; i < filterValues.size(); ++i) {
            elements.add(HtmlGenerator.createCheckboxFilter(filterValues.get(i), "column-filter-section", compactView.get(i)));
        }
        return HtmlGenerator.createInputDiv("Columns", elements);
    }

    @NonNull
    private static String createRadioColumnSelectorButtons(@NonNull String sectionName) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(new HtmlTagFactory("input").addClass(SECLECT_COLUMN_BUTTON_LABEL).addClass(WHITELIST_RADIO_LABEL).addClass(sectionName).addAttribute("type", "button").addAttribute("value", "v").generateTag());
        stringBuilder.append(new HtmlTagFactory("input").addClass(SECLECT_COLUMN_BUTTON_LABEL).addClass(NEUTRALLIST_RADIO_LABEL).addClass(sectionName).addAttribute("type", "button").addAttribute("value", "v").generateTag());
        stringBuilder.append(new HtmlTagFactory("input").addClass(SECLECT_COLUMN_BUTTON_LABEL).addClass(BLACKLIST_RADIO_LABEL).addClass(sectionName).addAttribute("type", "button").addAttribute("value", "v").generateTag());
        stringBuilder.append(new HtmlTagFactory("br").generateTag()).append("\n");
        return stringBuilder.toString();
    }

    @NonNull
    private static String createStandardFilterDivWithoutLabelClasses(@NonNull String sectionName, @NonNull String filterName, @NonNull List<String> filterValues) {
        ArrayList<String> elements = new ArrayList<String>();
        elements.add(HtmlGenerator.createRadioColumnSelectorButtons(sectionName));
        filterValues.forEach(filterValue -> elements.add(HtmlGenerator.createStandardRadioFilterWithoutLabelClass(sectionName, filterValue)));
        return HtmlGenerator.createInputDiv(filterName, elements);
    }

    private static String createStandardFilterDivWithLabelClasses(@NonNull String sectionName, @NonNull String filterName, @NonNull List<String> filterValues, @NonNull Map<String, String> labelClasses) {
        ArrayList<String> elements = new ArrayList<String>();
        elements.add(HtmlGenerator.createRadioColumnSelectorButtons(sectionName));
        filterValues.forEach(filterValue -> elements.add(HtmlGenerator.createStandardRadioFilter(sectionName, filterValue, (String)labelClasses.get(filterValue))));
        return HtmlGenerator.createInputDiv(filterName, elements);
    }

    private static void createGeneralCssRules(@NonNull List<LogLine> logLines, @NonNull CssRuleSetFactory cssFactory) {
        cssFactory.addRule("html *", new CssDeclaration("font-family", DEFAULT_FONT), new CssDeclaration("background-color", PAGE_BACKGROUND_COLOR), new CssDeclaration("color", DEFAULT_TEXT_COLOR), new CssDeclaration("white-space", "nowrap"), new CssDeclaration("vertical-align", "top"));
        cssFactory.addRule("[%s]:not([%s~='0']):not([%s~=\"NaN\"]):is([%s='0']):not([selected])".formatted(BLACKLIST_LABEL, BLACKLIST_LABEL, BLACKLIST_LABEL, WHITELIST_LABEL), new CssDeclaration("display", "none"));
        cssFactory.addRule("[%s]:not([%s~='0']):not([selected])".formatted(NO_SHOW, NO_SHOW), new CssDeclaration("display", "none !important"));
        cssFactory.addRule("td", new CssDeclaration("padding-left", "1em"));
        cssFactory.addRule(".remainder", new CssDeclaration("max-width", "100em"), new CssDeclaration("overflow-wrap", "break-word"), new CssDeclaration("word-break", "break-word"), new CssDeclaration("white-space", "normal"));
        cssFactory.addRule(".non-standard", new CssDeclaration("white-space", "pre-wrap"), new CssDeclaration("word-break", "break-word"), new CssDeclaration("overflow-wrap", "break-word"));
        cssFactory.addRule(".thread-name", new CssDeclaration("max-width", "30em"), new CssDeclaration("overflow-wrap", "break-word"), new CssDeclaration("word-break", "break-word"), new CssDeclaration("white-space", "normal"));
        cssFactory.addRule(".node-id", new CssDeclaration("color", HtmlColors.getHtmlColor(LogLine.TIMESTAMP_COLOR)));
        cssFactory.addRule(".elapsed-time", new CssDeclaration("color", HtmlColors.getHtmlColor(LogLine.TIMESTAMP_COLOR)));
        cssFactory.addRule(".timestamp", new CssDeclaration("color", HtmlColors.getHtmlColor(LogLine.TIMESTAMP_COLOR)));
        cssFactory.addRule(".log-number", new CssDeclaration("color", HtmlColors.getHtmlColor(LogLine.LOG_NUMBER_COLOR)));
        cssFactory.addRule(".marker", new CssDeclaration("color", HtmlColors.getHtmlColor(LogLine.LOG_MARKER_COLOR)));
        cssFactory.addRule(".thread-name", new CssDeclaration("color", HtmlColors.getHtmlColor(LogLine.THREAD_NAME_COLOR)));
        cssFactory.addRule(".class-name", new CssDeclaration("color", HtmlColors.getHtmlColor(LogLine.CLASS_NAME_COLOR)));
        cssFactory.addRule(".status-detail", new CssDeclaration("color", HtmlColors.getHtmlColor(PlatformStatusLog.STATUS_COLOR)), new CssDeclaration("background-color", "inherit"));
        cssFactory.addRule(".log-line:hover td", new CssDeclaration("background-color", HIGHLIGHT_COLOR));
        cssFactory.addRule(".select-many-button, .deselect-many-button, .select-compact-button", new CssDeclaration("background-color", HtmlColors.getHtmlColor(TextEffect.GRAY)));
        cssFactory.addRule(".select-column-button.whitelist-radio", new CssDeclaration("border-color", WHITELIST_RADIO_COLOR));
        cssFactory.addRule(".select-column-button.neutrallist-radio", new CssDeclaration("border-color", NEUTRALLIST_RADIO_COLOR));
        cssFactory.addRule(".select-column-button.blacklist-radio", new CssDeclaration("border-color", BLACKLIST_RADIO_COLOR));
        cssFactory.addRule(".select-column-button", new CssDeclaration("margin", "1px"), new CssDeclaration("width", "2em"));
        logLines.stream().map(LogLine::getLogLevel).distinct().forEach(logLevel -> cssFactory.addRule("td." + logLevel + "-level", new CssDeclaration("color", HtmlColors.getHtmlColor(LogProcessingUtils.getLogLevelColor(logLevel)))));
        logLines.stream().map(LogLine::getNodeId).distinct().filter(Objects::nonNull).forEach(nodeId -> {
            String color = NodeIdColorizer.getNodeIdColor(nodeId);
            cssFactory.addRule("td.node-" + String.valueOf(nodeId) + ", label.node-" + String.valueOf(nodeId), new CssDeclaration("color", color == null ? DEFAULT_TEXT_COLOR : color));
        });
        IntStream.range(0, NodeIdColorizer.nodeIdColors.size()).forEach(index -> cssFactory.addRule("tr[selected].node" + index + ", tbody[selected].node" + index, new CssDeclaration("outline", "2px solid " + NodeIdColorizer.nodeIdColors.get(index) + "50"), new CssDeclaration("outline-offset", "-2px")));
    }

    @NonNull
    private static String generateHead(@NonNull CssRuleSetFactory cssFactory) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(new HtmlTagFactory("style", cssFactory.generateCss()).generateTag()).append("\n");
        stringBuilder.append(new HtmlTagFactory("script", "").addAttribute("src", MIN_JS_SOURCE).generateTag()).append("\n");
        return new HtmlTagFactory("head", stringBuilder.toString()).generateTag();
    }

    @NonNull
    private static String generateFiltersDiv(@NonNull List<LogLine> logLines, @NonNull CssRuleSetFactory cssFactory) {
        StringBuilder filterDivBuilder = new StringBuilder();
        filterDivBuilder.append(HtmlGenerator.createNodeIdFilterDiv(logLines.stream().map(LogLine::getNodeId).distinct().filter(Objects::nonNull).sorted().map(NodeId::toString).toList()));
        filterDivBuilder.append(HtmlGenerator.createColumnFilterDiv(List.of(NODE_ID_COLUMN_LABEL, ELAPSED_TIME_COLUMN_LABEL, TIMESTAMP_COLUMN_LABEL, LOG_NUMBER_COLUMN_LABEL, LOG_LEVEL_COLUMN_LABEL, MARKER_COLUMN_LABEL, THREAD_NAME_COLUMN_LABEL, CLASS_NAME_COLUMN_LABEL, REMAINDER_OF_LINE_COLUMN_LABEL), List.of(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true))));
        logLevelLabels.forEach((logLevel, labelClass) -> cssFactory.addRule("." + labelClass, new CssDeclaration("color", HtmlColors.getHtmlColor(LogProcessingUtils.getLogLevelColor(logLevel)))));
        filterDivBuilder.append(HtmlGenerator.createStandardFilterDivWithLabelClasses("log-level-filter-section", "Log Level", logLines.stream().map(LogLine::getLogLevel).distinct().sorted(Comparator.comparing(Level::toLevel)).toList(), logLevelLabels)).append("\n");
        filterDivBuilder.append(HtmlGenerator.createStandardFilterDivWithoutLabelClasses("log-marker-filter-section", "Log Marker", logLines.stream().map(LogLine::getMarker).distinct().toList())).append("\n");
        filterDivBuilder.append(HtmlGenerator.createStandardFilterDivWithoutLabelClasses("class-filter-section", "Class", logLines.stream().map(LogLine::getClassName).distinct().toList())).append("\n");
        StringBuilder containingDivBuilder = new StringBuilder();
        containingDivBuilder.append(new HtmlTagFactory("div", filterDivBuilder.toString()).addClass(INDEPENDENT_SCROLL_LABEL).generateTag()).append("\n");
        cssFactory.addRule(".whitelist-radio", new CssDeclaration("accent-color", WHITELIST_RADIO_COLOR));
        cssFactory.addRule(".neutrallist-radio", new CssDeclaration("accent-color", NEUTRALLIST_RADIO_COLOR));
        cssFactory.addRule(".blacklist-radio", new CssDeclaration("accent-color", BLACKLIST_RADIO_COLOR));
        cssFactory.addRule(".independent-scroll", new CssDeclaration("overflow", "auto"));
        cssFactory.addRule(".independent-scroll", new CssDeclaration("height", "99vh"));
        return new HtmlTagFactory("div", containingDivBuilder.toString()).generateTag();
    }

    @NonNull
    private static String generateLogTable(@NonNull List<LogLine> logLines, @NonNull CssRuleSetFactory cssFactory) {
        StringBuilder stringBuilder = new StringBuilder().append("\n");
        logLines.stream().map(LogLine::generateHtmlString).forEach(logHtml -> stringBuilder.append((String)logHtml).append("\n"));
        cssFactory.addRule(".log-table", new CssDeclaration("border-collapse", "collapse"));
        return new HtmlTagFactory("table", stringBuilder.toString()).addClass(LOG_TABLE_LABEL).generateTag();
    }

    @NonNull
    private static String generateBody(@NonNull List<LogLine> logLines, @NonNull CssRuleSetFactory cssFactory) {
        StringBuilder doubleColumnDivBuilder = new StringBuilder();
        doubleColumnDivBuilder.append(HtmlGenerator.generateFiltersDiv(logLines, cssFactory)).append("\n");
        doubleColumnDivBuilder.append(new HtmlTagFactory("div", HtmlGenerator.generateLogTable(logLines, cssFactory)).addClass(INDEPENDENT_SCROLL_LABEL).addClass(TABLE_INDEPENDENT_SCROLL_LABEL).generateTag()).append("\n");
        cssFactory.addRule(".table-independent-scroll", new CssDeclaration("width", "100%"));
        StringBuilder bodyBuilder = new StringBuilder();
        bodyBuilder.append(new HtmlTagFactory("div", doubleColumnDivBuilder.toString()).addClass(DOUBLE_COLUMNS_DIV_LABEL).generateTag()).append("\n");
        cssFactory.addRule(".double-columns", new CssDeclaration("display", "flex"), new CssDeclaration("height", "100%"));
        bodyBuilder.append(new HtmlTagFactory("script", FILTER_JS).generateTag()).append("\n");
        return new HtmlTagFactory("body", bodyBuilder.toString()).generateTag();
    }

    private static void setFirstLogTime(@NonNull List<LogLine> logLines) {
        Instant firstLogTime;
        LogLine firstLogLine = logLines.stream().min(Comparator.comparing(LogLine::getTimestamp)).orElse(null);
        Instant instant = firstLogTime = firstLogLine == null ? null : firstLogLine.getTimestamp();
        if (firstLogTime != null) {
            logLines.forEach(logLine -> logLine.setLogStartTime(firstLogTime));
        }
    }

    @NonNull
    private static List<LogLine> processNodeLogLines(@NonNull NodeId nodeId, @NonNull List<String> logLineStrings) {
        ArrayList<LogLine> outputLines = new ArrayList<LogLine>();
        LogLine previousLogLine = null;
        for (String logLineString : logLineStrings) {
            if (logLineString == null) continue;
            try {
                previousLogLine = new LogLine(logLineString, ZoneId.systemDefault(), nodeId);
                outputLines.add(previousLogLine);
            }
            catch (Exception e) {
                if (previousLogLine == null) continue;
                previousLogLine.addNonStandardLine(logLineString);
            }
        }
        return outputLines;
    }

    @NonNull
    public static String generateHtmlPage(@NonNull Map<NodeId, List<String>> logLineStrings) {
        Objects.requireNonNull(logLineStrings);
        List<LogLine> logLines = logLineStrings.entrySet().stream().flatMap(entry -> HtmlGenerator.processNodeLogLines((NodeId)entry.getKey(), (List)entry.getValue()).stream()).sorted(Comparator.comparing(LogLine::getTimestamp)).toList();
        HtmlGenerator.setFirstLogTime(logLines);
        CssRuleSetFactory cssFactory = new CssRuleSetFactory();
        HtmlGenerator.createGeneralCssRules(logLines, cssFactory);
        String body = HtmlGenerator.generateBody(logLines, cssFactory);
        StringBuilder htmlBuilder = new StringBuilder().append("\n");
        htmlBuilder.append(HtmlGenerator.generateHead(cssFactory)).append("\n");
        htmlBuilder.append(body).append("\n");
        return new HtmlTagFactory("html", htmlBuilder.toString()).generateTag();
    }
}

