/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.spi;

import com.swirlds.state.spi.ReadableSingletonStateBase;
import com.swirlds.state.spi.SingletonChangeListener;
import com.swirlds.state.spi.WritableSingletonState;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class WritableSingletonStateBase<T>
extends ReadableSingletonStateBase<T>
implements WritableSingletonState<T> {
    private static final Object NULL_VALUE = new Object();
    private Object value;
    private final List<SingletonChangeListener<T>> listeners = new ArrayList<SingletonChangeListener<T>>();

    public WritableSingletonStateBase(int stateId, String label) {
        super(stateId, label);
    }

    public void registerListener(@NonNull SingletonChangeListener<T> listener) {
        Objects.requireNonNull(listener);
        this.listeners.add(listener);
    }

    @Override
    public T get() {
        if (this.isModified()) {
            return this.currentValue();
        }
        return super.get();
    }

    @Override
    public void put(T value) {
        this.value = value == null ? NULL_VALUE : value;
    }

    @Override
    public boolean isModified() {
        return this.value != null;
    }

    public void commit() {
        if (this.isModified()) {
            if (this.currentValue() != null) {
                this.putIntoDataSource(this.currentValue());
                this.listeners.forEach(l -> l.singletonUpdateChange(this.currentValue()));
            } else {
                this.removeFromDataSource();
            }
        }
        this.reset();
    }

    private T currentValue() {
        return (T)(this.value == NULL_VALUE ? null : this.value);
    }

    @Override
    public void reset() {
        this.value = null;
        super.reset();
    }

    protected abstract void putIntoDataSource(@NonNull T var1);

    protected abstract void removeFromDataSource();
}

