/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.test.fixtures;

import com.swirlds.state.spi.WritableKVStateBase;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class MapWritableKVState<K, V>
extends WritableKVStateBase<K, V> {
    private final Map<K, V> backingStore;

    public MapWritableKVState(int stateId, @NonNull String label) {
        this(stateId, label, new HashMap());
    }

    public MapWritableKVState(int stateId, String label, @NonNull Map<K, V> backingStore) {
        super(stateId, Objects.requireNonNull(label));
        this.backingStore = Objects.requireNonNull(backingStore);
    }

    protected V readFromDataSource(@NonNull K key) {
        return this.backingStore.get(key);
    }

    @NonNull
    protected Iterator<K> iterateFromDataSource() {
        return this.backingStore.keySet().iterator();
    }

    protected void putIntoDataSource(@NonNull K key, @NonNull V value) {
        this.backingStore.put(key, value);
    }

    protected void removeFromDataSource(@NonNull K key) {
        this.backingStore.remove(key);
    }

    public Map<K, V> getBackingStore() {
        return this.backingStore;
    }

    @NonNull
    public long sizeOfDataSource() {
        return this.backingStore.size();
    }

    public String toString() {
        return "MapWritableKVState{backingStore=" + String.valueOf(this.backingStore) + "}";
    }

    public static <K, V> Builder<K, V> builder(int stateId, @NonNull String label) {
        return new Builder(stateId, Objects.requireNonNull(label));
    }

    public static final class Builder<K, V> {
        private final int stateId;
        private final String label;
        private final Map<K, V> backingStore = new HashMap();

        public Builder(int stateId, @NonNull String label) {
            this.stateId = stateId;
            this.label = Objects.requireNonNull(label);
        }

        public Builder<K, V> value(@NonNull K key, @Nullable V value) {
            this.backingStore.put(key, value);
            return this;
        }

        public MapWritableKVState<K, V> build() {
            return new MapWritableKVState<K, V>(this.stateId, this.label, new HashMap<K, V>(this.backingStore));
        }
    }
}

