/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util;

public class AndroidPlatform {
    private static int getSdkInt() {
        try {
            return Class.forName("android.os.Build$VERSION").getField("SDK_INT").getInt(null);
        }
        catch (ReflectiveOperationException e) {
            return 0;
        }
    }

    private static int getExtensionVersion(int sdk) {
        try {
            return (Integer)Class.forName("android.os.ext.SdkExtensions").getMethod("getExtensionVersion", Integer.TYPE).invoke(null, sdk);
        }
        catch (ReflectiveOperationException e) {
            return 0;
        }
    }

    public static boolean isStackWalkerUsable() {
        return AndroidPlatform.getSdkInt() >= 36 || AndroidPlatform.getSdkInt() >= 31 && AndroidPlatform.getExtensionVersion(31) >= 17;
    }
}

