/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.builder;

import com.swirlds.common.merkle.utility.SerializableLong;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import com.swirlds.platform.SwirldsPlatform;
import com.swirlds.platform.builder.PlatformBuildingBlocks;
import com.swirlds.platform.builder.internal.StaticPlatformBuilder;
import com.swirlds.platform.components.appcomm.DefaultLatestCompleteStateNotifier;
import com.swirlds.platform.components.appcomm.LatestCompleteStateNotifier;
import com.swirlds.platform.components.consensus.ConsensusEngine;
import com.swirlds.platform.components.consensus.DefaultConsensusEngine;
import com.swirlds.platform.config.StateConfig;
import com.swirlds.platform.crypto.CryptoStatic;
import com.swirlds.platform.event.branching.BranchDetector;
import com.swirlds.platform.event.branching.BranchReporter;
import com.swirlds.platform.event.branching.DefaultBranchDetector;
import com.swirlds.platform.event.branching.DefaultBranchReporter;
import com.swirlds.platform.event.deduplication.EventDeduplicator;
import com.swirlds.platform.event.deduplication.StandardEventDeduplicator;
import com.swirlds.platform.event.orphan.DefaultOrphanBuffer;
import com.swirlds.platform.event.orphan.OrphanBuffer;
import com.swirlds.platform.event.preconsensus.DefaultInlinePcesWriter;
import com.swirlds.platform.event.preconsensus.InlinePcesWriter;
import com.swirlds.platform.event.preconsensus.PcesConfig;
import com.swirlds.platform.event.preconsensus.PcesFileManager;
import com.swirlds.platform.event.preconsensus.PcesUtilities;
import com.swirlds.platform.event.stream.ConsensusEventStream;
import com.swirlds.platform.event.stream.DefaultConsensusEventStream;
import com.swirlds.platform.event.validation.DefaultEventSignatureValidator;
import com.swirlds.platform.event.validation.DefaultInternalEventValidator;
import com.swirlds.platform.event.validation.EventSignatureValidator;
import com.swirlds.platform.event.validation.InternalEventValidator;
import com.swirlds.platform.eventhandling.DefaultTransactionHandler;
import com.swirlds.platform.eventhandling.DefaultTransactionPrehandler;
import com.swirlds.platform.eventhandling.TransactionHandler;
import com.swirlds.platform.eventhandling.TransactionPrehandler;
import com.swirlds.platform.gossip.SyncGossipModular;
import com.swirlds.platform.gui.internal.BrowserWindowManager;
import com.swirlds.platform.state.hasher.DefaultStateHasher;
import com.swirlds.platform.state.hasher.StateHasher;
import com.swirlds.platform.state.hashlogger.DefaultHashLogger;
import com.swirlds.platform.state.hashlogger.HashLogger;
import com.swirlds.platform.state.iss.DefaultIssDetector;
import com.swirlds.platform.state.iss.IssDetector;
import com.swirlds.platform.state.iss.IssHandler;
import com.swirlds.platform.state.iss.IssScratchpad;
import com.swirlds.platform.state.iss.internal.DefaultIssHandler;
import com.swirlds.platform.state.signed.DefaultSignedStateSentinel;
import com.swirlds.platform.state.signed.DefaultStateGarbageCollector;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.state.signed.SignedState;
import com.swirlds.platform.state.signed.SignedStateSentinel;
import com.swirlds.platform.state.signed.StateGarbageCollector;
import com.swirlds.platform.state.signer.DefaultStateSigner;
import com.swirlds.platform.state.signer.StateSigner;
import com.swirlds.platform.state.snapshot.DefaultStateSnapshotManager;
import com.swirlds.platform.state.snapshot.StateSnapshotManager;
import com.swirlds.platform.system.DefaultPlatformMonitor;
import com.swirlds.platform.system.Platform;
import com.swirlds.platform.system.PlatformMonitor;
import com.swirlds.platform.system.SystemExitUtils;
import com.swirlds.platform.util.MetricsDocUtils;
import com.swirlds.platform.wiring.components.Gossip;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.ServiceLoader;
import org.hiero.consensus.crypto.DefaultEventHasher;
import org.hiero.consensus.crypto.EventHasher;
import org.hiero.consensus.crypto.PlatformSigner;
import org.hiero.consensus.event.creator.EventCreatorModule;
import org.hiero.consensus.model.transaction.EventTransactionSupplier;
import org.hiero.consensus.model.transaction.SignatureTransactionCheck;

public class PlatformComponentBuilder {
    private final PlatformBuildingBlocks blocks;
    private EventHasher eventHasher;
    private InternalEventValidator internalEventValidator;
    private EventDeduplicator eventDeduplicator;
    private EventSignatureValidator eventSignatureValidator;
    private StateGarbageCollector stateGarbageCollector;
    private OrphanBuffer orphanBuffer;
    private EventCreatorModule eventCreator;
    private ConsensusEngine consensusEngine;
    private ConsensusEventStream consensusEventStream;
    private SignedStateSentinel signedStateSentinel;
    private PlatformMonitor platformMonitor;
    private TransactionPrehandler transactionPrehandler;
    private InlinePcesWriter inlinePcesWriter;
    private IssDetector issDetector;
    private IssHandler issHandler;
    private Gossip gossip;
    private StateHasher stateHasher;
    private StateSnapshotManager stateSnapshotManager;
    private HashLogger hashLogger;
    private BranchDetector branchDetector;
    private BranchReporter branchReporter;
    private StateSigner stateSigner;
    private TransactionHandler transactionHandler;
    private LatestCompleteStateNotifier latestCompleteStateNotifier;
    private SwirldsPlatform swirldsPlatform;
    private boolean metricsDocumentationEnabled = true;
    private boolean used;

    public PlatformComponentBuilder(@NonNull PlatformBuildingBlocks blocks) {
        this.blocks = Objects.requireNonNull(blocks);
    }

    @NonNull
    public PlatformBuildingBlocks getBuildingBlocks() {
        return this.blocks;
    }

    private void throwIfAlreadyUsed() {
        if (this.used) {
            throw new IllegalStateException("PlatformBuilder has already been used");
        }
    }

    @NonNull
    public Platform build() {
        this.throwIfAlreadyUsed();
        this.used = true;
        try {
            ReservedSignedState initialState = this.blocks.initialState();
            try {
                SwirldsPlatform swirldsPlatform = this.swirldsPlatform = new SwirldsPlatform(this);
                if (initialState != null) {
                    initialState.close();
                }
                return swirldsPlatform;
            }
            catch (Throwable throwable) {
                if (initialState != null) {
                    try {
                        initialState.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            if (this.metricsDocumentationEnabled && this.blocks.firstPlatform()) {
                MetricsDocUtils.writeMetricsDocumentToFile(StaticPlatformBuilder.getGlobalMetrics(), BrowserWindowManager.getPlatforms(), this.blocks.platformContext().getConfiguration());
                StaticPlatformBuilder.getMetricsProvider().start();
            }
        }
    }

    @NonNull
    public PlatformComponentBuilder withMetricsDocumentationEnabled(boolean metricsDocumentationEnabled) {
        this.throwIfAlreadyUsed();
        this.metricsDocumentationEnabled = metricsDocumentationEnabled;
        return this;
    }

    @NonNull
    public PlatformComponentBuilder withEventHasher(@NonNull EventHasher eventHasher) {
        this.throwIfAlreadyUsed();
        if (this.eventHasher != null) {
            throw new IllegalStateException("Event hasher has already been set");
        }
        this.eventHasher = Objects.requireNonNull(eventHasher);
        return this;
    }

    @NonNull
    public EventHasher buildEventHasher() {
        if (this.eventHasher == null) {
            this.eventHasher = new DefaultEventHasher();
        }
        return this.eventHasher;
    }

    @NonNull
    public PlatformComponentBuilder withInternalEventValidator(@NonNull InternalEventValidator internalEventValidator) {
        this.throwIfAlreadyUsed();
        if (this.internalEventValidator != null) {
            throw new IllegalStateException("Internal event validator has already been set");
        }
        this.internalEventValidator = Objects.requireNonNull(internalEventValidator);
        return this;
    }

    @NonNull
    public InternalEventValidator buildInternalEventValidator() {
        if (this.internalEventValidator == null) {
            boolean singleNodeNetwork = this.blocks.rosterHistory().getCurrentRoster().rosterEntries().size() == 1;
            this.internalEventValidator = new DefaultInternalEventValidator(this.blocks.platformContext(), singleNodeNetwork, this.blocks.intakeEventCounter(), this.blocks.execution().getTransactionLimits());
        }
        return this.internalEventValidator;
    }

    @NonNull
    public PlatformComponentBuilder withEventDeduplicator(@NonNull EventDeduplicator eventDeduplicator) {
        this.throwIfAlreadyUsed();
        if (this.eventDeduplicator != null) {
            throw new IllegalStateException("Event deduplicator has already been set");
        }
        this.eventDeduplicator = Objects.requireNonNull(eventDeduplicator);
        return this;
    }

    @NonNull
    public EventDeduplicator buildEventDeduplicator() {
        if (this.eventDeduplicator == null) {
            this.eventDeduplicator = new StandardEventDeduplicator(this.blocks.platformContext(), this.blocks.intakeEventCounter());
        }
        return this.eventDeduplicator;
    }

    @NonNull
    public PlatformComponentBuilder withEventSignatureValidator(@NonNull EventSignatureValidator eventSignatureValidator) {
        this.throwIfAlreadyUsed();
        if (this.eventSignatureValidator != null) {
            throw new IllegalStateException("Event signature validator has already been set");
        }
        this.eventSignatureValidator = Objects.requireNonNull(eventSignatureValidator);
        return this;
    }

    @NonNull
    public EventSignatureValidator buildEventSignatureValidator() {
        if (this.eventSignatureValidator == null) {
            this.eventSignatureValidator = new DefaultEventSignatureValidator(this.blocks.platformContext(), CryptoStatic::verifySignature, this.blocks.rosterHistory(), this.blocks.intakeEventCounter());
        }
        return this.eventSignatureValidator;
    }

    public PlatformComponentBuilder withStateGarbageCollector(@NonNull StateGarbageCollector stateGarbageCollector) {
        this.throwIfAlreadyUsed();
        if (this.stateGarbageCollector != null) {
            throw new IllegalStateException("State garbage collector has already been set");
        }
        this.stateGarbageCollector = Objects.requireNonNull(stateGarbageCollector);
        return this;
    }

    @NonNull
    public StateGarbageCollector buildStateGarbageCollector() {
        if (this.stateGarbageCollector == null) {
            this.stateGarbageCollector = new DefaultStateGarbageCollector(this.blocks.platformContext());
        }
        return this.stateGarbageCollector;
    }

    @NonNull
    public OrphanBuffer buildOrphanBuffer() {
        if (this.orphanBuffer == null) {
            this.orphanBuffer = new DefaultOrphanBuffer(this.blocks.platformContext().getConfiguration(), this.blocks.platformContext().getMetrics(), this.blocks.intakeEventCounter());
        }
        return this.orphanBuffer;
    }

    @NonNull
    public PlatformComponentBuilder withOrphanBuffer(@NonNull OrphanBuffer orphanBuffer) {
        this.throwIfAlreadyUsed();
        if (this.orphanBuffer != null) {
            throw new IllegalStateException("Orphan buffer has already been set");
        }
        this.orphanBuffer = Objects.requireNonNull(orphanBuffer);
        return this;
    }

    @NonNull
    public PlatformComponentBuilder withEventCreator(@NonNull EventCreatorModule eventCreator) {
        this.throwIfAlreadyUsed();
        if (this.eventCreator != null) {
            throw new IllegalStateException("Event creation manager has already been set");
        }
        this.eventCreator = Objects.requireNonNull(eventCreator);
        return this;
    }

    @NonNull
    public EventCreatorModule buildEventCreator() {
        if (this.eventCreator == null) {
            this.eventCreator = ServiceLoader.load(EventCreatorModule.class).stream().findFirst().orElseThrow(() -> new IllegalStateException("No EventCreatorModule implementation found!")).get();
        }
        this.eventCreator.initialize(this.blocks.platformContext().getConfiguration(), this.blocks.platformContext().getMetrics(), this.blocks.platformContext().getTime(), this.blocks.secureRandomSupplier().get(), this.blocks.keysAndCerts(), this.blocks.rosterHistory().getCurrentRoster(), this.blocks.selfId(), (EventTransactionSupplier)this.blocks.execution(), (SignatureTransactionCheck)this.blocks.execution());
        return this.eventCreator;
    }

    @NonNull
    public PlatformComponentBuilder withConsensusEngine(@NonNull ConsensusEngine consensusEngine) {
        this.throwIfAlreadyUsed();
        if (this.consensusEngine != null) {
            throw new IllegalStateException("Consensus engine has already been set");
        }
        this.consensusEngine = Objects.requireNonNull(consensusEngine);
        return this;
    }

    @NonNull
    public ConsensusEngine buildConsensusEngine() {
        if (this.consensusEngine == null) {
            this.consensusEngine = new DefaultConsensusEngine(this.blocks.platformContext(), this.blocks.rosterHistory().getCurrentRoster(), this.blocks.selfId(), this.blocks.freezeCheckHolder());
        }
        return this.consensusEngine;
    }

    @NonNull
    public PlatformComponentBuilder withConsensusEventStream(@NonNull ConsensusEventStream consensusEventStream) {
        this.throwIfAlreadyUsed();
        if (this.consensusEventStream != null) {
            throw new IllegalStateException("Consensus event stream has already been set");
        }
        this.consensusEventStream = Objects.requireNonNull(consensusEventStream);
        return this;
    }

    @NonNull
    public ConsensusEventStream buildConsensusEventStream() {
        if (this.consensusEventStream == null) {
            this.consensusEventStream = new DefaultConsensusEventStream(this.blocks.platformContext(), this.blocks.selfId(), data -> new PlatformSigner(this.blocks.keysAndCerts()).sign(data), this.blocks.consensusEventStreamName(), event -> event.isLastInRoundReceived() && this.blocks.freezeCheckHolder().isInFreezePeriod(event.getPlatformEvent().getConsensusTimestamp()));
        }
        return this.consensusEventStream;
    }

    @NonNull
    public PlatformComponentBuilder withPlatformMonitor(@NonNull PlatformMonitor platformMonitor) {
        this.throwIfAlreadyUsed();
        if (this.platformMonitor != null) {
            throw new IllegalStateException("Status state machine has already been set");
        }
        this.platformMonitor = Objects.requireNonNull(platformMonitor);
        return this;
    }

    @NonNull
    public PlatformMonitor buildPlatformMonitor() {
        if (this.platformMonitor == null) {
            this.platformMonitor = new DefaultPlatformMonitor(this.blocks.platformContext(), this.blocks.selfId());
        }
        return this.platformMonitor;
    }

    @NonNull
    public PlatformComponentBuilder withSignedStateSentinel(@NonNull SignedStateSentinel signedStateSentinel) {
        this.throwIfAlreadyUsed();
        if (this.signedStateSentinel != null) {
            throw new IllegalStateException("Signed state sentinel has already been set");
        }
        this.signedStateSentinel = Objects.requireNonNull(signedStateSentinel);
        return this;
    }

    @NonNull
    public SignedStateSentinel buildSignedStateSentinel() {
        if (this.signedStateSentinel == null) {
            this.signedStateSentinel = new DefaultSignedStateSentinel(this.blocks.platformContext());
        }
        return this.signedStateSentinel;
    }

    @NonNull
    public PlatformComponentBuilder withTransactionPrehandler(@NonNull TransactionPrehandler transactionPrehandler) {
        this.throwIfAlreadyUsed();
        if (this.transactionPrehandler != null) {
            throw new IllegalStateException("Transaction prehandler has already been set");
        }
        this.transactionPrehandler = Objects.requireNonNull(transactionPrehandler);
        return this;
    }

    @NonNull
    public TransactionPrehandler buildTransactionPrehandler() {
        if (this.transactionPrehandler == null) {
            this.transactionPrehandler = new DefaultTransactionPrehandler(this.blocks.platformContext(), () -> this.blocks.latestImmutableStateProviderReference().get().apply("transaction prehandle"), this.blocks.consensusStateEventHandler());
        }
        return this.transactionPrehandler;
    }

    @NonNull
    public PlatformComponentBuilder withInlinePcesWriter(@NonNull InlinePcesWriter inlinePcesWriter) {
        this.throwIfAlreadyUsed();
        if (this.inlinePcesWriter != null) {
            throw new IllegalStateException("Inline PCES writer has already been set");
        }
        this.inlinePcesWriter = Objects.requireNonNull(inlinePcesWriter);
        return this;
    }

    @NonNull
    public InlinePcesWriter buildInlinePcesWriter() {
        if (this.inlinePcesWriter == null) {
            try {
                PcesFileManager preconsensusEventFileManager = new PcesFileManager(this.blocks.platformContext(), this.blocks.initialPcesFiles(), PcesUtilities.getDatabaseDirectory(this.blocks.platformContext().getConfiguration(), this.blocks.selfId()), this.blocks.initialState().get().getRound());
                this.inlinePcesWriter = new DefaultInlinePcesWriter(this.blocks.platformContext(), preconsensusEventFileManager, this.blocks.selfId());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return this.inlinePcesWriter;
    }

    @NonNull
    public PlatformComponentBuilder withIssDetector(@NonNull IssDetector issDetector) {
        this.throwIfAlreadyUsed();
        if (this.issDetector != null) {
            throw new IllegalStateException("ISS detector has already been set");
        }
        this.issDetector = Objects.requireNonNull(issDetector);
        return this;
    }

    @NonNull
    public IssDetector buildIssDetector() {
        if (this.issDetector == null) {
            SerializableLong issRound = (SerializableLong)this.blocks.issScratchpad().get(IssScratchpad.LAST_ISS_ROUND);
            boolean forceIgnorePcesSignatures = ((PcesConfig)this.blocks.platformContext().getConfiguration().getConfigData(PcesConfig.class)).forceIgnorePcesSignatures();
            long initialStateRound = this.blocks.initialState().get().getRound();
            boolean ignorePreconsensusSignatures = forceIgnorePcesSignatures ? true : issRound != null && issRound.getValue() >= initialStateRound;
            long roundToIgnore = ((StateConfig)this.blocks.platformContext().getConfiguration().getConfigData(StateConfig.class)).validateInitialState() ? -1L : initialStateRound;
            long latestFreezeRound = this.blocks.platformStateFacade().latestFreezeRoundOf((State)this.blocks.initialState().get().getState());
            this.issDetector = new DefaultIssDetector(this.blocks.platformContext(), this.blocks.rosterHistory().getCurrentRoster(), ignorePreconsensusSignatures, roundToIgnore, latestFreezeRound);
        }
        return this.issDetector;
    }

    @NonNull
    public PlatformComponentBuilder withIssHandler(@NonNull IssHandler issHandler) {
        this.throwIfAlreadyUsed();
        if (this.issHandler != null) {
            throw new IllegalStateException("ISS handler has already been set");
        }
        this.issHandler = Objects.requireNonNull(issHandler);
        return this;
    }

    @NonNull
    public IssHandler buildIssHandler() {
        if (this.issHandler == null) {
            this.issHandler = new DefaultIssHandler(this.blocks.platformContext(), SystemExitUtils::handleFatalError, this.blocks.issScratchpad());
        }
        return this.issHandler;
    }

    @NonNull
    public PlatformComponentBuilder withGossip(@NonNull Gossip gossip) {
        this.throwIfAlreadyUsed();
        if (this.gossip != null) {
            throw new IllegalStateException("Gossip has already been set");
        }
        this.gossip = Objects.requireNonNull(gossip);
        return this;
    }

    @NonNull
    public Gossip buildGossip() {
        if (this.gossip == null) {
            this.gossip = new SyncGossipModular(this.blocks.platformContext(), AdHocThreadManager.getStaticThreadManager(), this.blocks.keysAndCerts(), this.blocks.rosterHistory().getCurrentRoster(), this.blocks.selfId(), this.blocks.appVersion(), this.blocks.swirldStateManager(), () -> this.blocks.getLatestCompleteStateReference().get().get(), x -> this.blocks.statusActionSubmitterReference().get().submitStatusAction(x), state -> this.blocks.loadReconnectStateReference().get().accept((SignedState)state), () -> this.blocks.clearAllPipelinesForReconnectReference().get().run(), this.blocks.intakeEventCounter(), this.blocks.platformStateFacade(), this.blocks.createStateFromVirtualMap());
        }
        return this.gossip;
    }

    @NonNull
    public PlatformComponentBuilder withStateHasher(@NonNull StateHasher stateHasher) {
        this.throwIfAlreadyUsed();
        if (this.stateHasher != null) {
            throw new IllegalStateException("Signed state hasher has already been set");
        }
        this.stateHasher = Objects.requireNonNull(stateHasher);
        return this;
    }

    @NonNull
    public StateHasher buildStateHasher() {
        if (this.stateHasher == null) {
            this.stateHasher = new DefaultStateHasher(this.blocks.platformContext());
        }
        return this.stateHasher;
    }

    @NonNull
    public PlatformComponentBuilder withStateSnapshotManager(@NonNull StateSnapshotManager stateSnapshotManager) {
        this.throwIfAlreadyUsed();
        if (this.stateSnapshotManager != null) {
            throw new IllegalStateException("State snapshot manager has already been set");
        }
        this.stateSnapshotManager = Objects.requireNonNull(stateSnapshotManager);
        return this;
    }

    @NonNull
    public StateSnapshotManager buildStateSnapshotManager() {
        if (this.stateSnapshotManager == null) {
            StateConfig stateConfig = (StateConfig)this.blocks.platformContext().getConfiguration().getConfigData(StateConfig.class);
            String actualMainClassName = stateConfig.getMainClassName(this.blocks.mainClassName());
            this.stateSnapshotManager = new DefaultStateSnapshotManager(this.blocks.platformContext(), actualMainClassName, this.blocks.selfId(), this.blocks.swirldName(), this.blocks.platformStateFacade());
        }
        return this.stateSnapshotManager;
    }

    @NonNull
    public PlatformComponentBuilder withHashLogger(@NonNull HashLogger hashLogger) {
        this.throwIfAlreadyUsed();
        if (this.hashLogger != null) {
            throw new IllegalStateException("Hash logger has already been set");
        }
        this.hashLogger = Objects.requireNonNull(hashLogger);
        return this;
    }

    @NonNull
    public HashLogger buildHashLogger() {
        if (this.hashLogger == null) {
            this.hashLogger = new DefaultHashLogger(this.blocks.platformContext(), this.blocks.platformStateFacade());
        }
        return this.hashLogger;
    }

    @NonNull
    public PlatformComponentBuilder withBranchDetector(@NonNull BranchDetector branchDetector) {
        this.throwIfAlreadyUsed();
        if (this.branchDetector != null) {
            throw new IllegalStateException("Branch detector has already been set");
        }
        this.branchDetector = Objects.requireNonNull(branchDetector);
        return this;
    }

    @NonNull
    public BranchDetector buildBranchDetector() {
        if (this.branchDetector == null) {
            this.branchDetector = new DefaultBranchDetector(this.blocks.rosterHistory().getCurrentRoster());
        }
        return this.branchDetector;
    }

    @NonNull
    public PlatformComponentBuilder withBranchReporter(@NonNull BranchReporter branchReporter) {
        this.throwIfAlreadyUsed();
        if (this.branchReporter != null) {
            throw new IllegalStateException("Branch reporter has already been set");
        }
        this.branchReporter = Objects.requireNonNull(branchReporter);
        return this;
    }

    @NonNull
    public BranchReporter buildBranchReporter() {
        if (this.branchReporter == null) {
            this.branchReporter = new DefaultBranchReporter(this.blocks.platformContext(), this.blocks.rosterHistory().getCurrentRoster());
        }
        return this.branchReporter;
    }

    public PlatformComponentBuilder withStateSigner(@NonNull StateSigner stateSigner) {
        this.throwIfAlreadyUsed();
        if (this.stateSigner != null) {
            throw new IllegalStateException("State signer has already been set");
        }
        this.stateSigner = Objects.requireNonNull(stateSigner);
        return this;
    }

    @NonNull
    public StateSigner buildStateSigner() {
        if (this.stateSigner == null) {
            this.stateSigner = new DefaultStateSigner(new PlatformSigner(this.blocks.keysAndCerts()));
        }
        return this.stateSigner;
    }

    @NonNull
    public PlatformComponentBuilder withTransactionHandler(@NonNull TransactionHandler transactionHandler) {
        this.throwIfAlreadyUsed();
        if (this.transactionHandler != null) {
            throw new IllegalStateException("Transaction handler has already been set");
        }
        this.transactionHandler = Objects.requireNonNull(transactionHandler);
        return this;
    }

    @NonNull
    public TransactionHandler buildTransactionHandler() {
        if (this.transactionHandler == null) {
            this.transactionHandler = new DefaultTransactionHandler(this.blocks.platformContext(), this.blocks.swirldStateManager(), this.blocks.statusActionSubmitterReference().get(), this.blocks.appVersion(), this.blocks.platformStateFacade());
        }
        return this.transactionHandler;
    }

    @NonNull
    public PlatformComponentBuilder withLatestCompleteStateNotifier(@NonNull LatestCompleteStateNotifier latestCompleteStateNotifier) {
        this.throwIfAlreadyUsed();
        if (this.latestCompleteStateNotifier != null) {
            throw new IllegalStateException("Latest complete state notifier has already been set");
        }
        this.latestCompleteStateNotifier = Objects.requireNonNull(latestCompleteStateNotifier);
        return this;
    }

    @NonNull
    public LatestCompleteStateNotifier buildLatestCompleteStateNotifier() {
        if (this.latestCompleteStateNotifier == null) {
            this.latestCompleteStateNotifier = new DefaultLatestCompleteStateNotifier();
        }
        return this.latestCompleteStateNotifier;
    }
}

