/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.sync;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.test.fixtures.platform.TestPlatformContextBuilder;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.extensions.test.fixtures.TestConfigBuilder;
import com.swirlds.platform.gossip.sync.SyncInputStream;
import com.swirlds.platform.gossip.sync.SyncOutputStream;
import com.swirlds.platform.network.Connection;
import com.swirlds.platform.network.NetworkUtils;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import org.hiero.consensus.model.node.NodeId;

public class LocalConnection
implements Connection {
    private final SyncInputStream dis;
    private final SyncOutputStream dos;
    private final NodeId selfId;
    private final NodeId otherId;
    private final boolean outbound;
    private boolean connected = true;
    final Configuration configuration = new TestConfigBuilder().withValue("socket.gzipCompression", false).getOrCreateConfig();
    final PlatformContext platformContext = TestPlatformContextBuilder.create().withConfiguration(this.configuration).build();

    public LocalConnection(NodeId selfId, NodeId otherId, InputStream in, OutputStream out, int bufferSize, boolean outbound) {
        this.selfId = selfId;
        this.otherId = otherId;
        this.dis = SyncInputStream.createSyncInputStream((PlatformContext)this.platformContext, (InputStream)in, (int)bufferSize);
        this.dos = SyncOutputStream.createSyncOutputStream((PlatformContext)this.platformContext, (OutputStream)out, (int)bufferSize);
        this.outbound = outbound;
    }

    public void disconnect() {
        this.connected = false;
        NetworkUtils.close((Closeable[])new Closeable[]{this.dis, this.dos});
    }

    public NodeId getSelfId() {
        return this.selfId;
    }

    public NodeId getOtherId() {
        return this.otherId;
    }

    public SyncInputStream getDis() {
        return this.dis;
    }

    public SyncOutputStream getDos() {
        return this.dos;
    }

    public boolean connected() {
        return this.connected;
    }

    public int getTimeout() {
        return 0;
    }

    public void setTimeout(long timeoutMillis) {
    }

    public void initForSync() {
    }

    public boolean isOutbound() {
        return this.outbound;
    }

    public String getDescription() {
        return this.generateDescription();
    }
}

