/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.FieldType;
import com.hedera.pbj.runtime.PbjMap;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoWriter;
import com.hedera.pbj.runtime.Utf8Tools;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;

/*
 * Exception performing whole class analysis.
 */
public final class ProtoWriterTools {
    static final int TAG_TYPE_BITS = 3;
    static final int FIXED32_SIZE = 4;
    static final int FIXED64_SIZE = 8;
    private static final int MAX_VARINT_SIZE = 10;

    private ProtoWriterTools() {
    }

    public static ProtoConstants wireType(FieldDefinition field) {
        return switch (field.type()) {
            default -> throw new MatchException(null, null);
            case FieldType.FLOAT -> ProtoConstants.WIRE_TYPE_FIXED_32_BIT;
            case FieldType.DOUBLE -> ProtoConstants.WIRE_TYPE_FIXED_64_BIT;
            case FieldType.INT32, FieldType.INT64, FieldType.SINT32, FieldType.SINT64, FieldType.UINT32, FieldType.UINT64 -> ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG;
            case FieldType.FIXED32, FieldType.SFIXED32 -> ProtoConstants.WIRE_TYPE_FIXED_32_BIT;
            case FieldType.FIXED64, FieldType.SFIXED64 -> ProtoConstants.WIRE_TYPE_FIXED_64_BIT;
            case FieldType.BOOL -> ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG;
            case FieldType.BYTES, FieldType.MESSAGE, FieldType.STRING, FieldType.MAP -> ProtoConstants.WIRE_TYPE_DELIMITED;
            case FieldType.ENUM -> ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG;
        };
    }

    public static void writeTag(WritableSequentialData out, FieldDefinition field) {
        ProtoWriterTools.writeTag(out, field, ProtoWriterTools.wireType(field));
    }

    public static void writeTag(WritableSequentialData out, FieldDefinition field, ProtoConstants wireType) {
        out.writeVarInt(field.number() << 3 | wireType.ordinal(), false);
    }

    private static RuntimeException unsupported() {
        return new RuntimeException("Unsupported field type. Bug in ProtoOutputStream, shouldn't happen.");
    }

    public static void writeInteger(WritableSequentialData out, FieldDefinition field, int value) {
        ProtoWriterTools.writeInteger(out, field, value, true);
    }

    public static void writeInteger(WritableSequentialData out, FieldDefinition field, int value, boolean skipDefault) {
        if (!$assertionsDisabled) {
            switch (field.type()) {
                case INT32: 
                case SINT32: 
                case UINT32: 
                case FIXED32: 
                case SFIXED32: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Not an integer type " + String.valueOf(field)));
                }
            }
        }
        assert (!field.repeated()) : "Use writeIntegerList with repeated types";
        if (skipDefault && !field.oneOf() && value == 0) {
            return;
        }
        switch (field.type()) {
            case INT32: {
                ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG);
                out.writeVarInt(value, false);
                break;
            }
            case UINT32: {
                ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG);
                out.writeVarLong(Integer.toUnsignedLong(value), false);
                break;
            }
            case SINT32: {
                ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG);
                out.writeVarInt(value, true);
                break;
            }
            case FIXED32: 
            case SFIXED32: {
                ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_FIXED_32_BIT);
                out.writeInt(value, ByteOrder.LITTLE_ENDIAN);
                break;
            }
            default: {
                throw ProtoWriterTools.unsupported();
            }
        }
    }

    public static void writeLong(WritableSequentialData out, FieldDefinition field, long value) {
        ProtoWriterTools.writeLong(out, field, value, true);
    }

    public static void writeLong(WritableSequentialData out, FieldDefinition field, long value, boolean skipDefault) {
        if (!$assertionsDisabled) {
            switch (field.type()) {
                case INT64: 
                case SINT64: 
                case UINT64: 
                case FIXED64: 
                case SFIXED64: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Not a long type " + String.valueOf(field)));
                }
            }
        }
        if (!$assertionsDisabled && field.repeated()) {
            throw new AssertionError((Object)"Use writeLongList with repeated types");
        }
        if (skipDefault && !field.oneOf() && value == 0L) {
            return;
        }
        switch (field.type()) {
            case INT64: 
            case UINT64: {
                ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG);
                out.writeVarLong(value, false);
                break;
            }
            case SINT64: {
                ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG);
                out.writeVarLong(value, true);
                break;
            }
            case FIXED64: 
            case SFIXED64: {
                ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_FIXED_64_BIT);
                out.writeLong(value, ByteOrder.LITTLE_ENDIAN);
                break;
            }
            default: {
                throw ProtoWriterTools.unsupported();
            }
        }
    }

    public static void writeFloat(WritableSequentialData out, FieldDefinition field, float value) {
        if (!$assertionsDisabled && field.type() != FieldType.FLOAT) {
            throw new AssertionError((Object)("Not a float type " + String.valueOf(field)));
        }
        if (!$assertionsDisabled && field.repeated()) {
            throw new AssertionError((Object)"Use writeFloatList with repeated types");
        }
        if (!field.oneOf() && value == 0.0f) {
            return;
        }
        ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_FIXED_32_BIT);
        out.writeFloat(value, ByteOrder.LITTLE_ENDIAN);
    }

    public static void writeDouble(WritableSequentialData out, FieldDefinition field, double value) {
        if (!$assertionsDisabled && field.type() != FieldType.DOUBLE) {
            throw new AssertionError((Object)("Not a double type " + String.valueOf(field)));
        }
        if (!$assertionsDisabled && field.repeated()) {
            throw new AssertionError((Object)"Use writeDoubleList with repeated types");
        }
        if (!field.oneOf() && value == 0.0) {
            return;
        }
        ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_FIXED_64_BIT);
        out.writeDouble(value, ByteOrder.LITTLE_ENDIAN);
    }

    public static void writeBoolean(WritableSequentialData out, FieldDefinition field, boolean value) {
        ProtoWriterTools.writeBoolean(out, field, value, true);
    }

    public static void writeBoolean(WritableSequentialData out, FieldDefinition field, boolean value, boolean skipDefault) {
        if (!$assertionsDisabled && field.type() != FieldType.BOOL) {
            throw new AssertionError((Object)("Not a boolean type " + String.valueOf(field)));
        }
        if (!$assertionsDisabled && field.repeated()) {
            throw new AssertionError((Object)"Use writeBooleanList with repeated types");
        }
        if (value || field.oneOf() || !skipDefault) {
            ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG);
            out.writeByte(value ? (byte)1 : 0);
        }
    }

    public static void writeEnum(WritableSequentialData out, FieldDefinition field, EnumWithProtoMetadata enumValue) {
        if (!$assertionsDisabled && field.type() != FieldType.ENUM) {
            throw new AssertionError((Object)("Not an enum type " + String.valueOf(field)));
        }
        if (!$assertionsDisabled && field.repeated()) {
            throw new AssertionError((Object)"Use writeEnumList with repeated types");
        }
        if (!(field.oneOf() || enumValue != null && enumValue.protoOrdinal() != 0)) {
            return;
        }
        ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG);
        out.writeVarInt(enumValue.protoOrdinal(), false);
    }

    public static void writeString(WritableSequentialData out, FieldDefinition field, String value) throws IOException {
        ProtoWriterTools.writeString(out, field, value, true);
    }

    public static void writeString(WritableSequentialData out, FieldDefinition field, String value, boolean skipDefault) throws IOException {
        if (!$assertionsDisabled && field.type() != FieldType.STRING) {
            throw new AssertionError((Object)("Not a string type " + String.valueOf(field)));
        }
        if (!$assertionsDisabled && field.repeated()) {
            throw new AssertionError((Object)"Use writeStringList with repeated types");
        }
        ProtoWriterTools.writeStringNoChecks(out, field, value, skipDefault);
    }

    public static void writeOneRepeatedString(WritableSequentialData out, FieldDefinition field, String value) throws IOException {
        if (!$assertionsDisabled && field.type() != FieldType.STRING) {
            throw new AssertionError((Object)("Not a string type " + String.valueOf(field)));
        }
        if (!$assertionsDisabled && !field.repeated()) {
            throw new AssertionError((Object)"writeOneRepeatedString can only be used with repeated fields");
        }
        ProtoWriterTools.writeStringNoChecks(out, field, value);
    }

    private static void writeStringNoChecks(WritableSequentialData out, FieldDefinition field, String value) throws IOException {
        ProtoWriterTools.writeStringNoChecks(out, field, value, true);
    }

    private static void writeStringNoChecks(WritableSequentialData out, FieldDefinition field, String value, boolean skipDefault) throws IOException {
        if (skipDefault && !field.oneOf() && (value == null || value.isEmpty())) {
            return;
        }
        ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_DELIMITED);
        out.writeVarInt(ProtoWriterTools.sizeOfStringNoTag(value), false);
        Utf8Tools.encodeUtf8(value, out);
    }

    public static void writeBytes(WritableSequentialData out, FieldDefinition field, RandomAccessData value) throws IOException {
        ProtoWriterTools.writeBytes(out, field, value, true);
    }

    public static void writeBytes(WritableSequentialData out, FieldDefinition field, RandomAccessData value, boolean skipDefault) throws IOException {
        if (!$assertionsDisabled && field.type() != FieldType.BYTES) {
            throw new AssertionError((Object)("Not a byte[] type " + String.valueOf(field)));
        }
        if (!$assertionsDisabled && field.repeated()) {
            throw new AssertionError((Object)"Use writeBytesList with repeated types");
        }
        ProtoWriterTools.writeBytesNoChecks(out, field, value, skipDefault);
    }

    public static void writeOneRepeatedBytes(WritableSequentialData out, FieldDefinition field, RandomAccessData value) throws IOException {
        if (!$assertionsDisabled && field.type() != FieldType.BYTES) {
            throw new AssertionError((Object)("Not a byte[] type " + String.valueOf(field)));
        }
        if (!$assertionsDisabled && !field.repeated()) {
            throw new AssertionError((Object)"writeOneRepeatedBytes can only be used with repeated fields");
        }
        ProtoWriterTools.writeBytesNoChecks(out, field, value, true);
    }

    private static void writeBytesNoChecks(WritableSequentialData out, FieldDefinition field, RandomAccessData value, boolean skipZeroLength) throws IOException {
        if (!field.oneOf() && skipZeroLength && value.length() == 0L) {
            return;
        }
        ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_DELIMITED);
        out.writeVarInt(Math.toIntExact(value.length()), false);
        long posBefore = out.position();
        out.writeBytes(value);
        long bytesWritten = out.position() - posBefore;
        if (bytesWritten != value.length()) {
            throw new IOException("Wrote less bytes [" + bytesWritten + "] than expected [" + value.length() + "]");
        }
    }

    public static <T> void writeMessage(WritableSequentialData out, FieldDefinition field, T message, Codec<T> codec) throws IOException {
        if (!$assertionsDisabled && field.type() != FieldType.MESSAGE) {
            throw new AssertionError((Object)("Not a message type " + String.valueOf(field)));
        }
        if (!$assertionsDisabled && field.repeated()) {
            throw new AssertionError((Object)"Use writeMessageList with repeated types");
        }
        ProtoWriterTools.writeMessageNoChecks(out, field, message, codec);
    }

    public static <T> void writeOneRepeatedMessage(WritableSequentialData out, FieldDefinition field, T message, Codec<T> codec) throws IOException {
        if (!$assertionsDisabled && field.type() != FieldType.MESSAGE) {
            throw new AssertionError((Object)("Not a message type " + String.valueOf(field)));
        }
        if (!$assertionsDisabled && !field.repeated()) {
            throw new AssertionError((Object)"writeOneRepeatedMessage can only be used with repeated fields");
        }
        ProtoWriterTools.writeMessageNoChecks(out, field, message, codec);
    }

    private static <T> void writeMessageNoChecks(WritableSequentialData out, FieldDefinition field, T message, Codec<T> codec) throws IOException {
        if (field.oneOf() && message == null) {
            ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_DELIMITED);
            out.writeVarInt(0, false);
        } else if (message != null) {
            ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_DELIMITED);
            int size = codec.measureRecord(message);
            out.writeVarInt(size, false);
            if (size > 0) {
                codec.write(message, out);
            }
        }
    }

    public static <K, V> void writeMap(WritableSequentialData out, FieldDefinition field, @NonNull PbjMap<K, V> map, ProtoWriter<K> kWriter, ProtoWriter<V> vWriter, ToIntFunction<K> sizeOfK, ToIntFunction<V> sizeOfV) throws IOException {
        if (map.isEmpty()) {
            return;
        }
        int size = map.size();
        for (int i = 0; i < size; ++i) {
            K k = map.getSortedKeys().get(i);
            V v = map.get(k);
            ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_DELIMITED);
            int sizeK = sizeOfK.applyAsInt(k);
            int sizeV = sizeOfV.applyAsInt(v);
            out.writeVarInt(sizeK + sizeV, false);
            kWriter.write(k, out);
            vWriter.write(v, out);
        }
    }

    public static void writeOptionalInteger(WritableSequentialData out, FieldDefinition field, @Nullable Integer value) {
        if (value != null) {
            ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_DELIMITED);
            FieldDefinition newField = field.type().optionalFieldDefinition;
            out.writeVarInt(ProtoWriterTools.sizeOfInteger(newField, value), false);
            ProtoWriterTools.writeInteger(out, newField, value);
        }
    }

    public static void writeOptionalLong(WritableSequentialData out, FieldDefinition field, @Nullable Long value) {
        if (value != null) {
            ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_DELIMITED);
            FieldDefinition newField = field.type().optionalFieldDefinition;
            out.writeVarInt(ProtoWriterTools.sizeOfLong(newField, value), false);
            ProtoWriterTools.writeLong(out, newField, value);
        }
    }

    public static void writeOptionalFloat(WritableSequentialData out, FieldDefinition field, @Nullable Float value) {
        if (value != null) {
            ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_DELIMITED);
            FieldDefinition newField = field.type().optionalFieldDefinition;
            out.writeVarInt(ProtoWriterTools.sizeOfFloat(newField, value.floatValue()), false);
            ProtoWriterTools.writeFloat(out, newField, value.floatValue());
        }
    }

    public static void writeOptionalDouble(WritableSequentialData out, FieldDefinition field, @Nullable Double value) {
        if (value != null) {
            ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_DELIMITED);
            FieldDefinition newField = field.type().optionalFieldDefinition;
            out.writeVarInt(ProtoWriterTools.sizeOfDouble(newField, value), false);
            ProtoWriterTools.writeDouble(out, newField, value);
        }
    }

    public static void writeOptionalBoolean(WritableSequentialData out, FieldDefinition field, @Nullable Boolean value) {
        if (value != null) {
            ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_DELIMITED);
            FieldDefinition newField = field.type().optionalFieldDefinition;
            out.writeVarInt(ProtoWriterTools.sizeOfBoolean(newField, value), false);
            ProtoWriterTools.writeBoolean(out, newField, value);
        }
    }

    public static void writeOptionalString(WritableSequentialData out, FieldDefinition field, @Nullable String value) throws IOException {
        if (value != null) {
            ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_DELIMITED);
            FieldDefinition newField = field.type().optionalFieldDefinition;
            out.writeVarInt(ProtoWriterTools.sizeOfString(newField, value), false);
            ProtoWriterTools.writeString(out, newField, value);
        }
    }

    public static void writeOptionalBytes(WritableSequentialData out, FieldDefinition field, @Nullable Bytes value) throws IOException {
        if (value != null) {
            ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_DELIMITED);
            FieldDefinition newField = field.type().optionalFieldDefinition;
            int size = ProtoWriterTools.sizeOfBytes(newField, value);
            out.writeVarInt(size, false);
            if (size > 0) {
                ProtoWriterTools.writeBytes(out, newField, value);
            }
        }
    }

    public static void writeIntegerList(WritableSequentialData out, FieldDefinition field, List<Integer> list) {
        if (!$assertionsDisabled) {
            switch (field.type()) {
                case INT32: 
                case SINT32: 
                case UINT32: 
                case FIXED32: 
                case SFIXED32: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Not an integer type " + String.valueOf(field)));
                }
            }
        }
        if (!$assertionsDisabled && !field.repeated()) {
            throw new AssertionError((Object)"Use writeInteger with non-repeated types");
        }
        if (!field.oneOf() && list.isEmpty()) {
            return;
        }
        int listSize = list.size();
        switch (field.type()) {
            case INT32: {
                int val;
                int i;
                int size = 0;
                for (i = 0; i < listSize; ++i) {
                    val = list.get(i);
                    size += ProtoWriterTools.sizeOfVarInt32(val);
                }
                ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_DELIMITED);
                out.writeVarInt(size, false);
                for (i = 0; i < listSize; ++i) {
                    val = list.get(i);
                    out.writeVarInt(val, false);
                }
                break;
            }
            case UINT32: {
                int val;
                int i;
                int size = 0;
                for (i = 0; i < listSize; ++i) {
                    val = list.get(i);
                    size += ProtoWriterTools.sizeOfUnsignedVarInt64(Integer.toUnsignedLong(val));
                }
                ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_DELIMITED);
                out.writeVarInt(size, false);
                for (i = 0; i < listSize; ++i) {
                    val = list.get(i);
                    out.writeVarLong(Integer.toUnsignedLong(val), false);
                }
                break;
            }
            case SINT32: {
                int val;
                int i;
                int size = 0;
                for (i = 0; i < listSize; ++i) {
                    val = list.get(i);
                    size += ProtoWriterTools.sizeOfUnsignedVarInt64((long)val << 1 ^ (long)val >> 63);
                }
                ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_DELIMITED);
                out.writeVarInt(size, false);
                for (i = 0; i < listSize; ++i) {
                    val = list.get(i);
                    out.writeVarInt(val, true);
                }
                break;
            }
            case FIXED32: 
            case SFIXED32: {
                ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_DELIMITED);
                out.writeVarLong((long)list.size() * 4L, false);
                for (int i = 0; i < listSize; ++i) {
                    int val = list.get(i);
                    out.writeInt(val, ByteOrder.LITTLE_ENDIAN);
                }
                break;
            }
            default: {
                throw ProtoWriterTools.unsupported();
            }
        }
    }

    public static void writeLongList(WritableSequentialData out, FieldDefinition field, List<Long> list) {
        if (!$assertionsDisabled) {
            switch (field.type()) {
                case INT64: 
                case SINT64: 
                case UINT64: 
                case FIXED64: 
                case SFIXED64: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Not a long type " + String.valueOf(field)));
                }
            }
        }
        if (!$assertionsDisabled && !field.repeated()) {
            throw new AssertionError((Object)"Use writeLong with non-repeated types");
        }
        if (!field.oneOf() && list.isEmpty()) {
            return;
        }
        int listSize = list.size();
        switch (field.type()) {
            case INT64: 
            case UINT64: {
                long val;
                int i;
                int size = 0;
                for (i = 0; i < listSize; ++i) {
                    val = list.get(i);
                    size += ProtoWriterTools.sizeOfUnsignedVarInt64(val);
                }
                ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_DELIMITED);
                out.writeVarInt(size, false);
                for (i = 0; i < listSize; ++i) {
                    val = list.get(i);
                    out.writeVarLong(val, false);
                }
                break;
            }
            case SINT64: {
                long val;
                int i;
                int size = 0;
                for (i = 0; i < listSize; ++i) {
                    val = list.get(i);
                    size += ProtoWriterTools.sizeOfUnsignedVarInt64(val << 1 ^ val >> 63);
                }
                ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_DELIMITED);
                out.writeVarInt(size, false);
                for (i = 0; i < listSize; ++i) {
                    val = list.get(i);
                    out.writeVarLong(val, true);
                }
                break;
            }
            case FIXED64: 
            case SFIXED64: {
                ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_DELIMITED);
                out.writeVarLong((long)list.size() * 8L, false);
                for (int i = 0; i < listSize; ++i) {
                    long val = list.get(i);
                    out.writeLong(val, ByteOrder.LITTLE_ENDIAN);
                }
                break;
            }
            default: {
                throw ProtoWriterTools.unsupported();
            }
        }
    }

    public static void writeFloatList(WritableSequentialData out, FieldDefinition field, List<Float> list) {
        if (!$assertionsDisabled && field.type() != FieldType.FLOAT) {
            throw new AssertionError((Object)("Not a float type " + String.valueOf(field)));
        }
        if (!$assertionsDisabled && !field.repeated()) {
            throw new AssertionError((Object)"Use writeFloat with non-repeated types");
        }
        if (!field.oneOf() && list.isEmpty()) {
            return;
        }
        int size = list.size() * 4;
        ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_DELIMITED);
        out.writeVarInt(size, false);
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            out.writeFloat(list.get(i).floatValue(), ByteOrder.LITTLE_ENDIAN);
        }
    }

    public static void writeDoubleList(WritableSequentialData out, FieldDefinition field, List<Double> list) {
        if (!$assertionsDisabled && field.type() != FieldType.DOUBLE) {
            throw new AssertionError((Object)("Not a double type " + String.valueOf(field)));
        }
        if (!$assertionsDisabled && !field.repeated()) {
            throw new AssertionError((Object)"Use writeDouble with non-repeated types");
        }
        if (!field.oneOf() && list.isEmpty()) {
            return;
        }
        int size = list.size() * 8;
        ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_DELIMITED);
        out.writeVarInt(size, false);
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            out.writeDouble(list.get(i), ByteOrder.LITTLE_ENDIAN);
        }
    }

    public static void writeBooleanList(WritableSequentialData out, FieldDefinition field, List<Boolean> list) {
        if (!$assertionsDisabled && field.type() != FieldType.BOOL) {
            throw new AssertionError((Object)("Not a boolean type " + String.valueOf(field)));
        }
        if (!$assertionsDisabled && !field.repeated()) {
            throw new AssertionError((Object)"Use writeBoolean with non-repeated types");
        }
        if (!field.oneOf() && list.isEmpty()) {
            return;
        }
        ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_DELIMITED);
        out.writeVarInt(list.size(), false);
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            boolean b = list.get(i);
            out.writeVarInt(b ? 1 : 0, false);
        }
    }

    public static void writeEnumList(WritableSequentialData out, FieldDefinition field, List<? extends EnumWithProtoMetadata> list) {
        int i;
        if (!$assertionsDisabled && field.type() != FieldType.ENUM) {
            throw new AssertionError((Object)("Not an enum type " + String.valueOf(field)));
        }
        if (!$assertionsDisabled && !field.repeated()) {
            throw new AssertionError((Object)"Use writeEnum with non-repeated types");
        }
        if (!field.oneOf() && list.isEmpty()) {
            return;
        }
        int listSize = list.size();
        int size = 0;
        for (i = 0; i < listSize; ++i) {
            size += ProtoWriterTools.sizeOfUnsignedVarInt32(list.get(i).protoOrdinal());
        }
        ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_DELIMITED);
        out.writeVarInt(size, false);
        for (i = 0; i < listSize; ++i) {
            out.writeVarInt(list.get(i).protoOrdinal(), false);
        }
    }

    public static void writeStringList(WritableSequentialData out, FieldDefinition field, List<String> list) throws IOException {
        if (!$assertionsDisabled && field.type() != FieldType.STRING) {
            throw new AssertionError((Object)("Not a string type " + String.valueOf(field)));
        }
        if (!$assertionsDisabled && !field.repeated()) {
            throw new AssertionError((Object)"Use writeString with non-repeated types");
        }
        if (!field.oneOf() && list.isEmpty()) {
            return;
        }
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            String value = list.get(i);
            ProtoWriterTools.writeTag(out, field, ProtoConstants.WIRE_TYPE_DELIMITED);
            out.writeVarInt(ProtoWriterTools.sizeOfStringNoTag(value), false);
            Utf8Tools.encodeUtf8(value, out);
        }
    }

    public static <T> void writeMessageList(WritableSequentialData out, FieldDefinition field, List<T> list, Codec<T> codec) throws IOException {
        if (!$assertionsDisabled && field.type() != FieldType.MESSAGE) {
            throw new AssertionError((Object)("Not a message type " + String.valueOf(field)));
        }
        if (!$assertionsDisabled && !field.repeated()) {
            throw new AssertionError((Object)"Use writeMessage with non-repeated types");
        }
        if (!field.oneOf() && list.isEmpty()) {
            return;
        }
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            ProtoWriterTools.writeMessageNoChecks(out, field, list.get(i), codec);
        }
    }

    public static void writeBytesList(WritableSequentialData out, FieldDefinition field, List<? extends RandomAccessData> list) throws IOException {
        if (!$assertionsDisabled && field.type() != FieldType.BYTES) {
            throw new AssertionError((Object)("Not a message type " + String.valueOf(field)));
        }
        if (!$assertionsDisabled && !field.repeated()) {
            throw new AssertionError((Object)"Use writeBytes with non-repeated types");
        }
        if (!field.oneOf() && list.isEmpty()) {
            return;
        }
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            ProtoWriterTools.writeBytesNoChecks(out, field, list.get(i), false);
        }
    }

    public static <T extends WritableSequentialData> void writeDelimited(T out, FieldDefinition field, int size, Consumer<T> writer) {
        ProtoWriterTools.writeTag(out, field);
        out.writeVarInt(size, false);
        writer.accept(out);
    }

    public static int sizeOfVarInt32(int value) {
        if (value >= 0) {
            return ProtoWriterTools.sizeOfUnsignedVarInt32(value);
        }
        return 10;
    }

    public static int sizeOfVarInt64(long value) {
        return ProtoWriterTools.sizeOfUnsignedVarInt64(value);
    }

    public static int sizeOfUnsignedVarInt32(int value) {
        return ProtoWriterTools.sizeOfUnsignedVarInt64(Integer.toUnsignedLong(value));
    }

    static int sizeOfUnsignedVarInt64(long value) {
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        int clz = Long.numberOfLeadingZeros(value);
        return 640 - clz * 9 >>> 6;
    }

    public static int sizeOfTag(FieldDefinition field) {
        return ProtoWriterTools.sizeOfTag(field, ProtoWriterTools.wireType(field));
    }

    public static int sizeOfTag(FieldDefinition field, ProtoConstants wireType) {
        return ProtoWriterTools.sizeOfVarInt32(field.number() << 3 | wireType.ordinal());
    }

    public static int sizeOfOptionalInteger(FieldDefinition field, @Nullable Integer value) {
        if (value != null) {
            int intValue = value;
            int size = ProtoWriterTools.sizeOfInteger(field.type().optionalFieldDefinition, intValue);
            return ProtoWriterTools.sizeOfTag(field, ProtoConstants.WIRE_TYPE_DELIMITED) + ProtoWriterTools.sizeOfUnsignedVarInt32(size) + size;
        }
        return 0;
    }

    public static int sizeOfOptionalLong(FieldDefinition field, @Nullable Long value) {
        if (value != null) {
            long longValue = value;
            int size = ProtoWriterTools.sizeOfLong(field.type().optionalFieldDefinition, longValue);
            return ProtoWriterTools.sizeOfTag(field, ProtoConstants.WIRE_TYPE_DELIMITED) + ProtoWriterTools.sizeOfUnsignedVarInt32(size) + size;
        }
        return 0;
    }

    public static int sizeOfOptionalFloat(FieldDefinition field, @Nullable Float value) {
        if (value != null) {
            int size = value.floatValue() == 0.0f ? 0 : 5;
            return ProtoWriterTools.sizeOfTag(field, ProtoConstants.WIRE_TYPE_DELIMITED) + ProtoWriterTools.sizeOfUnsignedVarInt32(size) + size;
        }
        return 0;
    }

    public static int sizeOfOptionalDouble(FieldDefinition field, @Nullable Double value) {
        if (value != null) {
            int size = value == 0.0 ? 0 : 9;
            return ProtoWriterTools.sizeOfTag(field, ProtoConstants.WIRE_TYPE_DELIMITED) + ProtoWriterTools.sizeOfUnsignedVarInt32(size) + size;
        }
        return 0;
    }

    public static int sizeOfOptionalBoolean(FieldDefinition field, @Nullable Boolean value) {
        if (value != null) {
            int size = value == false ? 0 : 2;
            return ProtoWriterTools.sizeOfTag(field, ProtoConstants.WIRE_TYPE_DELIMITED) + ProtoWriterTools.sizeOfUnsignedVarInt32(size) + size;
        }
        return 0;
    }

    public static int sizeOfOptionalString(FieldDefinition field, @Nullable String value) {
        if (value != null) {
            int size = ProtoWriterTools.sizeOfString(field.type().optionalFieldDefinition, value);
            return ProtoWriterTools.sizeOfTag(field, ProtoConstants.WIRE_TYPE_DELIMITED) + ProtoWriterTools.sizeOfUnsignedVarInt32(size) + size;
        }
        return 0;
    }

    public static int sizeOfOptionalBytes(FieldDefinition field, @Nullable RandomAccessData value) {
        if (value != null) {
            int size = ProtoWriterTools.sizeOfBytes(field.type().optionalFieldDefinition, value);
            return ProtoWriterTools.sizeOfTag(field, ProtoConstants.WIRE_TYPE_DELIMITED) + ProtoWriterTools.sizeOfUnsignedVarInt32(size) + size;
        }
        return 0;
    }

    public static int sizeOfInteger(FieldDefinition field, int value) {
        return ProtoWriterTools.sizeOfInteger(field, value, true);
    }

    public static int sizeOfInteger(FieldDefinition field, int value, boolean skipDefault) {
        if (skipDefault && !field.oneOf() && value == 0) {
            return 0;
        }
        return switch (field.type()) {
            case FieldType.INT32 -> ProtoWriterTools.sizeOfTag(field, ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG) + ProtoWriterTools.sizeOfVarInt32(value);
            case FieldType.UINT32 -> ProtoWriterTools.sizeOfTag(field, ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG) + ProtoWriterTools.sizeOfUnsignedVarInt32(value);
            case FieldType.SINT32 -> ProtoWriterTools.sizeOfTag(field, ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG) + ProtoWriterTools.sizeOfUnsignedVarInt64((long)value << 1 ^ (long)value >> 63);
            case FieldType.FIXED32, FieldType.SFIXED32 -> ProtoWriterTools.sizeOfTag(field, ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG) + 4;
            default -> throw ProtoWriterTools.unsupported();
        };
    }

    public static int sizeOfLong(FieldDefinition field, long value) {
        return ProtoWriterTools.sizeOfLong(field, value, true);
    }

    public static int sizeOfLong(FieldDefinition field, long value, boolean skipDefault) {
        if (skipDefault && !field.oneOf() && value == 0L) {
            return 0;
        }
        return switch (field.type()) {
            case FieldType.INT64, FieldType.UINT64 -> ProtoWriterTools.sizeOfTag(field, ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG) + ProtoWriterTools.sizeOfUnsignedVarInt64(value);
            case FieldType.SINT64 -> ProtoWriterTools.sizeOfTag(field, ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG) + ProtoWriterTools.sizeOfUnsignedVarInt64(value << 1 ^ value >> 63);
            case FieldType.FIXED64, FieldType.SFIXED64 -> ProtoWriterTools.sizeOfTag(field, ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG) + 8;
            default -> throw ProtoWriterTools.unsupported();
        };
    }

    public static int sizeOfFloat(FieldDefinition field, float value) {
        if (!field.oneOf() && value == 0.0f) {
            return 0;
        }
        return ProtoWriterTools.sizeOfTag(field, ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG) + 4;
    }

    public static int sizeOfDouble(FieldDefinition field, double value) {
        if (!field.oneOf() && value == 0.0) {
            return 0;
        }
        return ProtoWriterTools.sizeOfTag(field, ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG) + 8;
    }

    public static int sizeOfBoolean(FieldDefinition field, boolean value) {
        return ProtoWriterTools.sizeOfBoolean(field, value, true);
    }

    public static int sizeOfBoolean(FieldDefinition field, boolean value, boolean skipDefault) {
        return value || field.oneOf() || !skipDefault ? ProtoWriterTools.sizeOfTag(field, ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG) + 1 : 0;
    }

    public static int sizeOfEnum(FieldDefinition field, EnumWithProtoMetadata enumValue) {
        if (!(field.oneOf() || enumValue != null && enumValue.protoOrdinal() != 0)) {
            return 0;
        }
        return ProtoWriterTools.sizeOfTag(field, ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG) + ProtoWriterTools.sizeOfVarInt32(enumValue.protoOrdinal());
    }

    public static int sizeOfString(FieldDefinition field, String value) {
        return ProtoWriterTools.sizeOfString(field, value, true);
    }

    public static int sizeOfString(FieldDefinition field, String value, boolean skipDefault) {
        if (skipDefault && !field.oneOf() && (value == null || value.isEmpty())) {
            return 0;
        }
        return ProtoWriterTools.sizeOfDelimited(field, ProtoWriterTools.sizeOfStringNoTag(value));
    }

    static int sizeOfStringNoTag(String value) {
        if (value == null || value.isEmpty()) {
            return 0;
        }
        try {
            return Utf8Tools.encodedLength(value);
        }
        catch (IOException e) {
            return value.getBytes(StandardCharsets.UTF_8).length;
        }
    }

    public static int sizeOfBytes(FieldDefinition field, RandomAccessData value) {
        return ProtoWriterTools.sizeOfBytes(field, value, true);
    }

    public static int sizeOfBytes(FieldDefinition field, RandomAccessData value, boolean skipDefault) {
        if (skipDefault && !field.oneOf() && value.length() == 0L) {
            return 0;
        }
        return ProtoWriterTools.sizeOfDelimited(field, (int)value.length());
    }

    public static <T> int sizeOfMessage(FieldDefinition field, T message, Codec<T> codec) {
        if (field.oneOf() && message == null) {
            return ProtoWriterTools.sizeOfTag(field, ProtoConstants.WIRE_TYPE_DELIMITED) + 1;
        }
        if (message != null) {
            int size = codec.measureRecord(message);
            return ProtoWriterTools.sizeOfTag(field, ProtoConstants.WIRE_TYPE_DELIMITED) + ProtoWriterTools.sizeOfVarInt32(size) + size;
        }
        return 0;
    }

    public static int sizeOfIntegerList(FieldDefinition field, List<Integer> list) {
        if (!field.oneOf() && list.isEmpty()) {
            return 0;
        }
        int size = 0;
        int listSize = list.size();
        switch (field.type()) {
            case INT32: {
                for (int i = 0; i < listSize; ++i) {
                    size += ProtoWriterTools.sizeOfVarInt32(list.get(i));
                }
                break;
            }
            case UINT32: {
                for (int i = 0; i < listSize; ++i) {
                    size += ProtoWriterTools.sizeOfUnsignedVarInt32(list.get(i));
                }
                break;
            }
            case SINT32: {
                for (int i = 0; i < listSize; ++i) {
                    long val = list.get(i).intValue();
                    size += ProtoWriterTools.sizeOfUnsignedVarInt64(val << 1 ^ val >> 63);
                }
                break;
            }
            case FIXED32: 
            case SFIXED32: {
                size += 4 * list.size();
                break;
            }
            default: {
                throw ProtoWriterTools.unsupported();
            }
        }
        return ProtoWriterTools.sizeOfTag(field, ProtoConstants.WIRE_TYPE_DELIMITED) + ProtoWriterTools.sizeOfVarInt32(size) + size;
    }

    public static int sizeOfLongList(FieldDefinition field, List<Long> list) {
        if (!field.oneOf() && list.isEmpty()) {
            return 0;
        }
        int size = 0;
        int listSize = list.size();
        switch (field.type()) {
            case INT64: 
            case UINT64: {
                for (int i = 0; i < listSize; ++i) {
                    size += ProtoWriterTools.sizeOfUnsignedVarInt64(list.get(i));
                }
                break;
            }
            case SINT64: {
                for (int i = 0; i < listSize; ++i) {
                    long val = list.get(i);
                    size += ProtoWriterTools.sizeOfUnsignedVarInt64(val << 1 ^ val >> 63);
                }
                break;
            }
            case FIXED64: 
            case SFIXED64: {
                size += 8 * list.size();
                break;
            }
            default: {
                throw ProtoWriterTools.unsupported();
            }
        }
        return ProtoWriterTools.sizeOfTag(field, ProtoConstants.WIRE_TYPE_DELIMITED) + ProtoWriterTools.sizeOfVarInt32(size) + size;
    }

    public static int sizeOfFloatList(FieldDefinition field, List<Float> list) {
        if (!field.oneOf() && list.isEmpty()) {
            return 0;
        }
        int size = 4 * list.size();
        return ProtoWriterTools.sizeOfTag(field, ProtoConstants.WIRE_TYPE_DELIMITED) + ProtoWriterTools.sizeOfVarInt32(size) + size;
    }

    public static int sizeOfDoubleList(FieldDefinition field, List<Double> list) {
        if (!field.oneOf() && list.isEmpty()) {
            return 0;
        }
        int size = 8 * list.size();
        return ProtoWriterTools.sizeOfTag(field, ProtoConstants.WIRE_TYPE_DELIMITED) + ProtoWriterTools.sizeOfVarInt32(size) + size;
    }

    public static int sizeOfBooleanList(FieldDefinition field, List<Boolean> list) {
        if (!field.oneOf() && list.isEmpty()) {
            return 0;
        }
        int size = list.size();
        return ProtoWriterTools.sizeOfTag(field, ProtoConstants.WIRE_TYPE_DELIMITED) + ProtoWriterTools.sizeOfVarInt32(size) + size;
    }

    public static int sizeOfEnumList(FieldDefinition field, List<? extends EnumWithProtoMetadata> list) {
        if (!field.oneOf() && list.isEmpty()) {
            return 0;
        }
        int size = 0;
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            size += ProtoWriterTools.sizeOfUnsignedVarInt64(list.get(i).protoOrdinal());
        }
        return ProtoWriterTools.sizeOfTag(field, ProtoConstants.WIRE_TYPE_DELIMITED) + ProtoWriterTools.sizeOfVarInt32(size) + size;
    }

    public static int sizeOfStringList(FieldDefinition field, List<String> list) {
        int size = 0;
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            size += ProtoWriterTools.sizeOfDelimited(field, ProtoWriterTools.sizeOfStringNoTag(list.get(i)));
        }
        return size;
    }

    public static <T> int sizeOfMessageList(FieldDefinition field, List<T> list, Codec<T> codec) {
        int size = 0;
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            size += ProtoWriterTools.sizeOfMessage(field, list.get(i), codec);
        }
        return size;
    }

    public static int sizeOfBytesList(FieldDefinition field, List<? extends RandomAccessData> list) {
        int size = 0;
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            long valueLength = list.get(i).length();
            size += ProtoWriterTools.sizeOfDelimited(field, Math.toIntExact(valueLength));
        }
        return size;
    }

    public static int sizeOfDelimited(FieldDefinition field, int length) {
        return Math.toIntExact(ProtoWriterTools.sizeOfTag(field, ProtoConstants.WIRE_TYPE_DELIMITED) + ProtoWriterTools.sizeOfVarInt32(length) + length);
    }
}

