/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.recovery.emergencyfile;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.swirlds.platform.config.StateConfig;
import com.swirlds.platform.recovery.emergencyfile.Bootstrap;
import com.swirlds.platform.recovery.emergencyfile.Recovery;
import com.swirlds.platform.recovery.emergencyfile.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Objects;
import org.hiero.base.crypto.Hash;

public record EmergencyRecoveryFile(@NonNull Recovery recovery) {
    private static final String OUTPUT_FILENAME = "emergencyRecovery.yaml";

    public EmergencyRecoveryFile(long round, Hash hash, @NonNull Instant timestamp) {
        this(new Recovery(new State(round, hash, timestamp), null, null, null));
    }

    public EmergencyRecoveryFile(@NonNull State state, @NonNull Instant bootstrapTime) {
        this(new Recovery(state, new Bootstrap(bootstrapTime), null, null));
    }

    public long round() {
        return this.recovery().state().round();
    }

    public Hash hash() {
        return this.recovery().state().hash();
    }

    public Instant timestamp() {
        return this.recovery().state().timestamp();
    }

    public void write(@NonNull Path directory) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER));
        mapper.writeValue(directory.resolve(OUTPUT_FILENAME).toFile(), (Object)this);
    }

    public static EmergencyRecoveryFile read(@NonNull StateConfig stateConfig, @NonNull Path directory, boolean failOnMissingFields) throws IOException {
        Objects.requireNonNull(stateConfig, "stateConfig must not be null");
        Path fileToRead = directory.resolve(stateConfig.emergencyStateFileName());
        if (!Files.exists(fileToRead, new LinkOption[0])) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, true);
        if (failOnMissingFields) {
            mapper.configure(DeserializationFeature.FAIL_ON_MISSING_CREATOR_PROPERTIES, true);
            mapper.configure(DeserializationFeature.FAIL_ON_NULL_CREATOR_PROPERTIES, true);
        }
        EmergencyRecoveryFile file = (EmergencyRecoveryFile)mapper.readValue(fileToRead.toFile(), EmergencyRecoveryFile.class);
        EmergencyRecoveryFile.validate(file);
        return file;
    }

    public static EmergencyRecoveryFile read(@NonNull StateConfig stateConfig, @NonNull Path directory) throws IOException {
        return EmergencyRecoveryFile.read(stateConfig, directory, false);
    }

    private static void validate(EmergencyRecoveryFile file) throws IOException {
        if (file == null) {
            throw new IOException("Failed to read emergency recovery file, object mapper returned null value");
        }
        if (file.hash() == null) {
            throw new IOException("Required field 'hash' is null.");
        }
    }
}

