/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.config.impl.internal;

import com.swirlds.config.api.ConfigData;
import com.swirlds.config.api.ConfigProperty;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.extensions.reflection.ConfigReflectionUtils;
import com.swirlds.config.impl.internal.ConfigListUtils;
import com.swirlds.config.impl.internal.ConverterService;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.RecordComponent;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class ConfigDataFactory {
    private final Configuration configuration;
    private final ConverterService converterService;

    ConfigDataFactory(@NonNull Configuration configuration, @NonNull ConverterService converterService) {
        this.configuration = Objects.requireNonNull(configuration, "configuration must not be null");
        this.converterService = Objects.requireNonNull(converterService, "converterService must not be null");
    }

    @NonNull
    <T extends Record> T createConfigInstance(@NonNull Class<T> type) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        Objects.requireNonNull(type, "type must not be null");
        if (!type.isAnnotationPresent(ConfigData.class)) {
            throw new IllegalArgumentException("Can not create config instance for '" + String.valueOf(type) + "' since " + ConfigData.class.getName() + "' annotation is missing");
        }
        if (!type.isRecord()) {
            throw new IllegalArgumentException("Can not create config instance for '" + String.valueOf(type) + "' since it is not record");
        }
        if (!ConfigReflectionUtils.isPublic(type)) {
            throw new IllegalArgumentException("Can not create config instance for '" + String.valueOf(type) + "' since it is not public");
        }
        if (type.getConstructors().length != 1) {
            throw new IllegalArgumentException("Can not create config instance for '" + String.valueOf(type) + "' since it has not exactly 1 constructor");
        }
        String namePrefix = ConfigDataFactory.getNamePrefix(type);
        Object[] paramValues = Arrays.stream(type.getRecordComponents()).map(component -> this.getValueForRecordComponent(namePrefix, (RecordComponent)component)).toArray(Object[]::new);
        Constructor<?> constructor = type.getConstructors()[0];
        return (T)((Record)constructor.newInstance(paramValues));
    }

    @Nullable
    private Object getValueForRecordComponent(@NonNull String namePrefix, @NonNull RecordComponent component) {
        Objects.requireNonNull(component, "component must not be null");
        String name = ConfigDataFactory.createPropertyName(namePrefix, component);
        Class<?> valueType = component.getType();
        if (ConfigDataFactory.hasDefaultValue(component)) {
            if (Objects.equals(List.class, component.getType())) {
                Class genericType = ConfigDataFactory.getGenericListType(component);
                return this.configuration.getValues(name, genericType, this.getDefaultValues(component));
            }
            if (Objects.equals(Set.class, component.getType())) {
                Class genericType = ConfigDataFactory.getGenericSetType(component);
                return this.configuration.getValueSet(name, genericType, this.getDefaultValueSet(component));
            }
            return this.configuration.getValue(name, valueType, this.getDefaultValue(component));
        }
        if (Objects.equals(List.class, component.getType())) {
            Class genericType = ConfigDataFactory.getGenericListType(component);
            return this.configuration.getValues(name, genericType);
        }
        if (Objects.equals(Set.class, component.getType())) {
            Class genericType = ConfigDataFactory.getGenericSetType(component);
            return this.configuration.getValueSet(name, genericType);
        }
        if (this.configuration.isListValue(name)) {
            return this.configuration.getValues(name, valueType);
        }
        return this.configuration.getValue(name, valueType);
    }

    private static boolean isGenericType(@NonNull RecordComponent component, @NonNull Class<?> type) {
        Objects.requireNonNull(component, "component must not be null");
        Objects.requireNonNull(type, "type must not be null");
        ParameterizedType stringSetType = (ParameterizedType)component.getGenericType();
        return Objects.equals(type, stringSetType.getRawType());
    }

    private static <T> Class<T> getGenericSetType(@NonNull RecordComponent component) {
        if (!ConfigDataFactory.isGenericType(component, Set.class)) {
            throw new IllegalArgumentException("Only Set interface is supported");
        }
        return (Class)ConfigReflectionUtils.getSingleGenericTypeArgument((ParameterizedType)((ParameterizedType)component.getGenericType()));
    }

    @NonNull
    private static <T> Class<T> getGenericListType(@NonNull RecordComponent component) {
        Objects.requireNonNull(component, "component must not be null");
        if (!ConfigDataFactory.isGenericType(component, List.class)) {
            throw new IllegalArgumentException("Only List interface is supported");
        }
        Class cls = (Class)ConfigReflectionUtils.getSingleGenericTypeArgument((ParameterizedType)((ParameterizedType)component.getGenericType()));
        if (cls == null) {
            throw new IllegalArgumentException("No generic class found!");
        }
        return cls;
    }

    @Nullable
    private <T> Set<T> getDefaultValueSet(@NonNull RecordComponent component) {
        Objects.requireNonNull(component, "component must not be null");
        Class type = ConfigDataFactory.getGenericSetType(component);
        String rawValue = this.getRawValue(component);
        if (Objects.equals("com.swirlds.config.value.nullValue#1j8!-235u-hBHJ-#nxs-!n2n", rawValue)) {
            return null;
        }
        return ConfigListUtils.createList(rawValue).stream().map(value -> this.converterService.convert((String)value, type)).collect(Collectors.toCollection(() -> new LinkedHashSet()));
    }

    @Nullable
    private <T> List<T> getDefaultValues(@NonNull RecordComponent component) {
        Objects.requireNonNull(component, "component must not be null");
        Class type = ConfigDataFactory.getGenericListType(component);
        String rawValue = this.getRawValue(component);
        if (Objects.equals("com.swirlds.config.value.nullValue#1j8!-235u-hBHJ-#nxs-!n2n", rawValue)) {
            return null;
        }
        return ConfigListUtils.createList(rawValue).stream().map(value -> this.converterService.convert((String)value, type)).toList();
    }

    @NonNull
    private String getRawValue(@NonNull RecordComponent component) {
        Optional<String> rawDefaultValue = ConfigDataFactory.getRawDefaultValue(component);
        if (rawDefaultValue.isEmpty()) {
            throw new IllegalArgumentException("Default value not defined for parameter");
        }
        return rawDefaultValue.get();
    }

    @NonNull
    private static <T extends Record> String getNamePrefix(@NonNull Class<T> type) {
        Objects.requireNonNull(type, "type must not be null");
        return Optional.ofNullable(type.getAnnotation(ConfigData.class)).map(ConfigData::value).orElse("");
    }

    @Nullable
    private <T> T getDefaultValue(@NonNull RecordComponent component) {
        Objects.requireNonNull(component, "component must not be null");
        String rawValue = this.getRawValue(component);
        if (Objects.equals("com.swirlds.config.value.nullValue#1j8!-235u-hBHJ-#nxs-!n2n", rawValue)) {
            return null;
        }
        return (T)this.converterService.convert(rawValue, component.getType());
    }

    @NonNull
    private static Optional<String> getRawDefaultValue(@NonNull RecordComponent component) {
        Objects.requireNonNull(component, "component must not be null");
        return Optional.ofNullable(component.getAnnotation(ConfigProperty.class)).map(ConfigProperty::defaultValue).filter(defaultValue -> !Objects.equals("com.swirlds.config.value.unconfiguredValue#1j8!-235u-hBHJ-#nxs-!n2n", defaultValue));
    }

    private static boolean hasDefaultValue(@NonNull RecordComponent component) {
        Objects.requireNonNull(component, "component must not be null");
        return Optional.ofNullable(component.getAnnotation(ConfigProperty.class)).map(propertyAnnotation -> !Objects.equals("com.swirlds.config.value.unconfiguredValue#1j8!-235u-hBHJ-#nxs-!n2n", propertyAnnotation.defaultValue())).orElse(false);
    }

    @NonNull
    private static String createPropertyName(@NonNull String prefix, @NonNull RecordComponent component) {
        Objects.requireNonNull(component, "component must not be null");
        return Optional.ofNullable(component.getAnnotation(ConfigProperty.class)).map(propertyAnnotation -> {
            if (!propertyAnnotation.value().isBlank()) {
                return ConfigDataFactory.createPropertyName(prefix, propertyAnnotation.value());
            }
            return ConfigDataFactory.createPropertyName(prefix, component.getName());
        }).orElseGet(() -> ConfigDataFactory.createPropertyName(prefix, component.getName()));
    }

    @NonNull
    private static String createPropertyName(@NonNull String prefix, @NonNull String name) {
        Objects.requireNonNull(prefix, "prefix must not be null");
        Objects.requireNonNull(name, "name must not be null");
        if (prefix.isBlank()) {
            return name;
        }
        return prefix + "." + name;
    }
}

