/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.service;

import com.hedera.hapi.node.base.SemanticVersion;
import com.swirlds.config.api.Configuration;
import com.swirlds.platform.state.service.schemas.V0540PlatformStateSchema;
import com.swirlds.platform.state.service.schemas.V0640PlatformStateSchema;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.SchemaRegistry;
import com.swirlds.state.lifecycle.Service;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public enum PlatformStateService implements Service
{
    PLATFORM_STATE_SERVICE;

    private static final AtomicReference<Function<Configuration, SemanticVersion>> APP_VERSION_FN;
    private static final Collection<Schema> SCHEMAS;
    public static final String NAME = "PlatformStateService";

    @NonNull
    public String getServiceName() {
        return NAME;
    }

    public void registerSchemas(@NonNull SchemaRegistry registry) {
        Objects.requireNonNull(registry);
        SCHEMAS.forEach(arg_0 -> ((SchemaRegistry)registry).register(arg_0));
    }

    public void setAppVersionFn(@NonNull Function<Configuration, SemanticVersion> appVersionFn) {
        APP_VERSION_FN.set(Objects.requireNonNull(appVersionFn));
    }

    static {
        APP_VERSION_FN = new AtomicReference();
        SCHEMAS = List.of(new V0540PlatformStateSchema(config -> Objects.requireNonNull(APP_VERSION_FN.get()).apply((Configuration)config)), new V0640PlatformStateSchema());
    }
}

