/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.datasource;

import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.FieldType;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.swirlds.virtualmap.internal.Path;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Objects;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.Hash;

public record VirtualHashChunk(long path, int height, @NonNull byte[] hashData) {
    public static final FieldDefinition FIELD_HASHCHUNK_PATH = new FieldDefinition("path", FieldType.FIXED64, false, true, false, 1);
    public static final FieldDefinition FIELD_HASHCHUNK_HEIGHT = new FieldDefinition("height", FieldType.FIXED32, false, true, false, 2);
    public static final FieldDefinition FIELD_HASHCHUNK_HASHDATA = new FieldDefinition("hashData", FieldType.BYTES, false, false, false, 4);

    public VirtualHashChunk {
        if (height <= 0) {
            throw new IllegalArgumentException("Wrong chunk height: " + height);
        }
        int rank = Path.getRank(path);
        if (rank % height != 0) {
            throw new IllegalArgumentException("Wrong chunk path/height: " + path + "/" + height);
        }
        if (hashData == null) {
            throw new IllegalArgumentException("Null hash data");
        }
        int dataLength = hashData.length;
        int expectedHashCount = VirtualHashChunk.getChunkSize(height);
        if (dataLength != Cryptography.DEFAULT_DIGEST_TYPE.digestLength() * expectedHashCount) {
            throw new IllegalArgumentException("Wrong hash data length: " + dataLength);
        }
    }

    public VirtualHashChunk(long path, int height) {
        this(path, height, new byte[VirtualHashChunk.getChunkSize(height)]);
    }

    public VirtualHashChunk copy() {
        byte[] dataCopy = new byte[this.hashData.length];
        System.arraycopy(this.hashData, 0, dataCopy, 0, this.hashData.length);
        return new VirtualHashChunk(this.path, this.height, dataCopy);
    }

    public static VirtualHashChunk parseFrom(ReadableSequentialData in) throws IOException {
        if (in == null) {
            return null;
        }
        long path = 0L;
        int height = 0;
        byte[] hashData = null;
        while (in.hasRemaining()) {
            int field = in.readVarInt(false);
            int tag = field >> 3;
            if (tag == FIELD_HASHCHUNK_PATH.number()) {
                if ((field & 7) != ProtoConstants.WIRE_TYPE_FIXED_64_BIT.ordinal()) {
                    throw new IllegalArgumentException("Wrong field type: " + field);
                }
                path = in.readLong();
                continue;
            }
            if (tag == FIELD_HASHCHUNK_HEIGHT.number()) {
                if ((field & 7) != ProtoConstants.WIRE_TYPE_FIXED_32_BIT.ordinal()) {
                    throw new IllegalArgumentException("Wrong field type: " + field);
                }
                height = in.readInt();
                continue;
            }
            if (tag == FIELD_HASHCHUNK_HASHDATA.number()) {
                if ((field & 7) != ProtoConstants.WIRE_TYPE_DELIMITED.ordinal()) {
                    throw new IllegalArgumentException("Wrong field type: " + field);
                }
                int len = in.readVarInt(false);
                hashData = new byte[len];
                if (in.readBytes(hashData) == (long)len) continue;
                throw new IOException("Failed to read " + len + " bytes");
            }
            throw new IllegalArgumentException("Unknown field: " + field);
        }
        Objects.requireNonNull(hashData, "Missing hash data in the input");
        return new VirtualHashChunk(path, height, hashData);
    }

    public int getSizeInBytes() {
        int size = 0;
        if (this.path != 0L) {
            size += ProtoWriterTools.sizeOfTag((FieldDefinition)FIELD_HASHCHUNK_PATH);
            size += 8;
        }
        size += ProtoWriterTools.sizeOfTag((FieldDefinition)FIELD_HASHCHUNK_HEIGHT);
        size += 4;
        return size += ProtoWriterTools.sizeOfDelimited((FieldDefinition)FIELD_HASHCHUNK_HASHDATA, (int)this.hashData.length);
    }

    public void writeTo(WritableSequentialData out) {
        long pos = out.position();
        if (this.path != 0L) {
            ProtoWriterTools.writeTag((WritableSequentialData)out, (FieldDefinition)FIELD_HASHCHUNK_PATH);
            out.writeLong(this.path);
        }
        ProtoWriterTools.writeTag((WritableSequentialData)out, (FieldDefinition)FIELD_HASHCHUNK_HEIGHT);
        out.writeInt(this.height);
        ProtoWriterTools.writeDelimited((WritableSequentialData)out, (FieldDefinition)FIELD_HASHCHUNK_HASHDATA, (int)this.hashData.length, o -> o.writeBytes(this.hashData));
        assert (out.position() == pos + (long)this.getSizeInBytes());
    }

    public long pathToChunkId() {
        return VirtualHashChunk.pathToChunkId(this.path, this.height);
    }

    public static long pathToChunkId(long path, int chunkHeight) {
        assert (path > 0L);
        assert (chunkHeight > 0);
        long pp = path + 1L;
        int z = Long.numberOfLeadingZeros(pp);
        int r = (64 - z - 2) % chunkHeight + 1;
        long m = Long.MIN_VALUE >>> z + r;
        return (pp >>> r ^ m) + (m - 1L) / ((1L << chunkHeight) - 1L);
    }

    public static long chunkIdToChunkPath(long chunkId, int chunkHeight) {
        assert (chunkHeight > 0);
        if (chunkId == 0L) {
            return 0L;
        }
        int childCount = 1 << chunkHeight;
        int chunkRank = 0;
        int chunksAtRank = 1;
        int id = 0;
        while ((long)id < chunkId) {
            id += (chunksAtRank *= childCount);
            chunkRank += chunkHeight;
        }
        return Path.getLeftGrandChildPath(0L, chunkRank) + chunkId - (long)id + (long)chunksAtRank - 1L;
    }

    public int getChunkSize() {
        return VirtualHashChunk.getChunkSize(this.height);
    }

    public static int getChunkSize(int chunkHeight) {
        assert (chunkHeight > 0);
        return (1 << chunkHeight + 1) - 2;
    }

    public int getPathIndexInChunk(long path) {
        return VirtualHashChunk.getPathIndexInChunk(path, this.path, this.height);
    }

    public static int getPathIndexInChunk(long path, long chunkPath, int chunkHeight) {
        long firstChunkPath = Path.getLeftChildPath(chunkPath);
        if (path < firstChunkPath) {
            throw new IllegalArgumentException("Path is not in chunk: " + path);
        }
        int chunkSize = VirtualHashChunk.getChunkSize(chunkHeight);
        int index = 0;
        long firstInLevel = firstChunkPath;
        int pathsInLevel = 2;
        while (firstInLevel + (long)pathsInLevel <= path) {
            if ((index += pathsInLevel) >= chunkSize) {
                throw new IllegalArgumentException("Path is not in chunk: " + path);
            }
            firstInLevel = Path.getLeftChildPath(firstInLevel);
            pathsInLevel *= 2;
            if (path >= firstInLevel) continue;
            throw new IllegalArgumentException("Path is not in chunk: " + path);
        }
        return index += Math.toIntExact(path - firstInLevel);
    }

    public long getPath(int pathIndex) {
        return VirtualHashChunk.getPathInChunk(this.path, pathIndex, this.height);
    }

    public static long getPathInChunk(long chunkPath, int pathIndex, int chunkHeight) {
        if (pathIndex < 0 || pathIndex >= VirtualHashChunk.getChunkSize(chunkHeight)) {
            throw new IllegalArgumentException("Wrong path index");
        }
        long firstPathInLevel = Path.getLeftChildPath(chunkPath);
        for (int pathsInLevel = 2; pathsInLevel <= pathIndex; pathIndex -= pathsInLevel, pathsInLevel *= 2) {
            firstPathInLevel = firstPathInLevel * 2L + 1L;
        }
        return firstPathInLevel + (long)pathIndex;
    }

    private void setHashImpl(int index, Hash hash) {
        int pos = index * Cryptography.DEFAULT_DIGEST_TYPE.digestLength();
        int len = Cryptography.DEFAULT_DIGEST_TYPE.digestLength();
        hash.getBytes().getBytes(0L, this.hashData, pos, len);
    }

    private Hash getHashImpl(int index) {
        int pos = index * Cryptography.DEFAULT_DIGEST_TYPE.digestLength();
        int len = Cryptography.DEFAULT_DIGEST_TYPE.digestLength();
        byte[] hashBytes = new byte[len];
        System.arraycopy(this.hashData, pos, hashBytes, 0, len);
        return new Hash(hashBytes, Cryptography.DEFAULT_DIGEST_TYPE);
    }

    public void setHashAtPath(long path, Hash hash) {
        int index = VirtualHashChunk.getPathIndexInChunk(path, this.path, this.height);
        this.setHashImpl(index, hash);
    }

    public Hash getHashAtPath(long path) {
        int index = VirtualHashChunk.getPathIndexInChunk(path, this.path, this.height);
        return this.getHashImpl(index);
    }

    public void setHashAtIndex(int index, Hash hash) {
        if (index < 0 || index >= VirtualHashChunk.getChunkSize(this.height)) {
            throw new IllegalArgumentException("Wrong hash index: " + index);
        }
        this.setHashImpl(index, hash);
    }

    public Hash getHashAtIndex(int index) {
        if (index < 0 || index >= VirtualHashChunk.getChunkSize(this.height)) {
            throw new IllegalArgumentException("Wrong hash index: " + index);
        }
        return this.getHashImpl(index);
    }
}

