/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.model.internal.analysis;

import com.swirlds.component.framework.model.internal.analysis.MermaidNameShortener;
import com.swirlds.component.framework.model.internal.analysis.MermaidStyleManager;
import com.swirlds.component.framework.model.internal.analysis.ModelEdge;
import com.swirlds.component.framework.model.internal.analysis.ModelVertex;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class GroupVertex
implements ModelVertex {
    private final String name;
    private final Set<ModelEdge> outgoingEdges = new HashSet<ModelEdge>();
    private final List<ModelVertex> subVertices;
    private int depth;
    private final Set<String> substitutedInputs = new HashSet<String>();

    public GroupVertex(@NonNull String name, @NonNull List<ModelVertex> subVertices) {
        this.name = Objects.requireNonNull(name);
        this.subVertices = Objects.requireNonNull(subVertices);
        for (ModelVertex vertex : subVertices) {
            vertex.setDepth(1);
        }
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    @NonNull
    public TaskSchedulerType getType() {
        return TaskSchedulerType.DIRECT;
    }

    @Override
    @Nullable
    public String getHyperlink() {
        return null;
    }

    @Override
    public boolean isInsertionIsBlocking() {
        return true;
    }

    @Override
    @NonNull
    public Set<ModelEdge> getOutgoingEdges() {
        return this.outgoingEdges;
    }

    @Override
    @NonNull
    public Set<String> getSubstitutedInputs() {
        return this.substitutedInputs;
    }

    public List<ModelVertex> getSubVertices() {
        return this.subVertices;
    }

    @Override
    public void setDepth(int depth) {
        this.depth = depth;
        for (ModelVertex vertex : this.subVertices) {
            vertex.setDepth(depth + 1);
        }
    }

    @NonNull
    private String generateStyle() {
        int baseRedValue = Integer.parseInt(String.valueOf("9cf".charAt(0)), 16);
        int baseGreenValue = Integer.parseInt(String.valueOf("9cf".charAt(1)), 16);
        int baseBlueValue = Integer.parseInt(String.valueOf("9cf".charAt(2)), 16);
        int redValue = Math.min(15, baseRedValue + this.depth * 2);
        int greenValue = Math.min(15, baseGreenValue + this.depth * 2);
        int blueValue = Math.min(15, baseBlueValue + this.depth * 2);
        String color = String.format("%X%X%X", redValue, greenValue, blueValue);
        return "fill:#" + color + ",stroke:#000,stroke-width:2px";
    }

    @Override
    public void render(@NonNull StringBuilder sb, @NonNull MermaidNameShortener nameProvider, @NonNull MermaidStyleManager styleManager) {
        String shortName = nameProvider.getShortVertexName(this.name);
        styleManager.registerStyle(shortName, this.generateStyle());
        sb.append("subgraph ").append(shortName).append("[\"").append(this.name).append("\"]\n");
        this.subVertices.stream().sorted().forEachOrdered(vertex -> vertex.render(sb, nameProvider, styleManager));
        sb.append("end\n");
    }
}

