/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.Transaction;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.hapi.node.transaction.Response;
import com.hedera.hapi.node.transaction.TransactionResponse;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.grpc.GrpcCall;
import com.hedera.pbj.runtime.grpc.GrpcClient;
import com.hedera.pbj.runtime.grpc.Pipeline;
import com.hedera.pbj.runtime.grpc.Pipelines;
import com.hedera.pbj.runtime.grpc.ServiceInterface;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReference;

public interface TokenServiceInterface
extends ServiceInterface {
    public static final String SERVICE_NAME = "TokenService";
    public static final String FULL_NAME = "proto.TokenService";

    @NonNull
    public TransactionResponse createToken(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse updateToken(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse mintToken(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse burnToken(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse deleteToken(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse wipeTokenAccount(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse freezeTokenAccount(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse unfreezeTokenAccount(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse grantKycToTokenAccount(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse revokeKycFromTokenAccount(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse associateTokens(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse dissociateTokens(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse updateTokenFeeSchedule(@NonNull Transaction var1);

    @NonNull
    public Response getTokenInfo(@NonNull Query var1);

    @NonNull
    public Response getTokenNftInfo(@NonNull Query var1);

    @NonNull
    public TransactionResponse pauseToken(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse unpauseToken(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse updateNfts(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse rejectToken(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse airdropTokens(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse cancelAirdrop(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse claimAirdrop(@NonNull Transaction var1);

    @NonNull
    default public String serviceName() {
        return SERVICE_NAME;
    }

    @NonNull
    default public String fullName() {
        return FULL_NAME;
    }

    @NonNull
    default public List<ServiceInterface.Method> methods() {
        return Arrays.asList(TokenServiceMethod.values());
    }

    @NonNull
    default public Pipeline<? super Bytes> open(@NonNull ServiceInterface.Method method, @NonNull ServiceInterface.RequestOptions options, @NonNull Pipeline<? super Bytes> replies) {
        TokenServiceMethod m = (TokenServiceMethod)method;
        try {
            return switch (m.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Pipelines.unary().mapRequest(bytes -> TokenServiceInterface.parseTransaction(bytes, options)).method(this::createToken).mapResponse(reply -> TokenServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 1 -> Pipelines.unary().mapRequest(bytes -> TokenServiceInterface.parseTransaction(bytes, options)).method(this::updateToken).mapResponse(reply -> TokenServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 2 -> Pipelines.unary().mapRequest(bytes -> TokenServiceInterface.parseTransaction(bytes, options)).method(this::mintToken).mapResponse(reply -> TokenServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 3 -> Pipelines.unary().mapRequest(bytes -> TokenServiceInterface.parseTransaction(bytes, options)).method(this::burnToken).mapResponse(reply -> TokenServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 4 -> Pipelines.unary().mapRequest(bytes -> TokenServiceInterface.parseTransaction(bytes, options)).method(this::deleteToken).mapResponse(reply -> TokenServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 5 -> Pipelines.unary().mapRequest(bytes -> TokenServiceInterface.parseTransaction(bytes, options)).method(this::wipeTokenAccount).mapResponse(reply -> TokenServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 6 -> Pipelines.unary().mapRequest(bytes -> TokenServiceInterface.parseTransaction(bytes, options)).method(this::freezeTokenAccount).mapResponse(reply -> TokenServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 7 -> Pipelines.unary().mapRequest(bytes -> TokenServiceInterface.parseTransaction(bytes, options)).method(this::unfreezeTokenAccount).mapResponse(reply -> TokenServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 8 -> Pipelines.unary().mapRequest(bytes -> TokenServiceInterface.parseTransaction(bytes, options)).method(this::grantKycToTokenAccount).mapResponse(reply -> TokenServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 9 -> Pipelines.unary().mapRequest(bytes -> TokenServiceInterface.parseTransaction(bytes, options)).method(this::revokeKycFromTokenAccount).mapResponse(reply -> TokenServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 10 -> Pipelines.unary().mapRequest(bytes -> TokenServiceInterface.parseTransaction(bytes, options)).method(this::associateTokens).mapResponse(reply -> TokenServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 11 -> Pipelines.unary().mapRequest(bytes -> TokenServiceInterface.parseTransaction(bytes, options)).method(this::dissociateTokens).mapResponse(reply -> TokenServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 12 -> Pipelines.unary().mapRequest(bytes -> TokenServiceInterface.parseTransaction(bytes, options)).method(this::updateTokenFeeSchedule).mapResponse(reply -> TokenServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 13 -> Pipelines.unary().mapRequest(bytes -> TokenServiceInterface.parseQuery(bytes, options)).method(this::getTokenInfo).mapResponse(reply -> TokenServiceInterface.serializeResponse(reply, options)).respondTo(replies).build();
                case 14 -> Pipelines.unary().mapRequest(bytes -> TokenServiceInterface.parseQuery(bytes, options)).method(this::getTokenNftInfo).mapResponse(reply -> TokenServiceInterface.serializeResponse(reply, options)).respondTo(replies).build();
                case 15 -> Pipelines.unary().mapRequest(bytes -> TokenServiceInterface.parseTransaction(bytes, options)).method(this::pauseToken).mapResponse(reply -> TokenServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 16 -> Pipelines.unary().mapRequest(bytes -> TokenServiceInterface.parseTransaction(bytes, options)).method(this::unpauseToken).mapResponse(reply -> TokenServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 17 -> Pipelines.unary().mapRequest(bytes -> TokenServiceInterface.parseTransaction(bytes, options)).method(this::updateNfts).mapResponse(reply -> TokenServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 18 -> Pipelines.unary().mapRequest(bytes -> TokenServiceInterface.parseTransaction(bytes, options)).method(this::rejectToken).mapResponse(reply -> TokenServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 19 -> Pipelines.unary().mapRequest(bytes -> TokenServiceInterface.parseTransaction(bytes, options)).method(this::airdropTokens).mapResponse(reply -> TokenServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 20 -> Pipelines.unary().mapRequest(bytes -> TokenServiceInterface.parseTransaction(bytes, options)).method(this::cancelAirdrop).mapResponse(reply -> TokenServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 21 -> Pipelines.unary().mapRequest(bytes -> TokenServiceInterface.parseTransaction(bytes, options)).method(this::claimAirdrop).mapResponse(reply -> TokenServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
            };
        }
        catch (Exception e) {
            replies.onError((Throwable)e);
            return Pipelines.noop();
        }
    }

    @NonNull
    private static Codec<Transaction> getTransactionCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return Transaction.JSON;
        }
        return Transaction.PROTOBUF;
    }

    @NonNull
    private static Codec<TransactionResponse> getTransactionResponseCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return TransactionResponse.JSON;
        }
        return TransactionResponse.PROTOBUF;
    }

    @NonNull
    private static Codec<Query> getQueryCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return Query.JSON;
        }
        return Query.PROTOBUF;
    }

    @NonNull
    private static Codec<Response> getResponseCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return Response.JSON;
        }
        return Response.PROTOBUF;
    }

    @NonNull
    private static Transaction parseTransaction(@NonNull Bytes message, @NonNull ServiceInterface.RequestOptions options) throws ParseException {
        Objects.requireNonNull(message);
        Objects.requireNonNull(options);
        return (Transaction)TokenServiceInterface.getTransactionCodec(options).parse(message.toReadableSequentialData(), false, 16);
    }

    @NonNull
    private static Query parseQuery(@NonNull Bytes message, @NonNull ServiceInterface.RequestOptions options) throws ParseException {
        Objects.requireNonNull(message);
        Objects.requireNonNull(options);
        return (Query)TokenServiceInterface.getQueryCodec(options).parse(message.toReadableSequentialData(), false, 16);
    }

    @NonNull
    private static Bytes serializeTransactionResponse(@NonNull TransactionResponse reply, @NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(reply);
        Objects.requireNonNull(options);
        return TokenServiceInterface.getTransactionResponseCodec(options).toBytes((Object)reply);
    }

    @NonNull
    private static Bytes serializeResponse(@NonNull Response reply, @NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(reply);
        Objects.requireNonNull(options);
        return TokenServiceInterface.getResponseCodec(options).toBytes((Object)reply);
    }

    public static enum TokenServiceMethod implements ServiceInterface.Method
    {
        createToken,
        updateToken,
        mintToken,
        burnToken,
        deleteToken,
        wipeTokenAccount,
        freezeTokenAccount,
        unfreezeTokenAccount,
        grantKycToTokenAccount,
        revokeKycFromTokenAccount,
        associateTokens,
        dissociateTokens,
        updateTokenFeeSchedule,
        getTokenInfo,
        getTokenNftInfo,
        pauseToken,
        unpauseToken,
        updateNfts,
        rejectToken,
        airdropTokens,
        cancelAirdrop,
        claimAirdrop;

    }

    public static class TokenServiceClient
    implements TokenServiceInterface {
        private final GrpcClient grpcClient;
        private final ServiceInterface.RequestOptions requestOptions;

        public TokenServiceClient(@NonNull GrpcClient grpcClient, @NonNull ServiceInterface.RequestOptions requestOptions) {
            this.grpcClient = Objects.requireNonNull(grpcClient);
            this.requestOptions = Objects.requireNonNull(requestOptions);
        }

        public void close() {
            this.grpcClient.close();
        }

        @Override
        @NonNull
        public TransactionResponse createToken(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("createToken is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.TokenService/createToken", TokenServiceInterface.getTransactionCodec(this.requestOptions), TokenServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to createToken completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse updateToken(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("updateToken is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.TokenService/updateToken", TokenServiceInterface.getTransactionCodec(this.requestOptions), TokenServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to updateToken completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse mintToken(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("mintToken is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.TokenService/mintToken", TokenServiceInterface.getTransactionCodec(this.requestOptions), TokenServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to mintToken completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse burnToken(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("burnToken is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.TokenService/burnToken", TokenServiceInterface.getTransactionCodec(this.requestOptions), TokenServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to burnToken completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse deleteToken(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("deleteToken is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.TokenService/deleteToken", TokenServiceInterface.getTransactionCodec(this.requestOptions), TokenServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to deleteToken completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse wipeTokenAccount(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("wipeTokenAccount is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.TokenService/wipeTokenAccount", TokenServiceInterface.getTransactionCodec(this.requestOptions), TokenServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to wipeTokenAccount completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse freezeTokenAccount(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("freezeTokenAccount is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.TokenService/freezeTokenAccount", TokenServiceInterface.getTransactionCodec(this.requestOptions), TokenServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to freezeTokenAccount completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse unfreezeTokenAccount(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("unfreezeTokenAccount is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.TokenService/unfreezeTokenAccount", TokenServiceInterface.getTransactionCodec(this.requestOptions), TokenServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to unfreezeTokenAccount completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse grantKycToTokenAccount(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("grantKycToTokenAccount is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.TokenService/grantKycToTokenAccount", TokenServiceInterface.getTransactionCodec(this.requestOptions), TokenServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to grantKycToTokenAccount completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse revokeKycFromTokenAccount(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("revokeKycFromTokenAccount is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.TokenService/revokeKycFromTokenAccount", TokenServiceInterface.getTransactionCodec(this.requestOptions), TokenServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to revokeKycFromTokenAccount completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse associateTokens(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("associateTokens is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.TokenService/associateTokens", TokenServiceInterface.getTransactionCodec(this.requestOptions), TokenServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to associateTokens completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse dissociateTokens(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("dissociateTokens is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.TokenService/dissociateTokens", TokenServiceInterface.getTransactionCodec(this.requestOptions), TokenServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to dissociateTokens completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse updateTokenFeeSchedule(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("updateTokenFeeSchedule is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.TokenService/updateTokenFeeSchedule", TokenServiceInterface.getTransactionCodec(this.requestOptions), TokenServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to updateTokenFeeSchedule completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public Response getTokenInfo(@NonNull Query request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<Response> pipeline = new Pipeline<Response>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(Response reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("getTokenInfo is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.TokenService/getTokenInfo", TokenServiceInterface.getQueryCodec(this.requestOptions), TokenServiceInterface.getResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (Response)replyRef.get();
            }
            throw new RuntimeException("Call to getTokenInfo completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public Response getTokenNftInfo(@NonNull Query request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<Response> pipeline = new Pipeline<Response>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(Response reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("getTokenNftInfo is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.TokenService/getTokenNftInfo", TokenServiceInterface.getQueryCodec(this.requestOptions), TokenServiceInterface.getResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (Response)replyRef.get();
            }
            throw new RuntimeException("Call to getTokenNftInfo completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse pauseToken(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("pauseToken is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.TokenService/pauseToken", TokenServiceInterface.getTransactionCodec(this.requestOptions), TokenServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to pauseToken completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse unpauseToken(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("unpauseToken is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.TokenService/unpauseToken", TokenServiceInterface.getTransactionCodec(this.requestOptions), TokenServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to unpauseToken completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse updateNfts(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("updateNfts is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.TokenService/updateNfts", TokenServiceInterface.getTransactionCodec(this.requestOptions), TokenServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to updateNfts completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse rejectToken(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("rejectToken is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.TokenService/rejectToken", TokenServiceInterface.getTransactionCodec(this.requestOptions), TokenServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to rejectToken completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse airdropTokens(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("airdropTokens is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.TokenService/airdropTokens", TokenServiceInterface.getTransactionCodec(this.requestOptions), TokenServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to airdropTokens completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse cancelAirdrop(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("cancelAirdrop is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.TokenService/cancelAirdrop", TokenServiceInterface.getTransactionCodec(this.requestOptions), TokenServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to cancelAirdrop completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse claimAirdrop(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("claimAirdrop is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.TokenService/claimAirdrop", TokenServiceInterface.getTransactionCodec(this.requestOptions), TokenServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to claimAirdrop completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }
    }
}

