/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle;

import com.swirlds.base.time.Time;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.utility.MerkleTreeSnapshotReader;
import com.swirlds.common.merkle.utility.MerkleTreeSnapshotWriter;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.State;
import com.swirlds.state.StateLifecycleManager;
import com.swirlds.state.merkle.MerkleRootSnapshotMetrics;
import com.swirlds.state.merkle.StateMetrics;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StateLifecycleManagerImpl
implements StateLifecycleManager {
    private static final Logger log = LogManager.getLogger(StateLifecycleManagerImpl.class);
    private final StateMetrics stateMetrics;
    private final MerkleRootSnapshotMetrics snapshotMetrics;
    private final Time time;
    private final Metrics metrics;
    private final Function<VirtualMap, MerkleNodeState> stateSupplier;
    private final AtomicReference<MerkleNodeState> stateRef = new AtomicReference();
    private final AtomicReference<MerkleNodeState> latestImmutableStateRef = new AtomicReference();

    public StateLifecycleManagerImpl(@NonNull Metrics metrics, @NonNull Time time, @NonNull Function<VirtualMap, MerkleNodeState> stateSupplier) {
        Objects.requireNonNull(metrics);
        Objects.requireNonNull(time);
        this.stateSupplier = stateSupplier;
        this.metrics = metrics;
        this.stateMetrics = new StateMetrics(metrics);
        this.snapshotMetrics = new MerkleRootSnapshotMetrics(metrics);
        this.time = time;
    }

    public void initState(@NonNull MerkleNodeState state, boolean onStartup) {
        Objects.requireNonNull(state);
        state.throwIfDestroyed("state must not be destroyed");
        state.throwIfImmutable("state must be mutable");
        if (onStartup && this.stateRef.get() != null) {
            throw new IllegalStateException("Attempt to set initial state when there is already a state reference.");
        }
        this.copyAndUpdateStateRefs(state);
    }

    @NonNull
    public MerkleNodeState getMutableState() {
        MerkleNodeState mutableState = this.stateRef.get();
        if (mutableState == null) {
            throw new IllegalStateException("StateLifecycleManager has not been initialized.");
        }
        return mutableState;
    }

    @NonNull
    public MerkleNodeState getLatestImmutableState() {
        MerkleNodeState latestImmutableState = this.latestImmutableStateRef.get();
        if (latestImmutableState == null) {
            throw new IllegalStateException("StateLifecycleManager has not been initialized.");
        }
        return latestImmutableState;
    }

    @NonNull
    public MerkleNodeState copyMutableState() {
        MerkleNodeState state = this.stateRef.get();
        this.copyAndUpdateStateRefs(state);
        return this.stateRef.get();
    }

    private void copyAndUpdateStateRefs(@NonNull MerkleNodeState stateToCopy) {
        long copyStart = System.nanoTime();
        MerkleNodeState newMutableState = stateToCopy.copy();
        newMutableState.getRoot().reserve();
        long copyEnd = System.nanoTime();
        this.stateMetrics.stateCopyMicros((double)(copyEnd - copyStart) * 0.001);
        State previousImmutableState = (State)this.latestImmutableStateRef.get();
        if (previousImmutableState != null) {
            assert (!previousImmutableState.isDestroyed());
            if (previousImmutableState.isDestroyed()) {
                log.error(LogMarker.EXCEPTION.getMarker(), "previousImmutableState is in destroyed state");
            } else {
                previousImmutableState.release();
            }
        }
        stateToCopy.getRoot().reserve();
        this.latestImmutableStateRef.set(stateToCopy);
        MerkleNodeState previousMutableState = this.stateRef.get();
        if (previousMutableState != null) {
            assert (!previousMutableState.isDestroyed());
            if (previousMutableState.isDestroyed()) {
                log.error(LogMarker.EXCEPTION.getMarker(), "previousImmutableState is in destroyed state");
            } else {
                previousMutableState.release();
            }
        }
        this.stateRef.set(newMutableState);
    }

    public void createSnapshot(@NonNull MerkleNodeState state, @NonNull Path targetPath) {
        state.throwIfMutable();
        state.throwIfDestroyed();
        long startTime = this.time.currentTimeMillis();
        MerkleTreeSnapshotWriter.createSnapshot((MerkleNode)state.getRoot(), (Path)targetPath, (String)state.toString());
        this.snapshotMetrics.updateWriteStateToDiskTimeMetric(this.time.currentTimeMillis() - startTime);
    }

    @NonNull
    public MerkleNodeState loadSnapshot(@NonNull Path targetPath) {
        MerkleNode root;
        try {
            root = MerkleTreeSnapshotReader.readStateFileData((Path)targetPath).stateRoot();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (!(root instanceof VirtualMap)) {
            throw new IllegalStateException("Root should be a VirtualMap, but it is " + root.getClass().getSimpleName() + " instead");
        }
        VirtualMap readVirtualMap = (VirtualMap)root;
        VirtualMap mutableCopy = readVirtualMap.copy();
        mutableCopy.registerMetrics(this.metrics);
        readVirtualMap.release();
        readVirtualMap = mutableCopy;
        return this.stateSupplier.apply(readVirtualMap);
    }
}

