/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.utility;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.Objects;
import sun.misc.Unsafe;

public class MemoryUtils {
    private static final Unsafe UNSAFE;
    private static final long BYTE_BUFFER_ADDRESS_FIELD_OFFSET;

    public static void closeMmapBuffer(@NonNull MappedByteBuffer buffer) {
        Objects.requireNonNull(buffer);
        UNSAFE.invokeCleaner(buffer);
    }

    public static void closeDirectByteBuffer(@NonNull ByteBuffer buffer) {
        Objects.requireNonNull(buffer);
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("Byte buffer is not direct");
        }
        UNSAFE.invokeCleaner(buffer);
    }

    public static long getLongVolatile(@NonNull ByteBuffer buffer, long offset) {
        long address = MemoryUtils.bufferAddress(buffer);
        return UNSAFE.getLongVolatile(null, address + offset);
    }

    public static void putLongVolatile(@NonNull ByteBuffer buffer, long offset, long value) {
        long address = MemoryUtils.bufferAddress(buffer);
        UNSAFE.putLongVolatile(null, address + offset, value);
    }

    public static boolean compareAndSwapLong(@NonNull ByteBuffer buffer, long offset, long expected, long value) {
        long address = MemoryUtils.bufferAddress(buffer);
        return UNSAFE.compareAndSwapLong(null, address + offset, expected, value);
    }

    public static void setMemory(@NonNull ByteBuffer buffer, long offset, long len, byte value) {
        long address = MemoryUtils.bufferAddress(buffer);
        UNSAFE.setMemory(address + offset, len, value);
    }

    private static long bufferAddress(@NonNull Buffer buffer) {
        Objects.requireNonNull(buffer);
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("buffer.isDirect() must be true");
        }
        return UNSAFE.getLong(buffer, BYTE_BUFFER_ADDRESS_FIELD_OFFSET);
    }

    static {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            UNSAFE = (Unsafe)f.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new InternalError(e);
        }
        try {
            BYTE_BUFFER_ADDRESS_FIELD_OFFSET = UNSAFE.objectFieldOffset(Buffer.class.getDeclaredField("address"));
        }
        catch (IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new InternalError(e);
        }
    }
}

