/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.recovery;

import com.hedera.hapi.node.base.SemanticVersion;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.io.IOIterator;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.common.notification.NotificationEngine;
import com.swirlds.common.stream.RunningHashCalculatorForStream;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.ApplicationDefinition;
import com.swirlds.platform.ApplicationDefinitionLoader;
import com.swirlds.platform.ParameterProvider;
import com.swirlds.platform.cli.utils.HederaUtils;
import com.swirlds.platform.config.PathsConfig;
import com.swirlds.platform.config.StateConfig;
import com.swirlds.platform.consensus.ConsensusConfig;
import com.swirlds.platform.consensus.SyntheticSnapshot;
import com.swirlds.platform.crypto.CryptoStatic;
import com.swirlds.platform.event.preconsensus.PcesConfig;
import com.swirlds.platform.event.preconsensus.PcesFile;
import com.swirlds.platform.event.preconsensus.PcesFileWriterType;
import com.swirlds.platform.event.preconsensus.PcesMutableFile;
import com.swirlds.platform.eventhandling.DefaultTransactionPrehandler;
import com.swirlds.platform.recovery.emergencyfile.EmergencyRecoveryFile;
import com.swirlds.platform.recovery.internal.EventStreamRoundIterator;
import com.swirlds.platform.recovery.internal.RecoveredState;
import com.swirlds.platform.recovery.internal.RecoveryPlatform;
import com.swirlds.platform.recovery.internal.StreamedRound;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.state.signed.SignedState;
import com.swirlds.platform.state.snapshot.DeserializedSignedState;
import com.swirlds.platform.state.snapshot.SignedStateFileReader;
import com.swirlds.platform.state.snapshot.SignedStateFileWriter;
import com.swirlds.platform.system.InitTrigger;
import com.swirlds.platform.system.SwirldMain;
import com.swirlds.platform.system.state.notifications.NewRecoveredStateListener;
import com.swirlds.platform.system.state.notifications.NewRecoveredStateNotification;
import com.swirlds.platform.util.BootstrapUtils;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.State;
import com.swirlds.state.StateLifecycleManager;
import com.swirlds.state.merkle.StateLifecycleManagerImpl;
import com.swirlds.virtualmap.VirtualMap;
import com.swirlds.virtualmap.constructable.ConstructableUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.CompareTo;
import org.hiero.base.constructable.ConstructableRegistryException;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.RunningHashable;
import org.hiero.consensus.crypto.DefaultEventHasher;
import org.hiero.consensus.model.event.CesEvent;
import org.hiero.consensus.model.event.ConsensusEvent;
import org.hiero.consensus.model.event.Event;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.Round;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.notification.Notification;

public final class EventRecoveryWorkflow {
    private static final Logger logger = LogManager.getLogger(EventRecoveryWorkflow.class);
    public static final long NO_FINAL_ROUND = Long.MAX_VALUE;

    private EventRecoveryWorkflow() {
    }

    public static void recoverState(@NonNull PlatformContext platformContext, @NonNull Path signedStateFile, @NonNull List<Path> configurationFiles, @NonNull Path eventStreamDirectory, @NonNull String mainClassName, @NonNull Boolean allowPartialRounds, @NonNull Long finalRound, @NonNull Path resultingStateDirectory, @NonNull NodeId selfId, boolean loadSigningKeys, @NonNull PlatformStateFacade platformStateFacade) throws IOException {
        Objects.requireNonNull(platformContext);
        Objects.requireNonNull(signedStateFile, "signedStateFile must not be null");
        Objects.requireNonNull(configurationFiles, "configurationFiles must not be null");
        Objects.requireNonNull(eventStreamDirectory, "eventStreamDirectory must not be null");
        Objects.requireNonNull(mainClassName, "mainClassName must not be null");
        Objects.requireNonNull(allowPartialRounds, "allowPartialRounds must not be null");
        Objects.requireNonNull(finalRound, "finalRound must not be null");
        Objects.requireNonNull(resultingStateDirectory, "resultingStateDirectory must not be null");
        Objects.requireNonNull(selfId, "selfId must not be null");
        BootstrapUtils.setupConstructableRegistry();
        try {
            BootstrapUtils.setupConstructableRegistryWithConfiguration(platformContext.getConfiguration());
            ConstructableUtils.registerVirtualMapConstructables((Configuration)platformContext.getConfiguration());
        }
        catch (ConstructableRegistryException e) {
            throw new RuntimeException(e);
        }
        PathsConfig defaultPathsConfig = (PathsConfig)ConfigurationBuilder.create().withConfigDataType(PathsConfig.class).build().getConfigData(PathsConfig.class);
        ApplicationDefinition appDefinition = ApplicationDefinitionLoader.loadDefault(defaultPathsConfig, FileUtils.getAbsolutePath((String)"config.txt"));
        ParameterProvider.getInstance().setParameters(appDefinition.getAppParameters());
        if (!Files.exists(resultingStateDirectory, new LinkOption[0])) {
            Files.createDirectories(resultingStateDirectory, new FileAttribute[0]);
        }
        logger.info(LogMarker.STARTUP.getMarker(), "Loading state from {}", (Object)signedStateFile);
        SwirldMain<? extends MerkleNodeState> hederaApp = HederaUtils.createHederaAppMain(platformContext, platformStateFacade);
        DeserializedSignedState deserializedSignedState = SignedStateFileReader.readStateFile(signedStateFile, v -> (MerkleNodeState)hederaApp.stateRootFromVirtualMap(platformContext.getMetrics(), platformContext.getTime()).apply((VirtualMap)v), platformStateFacade, platformContext);
        StateLifecycleManagerImpl stateLifecycleManager = new StateLifecycleManagerImpl(platformContext.getMetrics(), platformContext.getTime(), hederaApp.stateRootFromVirtualMap(platformContext.getMetrics(), platformContext.getTime()));
        try (ReservedSignedState initialState = deserializedSignedState.reservedSignedState();){
            HederaUtils.updateStateHash(hederaApp, deserializedSignedState);
            logger.info(LogMarker.STARTUP.getMarker(), "State from round {} loaded.", (Object)initialState.get().getRound());
            logger.info(LogMarker.STARTUP.getMarker(), "Loading event stream at {}", (Object)eventStreamDirectory);
            EventStreamRoundIterator roundIterator = new EventStreamRoundIterator(initialState.get().getRoster(), eventStreamDirectory, initialState.get().getRound() + 1L, allowPartialRounds);
            logger.info(LogMarker.STARTUP.getMarker(), "Reapplying transactions");
            RecoveredState recoveredState = EventRecoveryWorkflow.reapplyTransactions(platformContext, initialState.getAndReserve("recoverState()"), hederaApp, roundIterator, finalRound, selfId, loadSigningKeys, platformStateFacade);
            logger.info(LogMarker.STARTUP.getMarker(), "Finished reapplying transactions, writing state to {}", (Object)resultingStateDirectory);
            MerkleNodeState mutableStateCopy = recoveredState.state().get().getState().copy();
            SignedStateFileWriter.writeSignedStateFilesToDirectory(platformContext, selfId, resultingStateDirectory, recoveredState.state().get(), platformStateFacade, (StateLifecycleManager)stateLifecycleManager);
            StateConfig stateConfig = (StateConfig)platformContext.getConfiguration().getConfigData(StateConfig.class);
            EventRecoveryWorkflow.updateEmergencyRecoveryFile(stateConfig, resultingStateDirectory, initialState.get().getConsensusTimestamp());
            logger.info(LogMarker.STARTUP.getMarker(), "Signed state written to disk");
            PcesFile preconsensusEventFile = PcesFile.of(Instant.now(), 0L, recoveredState.judge().getBirthRound(), recoveredState.judge().getBirthRound(), recoveredState.state().get().getRound(), resultingStateDirectory);
            PcesFileWriterType type = ((PcesConfig)platformContext.getConfiguration().getConfigData(PcesConfig.class)).pcesFileWriterType();
            PcesMutableFile mutableFile = preconsensusEventFile.getMutableFile(type);
            mutableFile.writeEvent(recoveredState.judge());
            mutableFile.close();
            recoveredState.state().close();
            mutableStateCopy.release();
            logger.info(LogMarker.STARTUP.getMarker(), "Recovery process completed");
        }
    }

    public static void updateEmergencyRecoveryFile(@NonNull StateConfig stateConfig, @NonNull Path recoveryFileDir, @NonNull Instant bootstrapTime) {
        try {
            EmergencyRecoveryFile oldRecoveryFile = EmergencyRecoveryFile.read(stateConfig, recoveryFileDir);
            if (oldRecoveryFile == null) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "Recovery file does not exist at {}", (Object)recoveryFileDir);
                return;
            }
            Path backupDir = recoveryFileDir.resolve("backup");
            if (!Files.exists(backupDir, new LinkOption[0])) {
                Files.createDirectories(backupDir, new FileAttribute[0]);
            }
            oldRecoveryFile.write(backupDir);
            EmergencyRecoveryFile newRecoveryFile = new EmergencyRecoveryFile(oldRecoveryFile.recovery().state(), bootstrapTime);
            newRecoveryFile.write(recoveryFileDir);
        }
        catch (IOException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Exception occurred when updating the emergency recovery file with the bootstrap time");
        }
    }

    private static void notifyStateRecovered(NotificationEngine notificationEngine, SignedState recoveredState) {
        NewRecoveredStateNotification notification = new NewRecoveredStateNotification(recoveredState.getState(), recoveredState.getRound(), recoveredState.getConsensusTimestamp());
        notificationEngine.dispatch(NewRecoveredStateListener.class, (Notification)notification);
    }

    @NonNull
    public static RecoveredState reapplyTransactions(@NonNull PlatformContext platformContext, @NonNull ReservedSignedState initialSignedState, @NonNull SwirldMain appMain, @NonNull IOIterator<StreamedRound> roundIterator, long finalRound, @NonNull NodeId selfId, boolean loadSigningKeys, @NonNull PlatformStateFacade platformStateFacade) throws IOException {
        Objects.requireNonNull(platformContext, "platformContext must not be null");
        Objects.requireNonNull(initialSignedState, "initialSignedState must not be null");
        Objects.requireNonNull(appMain, "appMain must not be null");
        Objects.requireNonNull(roundIterator, "roundIterator must not be null");
        Objects.requireNonNull(selfId, "selfId must not be null");
        Configuration configuration = platformContext.getConfiguration();
        MerkleNodeState initialState = initialSignedState.get().getState();
        initialState.throwIfImmutable("initial state must be mutable");
        logger.info(LogMarker.STARTUP.getMarker(), "Initializing application state");
        RecoveryPlatform platform = new RecoveryPlatform(configuration, initialSignedState.get(), selfId, loadSigningKeys);
        ConsensusStateEventHandler<MerkleNodeState> consensusStateEventHandler = appMain.newConsensusStateEvenHandler();
        SemanticVersion softwareVersion = platformStateFacade.creationSoftwareVersionOf((State)initialState);
        NotificationEngine notificationEngine = platform.getNotificationEngine();
        notificationEngine.register(NewRecoveredStateListener.class, notification -> consensusStateEventHandler.onNewRecoveredState(notification.getState()));
        consensusStateEventHandler.onStateInitialized(initialState, platform, InitTrigger.EVENT_STREAM_RECOVERY, softwareVersion);
        appMain.init(platform, platform.getSelfId());
        ReservedSignedState signedState = initialSignedState;
        ConsensusEvent lastEvent = null;
        while (roundIterator.hasNext() && (finalRound == -1L || ((StreamedRound)roundIterator.peek()).getRoundNum() <= finalRound)) {
            StreamedRound round = (StreamedRound)roundIterator.next();
            logger.info(LogMarker.STARTUP.getMarker(), "Applying {} events from round {}", (Object)round.getEventCount(), (Object)round.getRoundNum());
            signedState = EventRecoveryWorkflow.handleNextRound(consensusStateEventHandler, platformContext, signedState, round, platformStateFacade);
            platform.setLatestState(signedState.get());
            lastEvent = EventRecoveryWorkflow.getLastEvent(round);
        }
        logger.info(LogMarker.STARTUP.getMarker(), "Hashing resulting signed state");
        try {
            platformContext.getMerkleCryptography().digestTreeAsync(signedState.get().getState().getRoot()).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("interrupted while attempting to hash the state", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        logger.info(LogMarker.STARTUP.getMarker(), "Hashing complete");
        EventRecoveryWorkflow.notifyStateRecovered(platform.getNotificationEngine(), signedState.get());
        platform.close();
        return new RecoveredState(signedState, ((CesEvent)Objects.requireNonNull(lastEvent)).getPlatformEvent());
    }

    private static ReservedSignedState handleNextRound(@NonNull ConsensusStateEventHandler consensusStateEventHandler, @NonNull PlatformContext platformContext, @NonNull ReservedSignedState previousSignedState, @NonNull StreamedRound round, @NonNull PlatformStateFacade platformStateFacade) {
        Instant currentRoundTimestamp = EventRecoveryWorkflow.getRoundTimestamp(round);
        SignedState previousState = previousSignedState.get();
        previousState.getState().throwIfImmutable();
        MerkleNodeState newState = previousState.getState().copy();
        PlatformEvent lastEvent = ((CesEvent)EventRecoveryWorkflow.getLastEvent(round)).getPlatformEvent();
        ConsensusConfig config = (ConsensusConfig)platformContext.getConfiguration().getConfigData(ConsensusConfig.class);
        new DefaultEventHasher().hashEvent(lastEvent);
        platformStateFacade.bulkUpdateOf((State)newState, v -> {
            v.setRound(round.getRoundNum());
            v.setLegacyRunningEventHash(EventRecoveryWorkflow.getHashEventsCons(platformStateFacade.legacyRunningEventHashOf((State)newState), round));
            v.setConsensusTimestamp(currentRoundTimestamp);
            v.setSnapshot(SyntheticSnapshot.generateSyntheticSnapshot(round.getRoundNum(), lastEvent.getConsensusOrder(), currentRoundTimestamp, config, lastEvent));
            v.setCreationSoftwareVersion(platformStateFacade.creationSoftwareVersionOf((State)previousState.getState()));
        });
        EventRecoveryWorkflow.applyTransactions(consensusStateEventHandler, previousState.getState(), newState, round);
        boolean isFreezeState = EventRecoveryWorkflow.isFreezeState(previousState.getConsensusTimestamp(), currentRoundTimestamp, platformStateFacade.freezeTimeOf((State)newState));
        if (isFreezeState) {
            platformStateFacade.updateLastFrozenTime((State)newState);
        }
        SignedState signedState = new SignedState(platformContext.getConfiguration(), CryptoStatic::verifySignature, newState, "EventRecoveryWorkflow.handleNextRound()", isFreezeState, false, false, platformStateFacade);
        ReservedSignedState reservedSignedState = signedState.reserve("recovery");
        previousSignedState.close();
        return reservedSignedState;
    }

    static Hash getHashEventsCons(Hash previousRunningHash, StreamedRound round) {
        RunningHashCalculatorForStream hashCalculator = new RunningHashCalculatorForStream();
        hashCalculator.setRunningHash(previousRunningHash);
        Iterator<ConsensusEvent> iterator = round.iterator();
        while (iterator.hasNext()) {
            ConsensusEvent event = iterator.next();
            hashCalculator.addObject((RunningHashable)((CesEvent)event));
        }
        Hash runningHash = hashCalculator.getRunningHash();
        hashCalculator.close();
        return runningHash;
    }

    static Instant getRoundTimestamp(Round round) {
        return EventRecoveryWorkflow.getLastEvent(round).getConsensusTimestamp();
    }

    static ConsensusEvent getLastEvent(Round round) {
        Iterator iterator = round.iterator();
        while (iterator.hasNext()) {
            ConsensusEvent event = (ConsensusEvent)iterator.next();
            if (iterator.hasNext()) continue;
            return event;
        }
        throw new IllegalStateException("round has no events");
    }

    static void applyTransactions(ConsensusStateEventHandler<MerkleNodeState> consensusStateEventHandler, MerkleNodeState immutableState, MerkleNodeState mutableState, Round round) {
        mutableState.throwIfImmutable();
        for (ConsensusEvent event : round) {
            consensusStateEventHandler.onPreHandle((Event)event, immutableState, DefaultTransactionPrehandler.NO_OP_CONSUMER);
        }
        consensusStateEventHandler.onHandleConsensusRound(round, mutableState, DefaultTransactionPrehandler.NO_OP_CONSUMER);
    }

    static boolean isFreezeState(Instant previousRoundTimestamp, Instant currentRoundTimestamp, Instant freezeTime) {
        if (freezeTime == null) {
            return false;
        }
        return CompareTo.isLessThan((Comparable)previousRoundTimestamp, (Object)freezeTime) && CompareTo.isGreaterThanOrEqualTo((Comparable)currentRoundTimestamp, (Object)freezeTime);
    }

    public static void repairEventStream(Path eventStreamDirectory, Path repairedEventStreamDirectory, long finalEventRound, Hash finalEventHash) {
    }
}

