/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.config.impl.validators.annotation.internal;

import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.validation.ConfigValidator;
import com.swirlds.config.api.validation.ConfigViolation;
import com.swirlds.config.api.validation.annotation.ConstraintMethod;
import com.swirlds.config.extensions.reflection.ConfigReflectionUtils;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.stream.Stream;

public class ConstraintMethodConstraintsValidation
implements ConfigValidator {
    public Stream<ConfigViolation> validate(Configuration configuration) {
        return ConfigReflectionUtils.getAllMatchingPropertiesForConstraintAnnotation(ConstraintMethod.class, (Configuration)configuration).stream().map(property -> ConstraintMethodConstraintsValidation.execute(configuration, property)).filter(Objects::nonNull);
    }

    private static ConfigViolation execute(Configuration configuration, ConfigReflectionUtils.AnnotatedProperty<ConstraintMethod, ?> annotatedProperty) {
        try {
            String methodName = ((ConstraintMethod)annotatedProperty.annotation()).value();
            Class<?> recordType = annotatedProperty.component().getDeclaringRecord();
            Record recordInstance = configuration.getConfigData(recordType);
            Method method = annotatedProperty.component().getDeclaringRecord().getMethod(methodName, Configuration.class);
            Object violation = method.invoke((Object)recordInstance, configuration);
            if (violation == null) {
                return null;
            }
            if (violation instanceof ConfigViolation) {
                ConfigViolation configViolation = (ConfigViolation)violation;
                return configViolation;
            }
            throw new IllegalStateException("Validation failed since method '" + methodName + " in record '" + String.valueOf(recordType) + "' does not follow the definition pattern 'public " + ConfigViolation.class.getName() + " method(" + Configuration.class.getName() + " config)'");
        }
        catch (Exception e) {
            throw new IllegalStateException("Validation failed!", e);
        }
    }
}

