/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.transformers;

import com.swirlds.component.framework.model.WiringModel;
import com.swirlds.component.framework.schedulers.TaskScheduler;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerType;
import com.swirlds.component.framework.wires.input.BindableInputWire;
import com.swirlds.component.framework.wires.input.InputWire;
import com.swirlds.component.framework.wires.output.OutputWire;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.Predicate;

public class WireFilter<T> {
    private final BindableInputWire<T, T> inputWire;
    private final OutputWire<T> outputWire;

    public WireFilter(@NonNull WiringModel model, @NonNull String filterName, @NonNull String filterInputName, @NonNull Predicate<T> predicate) {
        Objects.requireNonNull(predicate);
        TaskScheduler taskScheduler = model.schedulerBuilder(filterName).withType(TaskSchedulerType.DIRECT_THREADSAFE).build();
        this.inputWire = taskScheduler.buildInputWire(filterInputName);
        this.inputWire.bind((IN t) -> {
            if (predicate.test(t)) {
                return t;
            }
            return null;
        });
        this.outputWire = taskScheduler.getOutputWire();
    }

    public WireFilter(@NonNull WiringModel model, @NonNull String filterName, @NonNull String filterInputName) {
        TaskScheduler taskScheduler = model.schedulerBuilder(filterName).withType(TaskSchedulerType.DIRECT_THREADSAFE).build();
        this.inputWire = taskScheduler.buildInputWire(filterInputName);
        this.outputWire = taskScheduler.getOutputWire();
    }

    @NonNull
    public InputWire<T> getInputWire() {
        return this.inputWire;
    }

    @NonNull
    public OutputWire<T> getOutputWire() {
        return this.outputWire;
    }

    public void bind(@NonNull Predicate<T> predicate) {
        this.inputWire.bind((IN t) -> {
            if (predicate.test(t)) {
                return t;
            }
            return null;
        });
    }
}

