/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.event.branching;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.metrics.SpeedometerMetric;
import com.swirlds.metrics.api.DoubleGauge;
import com.swirlds.metrics.api.LongGauge;
import com.swirlds.metrics.api.MetricConfig;
import edu.umd.cs.findbugs.annotations.NonNull;

public class BranchingMetrics {
    private static final SpeedometerMetric.Config BRANCHING_EVENT_SPEEDOMETER_CONFIG = new SpeedometerMetric.Config("platform", "branchingEvents").withUnit("hz");
    private final SpeedometerMetric branchingEvents;
    private static final LongGauge.Config BRANCHING_NODE_COUNT_CONFIG = new LongGauge.Config("platform", "branchingNodeCount").withUnit("count");
    private final LongGauge branchingNodeCount;
    private static final DoubleGauge.Config BRANCHING_WEIGHT_FRACTION_CONFIG = new DoubleGauge.Config("platform", "branchingWeightFraction").withUnit("fraction");
    private final DoubleGauge branchingWeightFraction;

    public BranchingMetrics(@NonNull PlatformContext platformContext) {
        this.branchingEvents = (SpeedometerMetric)platformContext.getMetrics().getOrCreate((MetricConfig)BRANCHING_EVENT_SPEEDOMETER_CONFIG);
        this.branchingNodeCount = (LongGauge)platformContext.getMetrics().getOrCreate((MetricConfig)BRANCHING_NODE_COUNT_CONFIG);
        this.branchingWeightFraction = (DoubleGauge)platformContext.getMetrics().getOrCreate((MetricConfig)BRANCHING_WEIGHT_FRACTION_CONFIG);
    }

    public void reportBranchingEvent() {
        this.branchingEvents.cycle();
    }

    public void reportBranchingNodeCount(int count) {
        this.branchingNodeCount.set((long)count);
    }

    public void reportBranchingWeightFraction(double fraction) {
        this.branchingWeightFraction.set(fraction);
    }
}

