/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.roster.internal;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.WritableStreamingData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import org.hiero.base.crypto.DigestType;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.HashingOutputStream;

public class PbjRecordHasher {
    private static final DigestType DIGEST_TYPE = DigestType.SHA_384;
    private final MessageDigest digest = DIGEST_TYPE.buildDigest();
    private final WritableSequentialData stream = new WritableStreamingData((OutputStream)new HashingOutputStream(this.digest));

    @NonNull
    public <T> Hash hash(@NonNull T record, @NonNull Codec<T> codec) {
        try {
            codec.write(record, this.stream);
        }
        catch (IOException e) {
            throw new RuntimeException("An exception occurred while trying to hash a record!", e);
        }
        return new Hash(this.digest.digest(), DIGEST_TYPE);
    }
}

