/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.event;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.platform.internal.EventImpl;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.stream.Stream;
import org.hiero.base.crypto.SignatureType;
import org.hiero.base.crypto.test.fixtures.CryptoRandomUtils;
import org.hiero.consensus.crypto.PbjStreamHasher;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.event.UnsignedEvent;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.transaction.TransactionWrapper;

public class RandomEventUtils {
    public static final Instant DEFAULT_FIRST_EVENT_TIME_CREATED = Instant.ofEpochMilli(1588771316678L);

    public static EventImpl randomEventWithTimestamp(Random random, NodeId creatorId, Instant timestamp, long birthRound, TransactionWrapper[] transactions, EventImpl selfParent, EventImpl otherParent, boolean fakeHash) {
        UnsignedEvent unsignedEvent = RandomEventUtils.randomUnsignedEventWithTimestamp(random, creatorId, timestamp, birthRound, transactions, selfParent, otherParent, fakeHash);
        byte[] sig = new byte[SignatureType.RSA.signatureLength()];
        random.nextBytes(sig);
        return new EventImpl(new PlatformEvent(unsignedEvent, Bytes.wrap((byte[])sig)), selfParent, otherParent);
    }

    public static UnsignedEvent randomUnsignedEventWithTimestamp(@NonNull Random random, @NonNull NodeId creatorId, @NonNull Instant timestamp, long birthRound, @Nullable TransactionWrapper[] transactions, @Nullable EventImpl selfParent, @Nullable EventImpl otherParent, boolean fakeHash) {
        EventDescriptorWrapper selfDescriptor = selfParent == null || selfParent.getBaseHash() == null ? null : selfParent.getBaseEvent().getDescriptor();
        EventDescriptorWrapper otherDescriptor = otherParent == null || otherParent.getBaseHash() == null ? null : otherParent.getBaseEvent().getDescriptor();
        ArrayList convertedTransactions = new ArrayList();
        if (transactions != null) {
            Stream.of(transactions).map(TransactionWrapper::getApplicationTransaction).forEach(convertedTransactions::add);
        }
        UnsignedEvent unsignedEvent = new UnsignedEvent(creatorId, selfDescriptor, otherDescriptor == null ? Collections.emptyList() : Collections.singletonList(otherDescriptor), birthRound, timestamp, convertedTransactions, random.nextLong(0L, Long.MAX_VALUE));
        if (fakeHash) {
            unsignedEvent.setHash(CryptoRandomUtils.randomHash((Random)random));
        } else {
            new PbjStreamHasher().hashUnsignedEvent(unsignedEvent);
        }
        return unsignedEvent;
    }
}

