/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.virtualmerkle;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.iterators.MerkleIterationOrder;
import com.swirlds.common.merkle.iterators.MerkleIterator;
import com.swirlds.demo.platform.PlatformTestingToolMain;
import com.swirlds.virtualmap.VirtualMap;
import com.swirlds.virtualmap.internal.merkle.VirtualLeafNode;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import org.hiero.base.constructable.ConstructableRegistry;
import org.hiero.base.constructable.ConstructableRegistryException;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.CryptographyProvider;
import org.hiero.base.crypto.Hash;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class VirtualMerkleLeafHasher {
    private static final Cryptography CRYPTOGRAPHY = CryptographyProvider.getInstance();
    private final VirtualMap virtualMap;

    public VirtualMerkleLeafHasher(VirtualMap virtualMap) {
        this.virtualMap = virtualMap;
    }

    public Hash validate() throws IOException {
        Hash hash = null;
        MerkleIterator iterator = this.virtualMap.treeIterator().setOrder(MerkleIterationOrder.BREADTH_FIRST);
        while (iterator.hasNext()) {
            MerkleNode node = (MerkleNode)iterator.next();
            if (node == null || !(node instanceof VirtualLeafNode)) continue;
            VirtualLeafNode leaf = (VirtualLeafNode)node.cast();
            hash = this.computeNextHash(hash, leaf);
        }
        return hash;
    }

    public Hash computeNextHash(Hash prevHash, VirtualLeafNode leaf) throws IOException {
        try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
            Hash hash;
            try (SerializableDataOutputStream out = new SerializableDataOutputStream((OutputStream)bout);){
                if (prevHash != null) {
                    prevHash.getBytes().writeTo((OutputStream)out);
                }
                leaf.getKey().writeTo((OutputStream)out);
                if (leaf.getValue() != null) {
                    leaf.getValue().writeTo((OutputStream)out);
                }
                out.flush();
                hash = VirtualMerkleLeafHasher.hashOf(bout.toByteArray());
            }
            return hash;
        }
    }

    public static Hash hashOf(byte[] content) {
        return new Hash(CRYPTOGRAPHY.digestSync(content));
    }

    public static void main(String[] args) throws IOException {
        List<Path> roundsFolders;
        try {
            ConstructableRegistry registry = ConstructableRegistry.getInstance();
            registry.registerConstructables("com.swirlds.virtualmap");
            registry.registerConstructables("com.swirlds.merkledb");
            registry.registerConstructables("com.swirlds.demo.virtualmerkle");
            registry.registerConstructables("com.swirlds.common.crypto");
            registry.registerConstructables("org.hiero");
        }
        catch (ConstructableRegistryException e) {
            e.printStackTrace();
            return;
        }
        String accountsName = "accounts.vmap";
        String scName = "smartContracts.vmap";
        String scByteCodeName = "smartContractByteCode.vmap";
        Path classFolder = FileUtils.getAbsolutePath((String)args[0]);
        try (Stream<Path> classFolderList = Files.list(classFolder);){
            Path nodeFolder = classFolderList.toList().get(0);
            try (Stream<Path> swirldIdList = Files.list(nodeFolder.resolve("123"));){
                roundsFolders = swirldIdList.toList();
            }
        }
        for (Path roundFolder : roundsFolders) {
            Hash byteCodeHash;
            Hash scHash;
            Hash accountsHash;
            try {
                VirtualMap accountsMap = new VirtualMap(PlatformTestingToolMain.CONFIGURATION);
                accountsMap.loadFromFile(roundFolder.resolve("accounts.vmap"));
                VirtualMerkleLeafHasher accountsHasher = new VirtualMerkleLeafHasher(accountsMap);
                accountsHash = accountsHasher.validate();
            }
            catch (IOException e) {
                accountsHash = null;
            }
            try {
                VirtualMap scMap = new VirtualMap(PlatformTestingToolMain.CONFIGURATION);
                scMap.loadFromFile(roundFolder.resolve("smartContracts.vmap"));
                VirtualMerkleLeafHasher scHasher = new VirtualMerkleLeafHasher(scMap);
                scHash = scHasher.validate();
            }
            catch (IOException e) {
                scHash = null;
            }
            try {
                VirtualMap byteCodeMap = new VirtualMap(PlatformTestingToolMain.CONFIGURATION);
                byteCodeMap.loadFromFile(roundFolder.resolve("smartContractByteCode.vmap"));
                VirtualMerkleLeafHasher byteCodeHasher = new VirtualMerkleLeafHasher(byteCodeMap);
                byteCodeHash = byteCodeHasher.validate();
            }
            catch (IOException e) {
                byteCodeHash = null;
            }
            Path vmapLogPath = roundFolder.resolve("vmapHashes.json");
            try (FileOutputStream fos = new FileOutputStream(vmapLogPath.toString());){
                ObjectMapper mapper = new ObjectMapper();
                ObjectNode rootNode = mapper.createObjectNode();
                if (accountsHash != null) {
                    rootNode.put("accounts", accountsHash.toHex());
                } else {
                    rootNode.put("accounts", "empty");
                }
                if (scHash != null) {
                    rootNode.put("sc", scHash.toHex());
                } else {
                    rootNode.put("sc", "empty");
                }
                if (byteCodeHash != null) {
                    rootNode.put("byteCode", byteCodeHash.toHex());
                } else {
                    rootNode.put("byteCode", "empty");
                }
                fos.write(mapper.writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)rootNode));
            }
        }
    }
}

