/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.api.extensions.handler;

import com.swirlds.config.api.Configuration;
import com.swirlds.logging.api.Level;
import com.swirlds.logging.api.Marker;
import com.swirlds.logging.api.extensions.emergency.EmergencyLogger;
import com.swirlds.logging.api.extensions.emergency.EmergencyLoggerProvider;
import com.swirlds.logging.api.extensions.handler.LogHandler;
import com.swirlds.logging.api.internal.level.HandlerLoggingLevelConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractLogHandler
implements LogHandler {
    protected static final EmergencyLogger EMERGENCY_LOGGER = EmergencyLoggerProvider.getEmergencyLogger();
    private final String configKey;
    private final Configuration configuration;
    private final AtomicReference<HandlerLoggingLevelConfig> loggingLevelConfig;

    public AbstractLogHandler(@NonNull String configKey, @NonNull Configuration configuration) {
        this.configKey = Objects.requireNonNull(configKey, "configKey must not be null");
        this.configuration = Objects.requireNonNull(configuration, "configuration must not be null");
        this.loggingLevelConfig = new AtomicReference<HandlerLoggingLevelConfig>(HandlerLoggingLevelConfig.create(configuration, configKey));
    }

    @Override
    public boolean isActive() {
        return Boolean.TRUE.equals(this.configuration.getValue("logging.handler.%s.enabled".formatted(this.configKey), Boolean.class, (Object)false));
    }

    @Override
    public boolean isEnabled(@NonNull String name, @NonNull Level level, @Nullable Marker marker) {
        if (marker == null) {
            return this.loggingLevelConfig.get().isEnabled(name, level);
        }
        return this.loggingLevelConfig.get().isEnabled(name, level, marker);
    }

    @Override
    public void update(@NonNull Configuration configuration) {
        this.loggingLevelConfig.set(HandlerLoggingLevelConfig.create(configuration, this.configKey));
    }

    @NonNull
    protected Configuration getConfiguration() {
        return this.configuration;
    }
}

