/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.cli;

import com.swirlds.cli.commands.EventStreamCommand;
import com.swirlds.cli.utility.AbstractCommand;
import com.swirlds.cli.utility.SubcommandOf;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.platform.config.DefaultConfiguration;
import com.swirlds.platform.recovery.EventRecoveryWorkflow;
import com.swirlds.platform.state.service.PlatformStateFacade;
import java.nio.file.Path;
import java.util.List;
import org.hiero.consensus.model.node.NodeId;
import picocli.CommandLine;

@CommandLine.Command(name="recover", mixinStandardHelpOptions=true, description={"Build a state file by replaying events from an event stream."})
@SubcommandOf(value=EventStreamCommand.class)
public final class EventStreamRecoverCommand
extends AbstractCommand {
    private Path outputPath = Path.of("./out", new String[0]);
    private String appMainName;
    private Path bootstrapSignedState;
    private NodeId selfId;
    private boolean ignorePartialRounds;
    private long finalRound = -1L;
    private Path eventStreamDirectory;
    private List<Path> configurationPaths = List.of();
    private boolean loadSigningKeys;

    private EventStreamRecoverCommand() {
    }

    @CommandLine.Option(names={"-c", "--config"}, description={"A path to where a configuration file can be found. If not provided then defaults are used."})
    private void setConfigurationPath(List<Path> configurationPaths) {
        configurationPaths.forEach(x$0 -> this.pathMustExist((Path)x$0));
        this.configurationPaths = configurationPaths;
    }

    @CommandLine.Option(names={"-o", "--out"}, description={"The location where output is written. Default = './out'. Must not exist prior to invocation."})
    private void setOutputPath(Path outputPath) {
        this.outputPath = outputPath;
    }

    @CommandLine.Parameters(index="1", description={"The path to a directory tree containing event stream files."})
    private void setEventStreamDirectory(Path eventStreamDirectory) {
        this.eventStreamDirectory = this.pathMustExist(eventStreamDirectory.toAbsolutePath());
    }

    @CommandLine.Option(names={"-n", "--main-name"}, required=true, description={"The fully qualified name of the application's main class."})
    private void setAppMainName(String appMainName) {
        this.appMainName = appMainName;
    }

    @CommandLine.Parameters(index="0", description={"The path to the bootstrap state directory.Events will be replayed on top of this state."})
    private void setBootstrapSignedState(Path bootstrapSignedStateDir) {
        this.bootstrapSignedState = this.dirMustExist(bootstrapSignedStateDir.toAbsolutePath());
    }

    @CommandLine.Option(names={"-i", "--id"}, required=true, description={"The ID of the node that is being used to recover the state. This node's keys should be available locally."})
    private void setSelfId(long selfId) {
        this.selfId = NodeId.of((long)selfId);
    }

    @CommandLine.Option(names={"-p", "--ignore-partial"}, description={"if set then any partial rounds at the end of the event stream are ignored. Default = false"})
    private void setIgnorePartialRounds(boolean ignorePartialRounds) {
        this.ignorePartialRounds = ignorePartialRounds;
    }

    @CommandLine.Option(names={"-f", "--final-round"}, defaultValue="-1", description={"The last round that should be applied to the state, any higher rounds are ignored. Default = apply all available rounds"})
    private void setFinalRound(long finalRound) {
        this.finalRound = finalRound;
    }

    @CommandLine.Option(names={"-s", "--load-signing-keys"}, defaultValue="false", description={"If present then load the signing keys. If not present, calling platform.sign() will throw."})
    private void setLoadSigningKeys(boolean loadSigningKeys) {
        this.loadSigningKeys = loadSigningKeys;
    }

    public Integer call() throws Exception {
        Configuration configuration = DefaultConfiguration.buildBasicConfiguration(ConfigurationBuilder.create(), FileUtils.getAbsolutePath((String)"settings.txt"), this.configurationPaths);
        PlatformContext platformContext = PlatformContext.create((Configuration)configuration);
        EventRecoveryWorkflow.recoverState(platformContext, this.bootstrapSignedState, this.configurationPaths, this.eventStreamDirectory, this.appMainName, !this.ignorePartialRounds, this.finalRound, this.outputPath, this.selfId, this.loadSigningKeys, PlatformStateFacade.DEFAULT_PLATFORM_STATE_FACADE);
        return 0;
    }
}

