/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.model.hashgraph;

import com.swirlds.base.utility.ToStringBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.event.PlatformEvent;

public record EventWindow(long latestConsensusRound, long newEventBirthRound, long ancientThreshold, long expiredThreshold) {
    public EventWindow {
        if (latestConsensusRound < 0L) {
            throw new IllegalArgumentException("The latest consensus round cannot be less than ROUND_NEGATIVE_INFINITY (%d).".formatted(0L));
        }
        if (newEventBirthRound < 1L) {
            throw new IllegalArgumentException("The event birth round cannot be less than the first round (%d)".formatted(1L));
        }
        if (ancientThreshold < 1L) {
            throw new IllegalArgumentException("the minimum round non-ancient cannot be lower than the first round of consensus.");
        }
        if (expiredThreshold < 1L) {
            throw new IllegalArgumentException("the minimum round non-expired cannot be lower than the first round of consensus.");
        }
    }

    @NonNull
    public static EventWindow getGenesisEventWindow() {
        return new EventWindow(0L, 1L, 1L, 1L);
    }

    public boolean isGenesis() {
        return this.latestConsensusRound == 0L;
    }

    public long getPendingConsensusRound() {
        return this.latestConsensusRound + 1L;
    }

    public boolean isAncient(@NonNull PlatformEvent event) {
        return event.getBirthRound() < this.ancientThreshold;
    }

    public boolean isAncient(@NonNull EventDescriptorWrapper event) {
        return event.birthRound() < this.ancientThreshold;
    }

    public boolean isAncient(long testValue) {
        return testValue < this.ancientThreshold;
    }

    @Override
    @NonNull
    public String toString() {
        return new ToStringBuilder((Object)this).append("latestConsensusRound", (Object)this.latestConsensusRound).append("newEventBirthRound", (Object)this.newEventBirthRound).append("ancientThreshold", (Object)this.ancientThreshold).append("expiredThreshold", (Object)this.expiredThreshold).toString();
    }
}

