/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.block.api;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.grpc.GrpcCall;
import com.hedera.pbj.runtime.grpc.GrpcClient;
import com.hedera.pbj.runtime.grpc.Pipeline;
import com.hedera.pbj.runtime.grpc.Pipelines;
import com.hedera.pbj.runtime.grpc.ServiceInterface;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Flow;
import org.hiero.block.api.SubscribeStreamRequest;
import org.hiero.block.api.SubscribeStreamResponse;

public interface BlockStreamSubscribeServiceInterface
extends ServiceInterface {
    public static final String SERVICE_NAME = "BlockStreamSubscribeService";
    public static final String FULL_NAME = "org.hiero.block.api.BlockStreamSubscribeService";

    public void subscribeBlockStream(@NonNull SubscribeStreamRequest var1, @NonNull Pipeline<? super SubscribeStreamResponse> var2);

    @NonNull
    default public String serviceName() {
        return SERVICE_NAME;
    }

    @NonNull
    default public String fullName() {
        return FULL_NAME;
    }

    @NonNull
    default public List<ServiceInterface.Method> methods() {
        return Arrays.asList(BlockStreamSubscribeServiceMethod.values());
    }

    @NonNull
    default public Pipeline<? super Bytes> open(@NonNull ServiceInterface.Method method, @NonNull ServiceInterface.RequestOptions options, @NonNull Pipeline<? super Bytes> replies) {
        BlockStreamSubscribeServiceMethod m = (BlockStreamSubscribeServiceMethod)method;
        try {
            switch (m.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: 
            }
            return Pipelines.serverStreaming().mapRequest(bytes -> BlockStreamSubscribeServiceInterface.parseSubscribeStreamRequest(bytes, options)).method(this::subscribeBlockStream).mapResponse(reply -> BlockStreamSubscribeServiceInterface.serializeSubscribeStreamResponse(reply, options)).respondTo(replies).build();
        }
        catch (Exception e) {
            replies.onError((Throwable)e);
            return Pipelines.noop();
        }
    }

    @NonNull
    private static Codec<SubscribeStreamRequest> getSubscribeStreamRequestCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return SubscribeStreamRequest.JSON;
        }
        return SubscribeStreamRequest.PROTOBUF;
    }

    @NonNull
    private static Codec<SubscribeStreamResponse> getSubscribeStreamResponseCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return SubscribeStreamResponse.JSON;
        }
        return SubscribeStreamResponse.PROTOBUF;
    }

    @NonNull
    private static SubscribeStreamRequest parseSubscribeStreamRequest(@NonNull Bytes message, @NonNull ServiceInterface.RequestOptions options) throws ParseException {
        Objects.requireNonNull(message);
        Objects.requireNonNull(options);
        return (SubscribeStreamRequest)BlockStreamSubscribeServiceInterface.getSubscribeStreamRequestCodec(options).parse(message.toReadableSequentialData(), false, 16);
    }

    @NonNull
    private static Bytes serializeSubscribeStreamResponse(@NonNull SubscribeStreamResponse reply, @NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(reply);
        Objects.requireNonNull(options);
        return BlockStreamSubscribeServiceInterface.getSubscribeStreamResponseCodec(options).toBytes((Object)reply);
    }

    public static enum BlockStreamSubscribeServiceMethod implements ServiceInterface.Method
    {
        subscribeBlockStream;

    }

    public static class BlockStreamSubscribeServiceClient
    implements BlockStreamSubscribeServiceInterface {
        private final GrpcClient grpcClient;
        private final ServiceInterface.RequestOptions requestOptions;

        public BlockStreamSubscribeServiceClient(@NonNull GrpcClient grpcClient, @NonNull ServiceInterface.RequestOptions requestOptions) {
            this.grpcClient = Objects.requireNonNull(grpcClient);
            this.requestOptions = Objects.requireNonNull(requestOptions);
        }

        @Override
        public void subscribeBlockStream(@NonNull SubscribeStreamRequest request, final @NonNull Pipeline<? super SubscribeStreamResponse> replies) {
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<SubscribeStreamResponse> pipeline = new Pipeline<SubscribeStreamResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    replies.onSubscribe(subscription);
                }

                public void onNext(SubscribeStreamResponse reply) {
                    replies.onNext((Object)reply);
                }

                public void onError(Throwable throwable) {
                    replies.onError(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    replies.onComplete();
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("org.hiero.block.api.BlockStreamSubscribeService/subscribeBlockStream", BlockStreamSubscribeServiceInterface.getSubscribeStreamRequestCodec(this.requestOptions), BlockStreamSubscribeServiceInterface.getSubscribeStreamResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

