/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb;

import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.FieldType;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.stream.ReadableStreamingData;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.common.io.utility.LegacyTemporaryFileBuilder;
import com.swirlds.config.api.Configuration;
import com.swirlds.merkledb.MerkleDbDataSource;
import com.swirlds.merkledb.MerkleDbTableConfig;
import com.swirlds.merkledb.constructable.constructors.MerkleDbDataSourceBuilderConstructor;
import com.swirlds.virtualmap.datasource.VirtualDataSource;
import com.swirlds.virtualmap.datasource.VirtualDataSourceBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import org.hiero.base.constructable.ConstructableClass;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

@ConstructableClass(value=105533191404034088L, constructorType=MerkleDbDataSourceBuilderConstructor.class)
public class MerkleDbDataSourceBuilder
implements VirtualDataSourceBuilder {
    public static final long CLASS_ID = 105533191404034088L;
    private final Configuration configuration;
    private long initialCapacity = 0L;
    private long hashesRamToDiskThreshold = 0L;

    public MerkleDbDataSourceBuilder(@NonNull Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration);
    }

    public MerkleDbDataSourceBuilder(@NonNull Configuration configuration, long initialCapacity, long hashesRamToDiskThreshold) {
        this.configuration = Objects.requireNonNull(configuration);
        this.initialCapacity = initialCapacity;
        this.hashesRamToDiskThreshold = hashesRamToDiskThreshold;
    }

    private Path newDataSourceDir(String label) throws IOException {
        return LegacyTemporaryFileBuilder.buildTemporaryFile((String)("merkledb-" + label), (Configuration)this.configuration);
    }

    @NonNull
    public VirtualDataSource build(String label, boolean dbCompactionEnabled) {
        if (this.initialCapacity <= 0L) {
            throw new IllegalArgumentException("Initial map capacity not set");
        }
        try {
            Path dataSourceDir = this.newDataSourceDir(label);
            return new MerkleDbDataSource(dataSourceDir, this.configuration, label, this.initialCapacity, this.hashesRamToDiskThreshold, dbCompactionEnabled, false);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private void snapshotDataSource(MerkleDbDataSource dataSource, Path dir) {
        try {
            try {
                dataSource.pauseCompaction();
                dataSource.snapshot(dir);
            }
            finally {
                dataSource.resumeCompaction();
            }
        }
        catch (IOException z) {
            throw new UncheckedIOException(z);
        }
    }

    @NonNull
    public MerkleDbDataSource copy(VirtualDataSource dataSource, boolean compactionEnabled, boolean offlineUse) {
        if (!(dataSource instanceof MerkleDbDataSource)) {
            throw new IllegalArgumentException("The data source must be compatible with the MerkleDb");
        }
        MerkleDbDataSource merkleDbDataSource = (MerkleDbDataSource)dataSource;
        String label = merkleDbDataSource.getTableName();
        long initialCapacity = merkleDbDataSource.getInitialCapacity();
        long hashesRamToDiskThreshold = merkleDbDataSource.getHashesRamToDiskThreshold();
        try {
            Path dataSourceDir = this.newDataSourceDir(label);
            this.snapshotDataSource(merkleDbDataSource, dataSourceDir);
            return new MerkleDbDataSource(dataSourceDir, this.configuration, label, initialCapacity, hashesRamToDiskThreshold, compactionEnabled, offlineUse);
        }
        catch (IOException z) {
            throw new UncheckedIOException(z);
        }
    }

    public void snapshot(@NonNull Path snapshotDir, VirtualDataSource dataSource) {
        if (!(dataSource instanceof MerkleDbDataSource)) {
            throw new IllegalArgumentException("The data source must be compatible with the MerkleDb");
        }
        MerkleDbDataSource merkleDbDataSource = (MerkleDbDataSource)dataSource;
        String label = merkleDbDataSource.getTableName();
        Path snapshotDataSourceDir = snapshotDir.resolve("data").resolve(label);
        this.snapshotDataSource(merkleDbDataSource, snapshotDataSourceDir);
    }

    @NonNull
    public VirtualDataSource restore(String label, Path snapshotDir) {
        return this.restore(label, snapshotDir, true);
    }

    protected VirtualDataSource restore(String label, Path snapshotDir, boolean compactionEnabled) {
        try {
            Path dataSourceDir = this.newDataSourceDir(label);
            Path snapshotDataSourceDir = snapshotDir.resolve("data").resolve(label);
            if (Files.isDirectory(snapshotDataSourceDir, new LinkOption[0])) {
                FileUtils.hardLinkTree((Path)snapshotDataSourceDir, (Path)dataSourceDir);
                return new MerkleDbDataSource(dataSourceDir, this.configuration, label, compactionEnabled, false);
            }
            Path legacyDatabaseMetadataPath = snapshotDir.resolve("database_metadata.pbj");
            if (Files.isReadable(legacyDatabaseMetadataPath)) {
                TableMetadata tableMetadata = this.getLegacyTableMetadata(legacyDatabaseMetadataPath, label);
                if (tableMetadata != null) {
                    int tableId = tableMetadata.getTableId();
                    Path legacySnapshotDataSourceDir = snapshotDir.resolve("tables").resolve(label + "-" + tableId);
                    if (Files.isDirectory(legacySnapshotDataSourceDir, new LinkOption[0])) {
                        FileUtils.hardLinkTree((Path)legacySnapshotDataSourceDir, (Path)dataSourceDir);
                        long initialCapacity = tableMetadata.getTableConfig().getInitialCapacity();
                        long hashesRamToDiskThreshold = tableMetadata.getTableConfig().getHashesRamToDiskThreshold();
                        return new MerkleDbDataSource(dataSourceDir, this.configuration, label, initialCapacity, hashesRamToDiskThreshold, true, false);
                    }
                    throw new IOException("Table dir is not found: dir=" + String.valueOf(legacySnapshotDataSourceDir));
                }
                throw new IOException("Table metadata not found: label=" + label);
            }
            throw new IOException("Cannot restore MerkleDb data source: label=" + label + " snapshotDir=" + String.valueOf(snapshotDir));
        }
        catch (IOException z) {
            throw new UncheckedIOException(z);
        }
    }

    private TableMetadata getLegacyTableMetadata(Path databaseMetadataPath, String label) throws IOException {
        FieldDefinition FIELD_DBMETADATA_TABLEMETADATA = new FieldDefinition("tableMetadata", FieldType.MESSAGE, true, true, false, 11);
        try (ReadableStreamingData in = new ReadableStreamingData(databaseMetadataPath);){
            while (in.hasRemaining()) {
                int tag = in.readVarInt(false);
                int fieldNum = tag >> 3;
                if (fieldNum == FIELD_DBMETADATA_TABLEMETADATA.number()) {
                    int size = in.readVarInt(false);
                    long oldLimit = in.limit();
                    in.limit(in.position() + (long)size);
                    TableMetadata tableMetadata = new TableMetadata((ReadableSequentialData)in);
                    in.limit(oldLimit);
                    if (!label.equals(tableMetadata.getTableName())) continue;
                    TableMetadata tableMetadata2 = tableMetadata;
                    return tableMetadata2;
                }
                throw new IllegalArgumentException("Unknown database metadata field: " + fieldNum);
            }
        }
        return null;
    }

    public long getClassId() {
        return 105533191404034088L;
    }

    public int getVersion() {
        return 2;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeLong(this.initialCapacity);
        out.writeLong(this.hashesRamToDiskThreshold);
    }

    public void deserialize(@NonNull SerializableDataInputStream in, int version) throws IOException {
        if (version < 2) {
            MerkleDbTableConfig tableConfig = (MerkleDbTableConfig)in.readSerializable(false, MerkleDbTableConfig::new);
            this.initialCapacity = tableConfig.getInitialCapacity();
            this.hashesRamToDiskThreshold = tableConfig.getHashesRamToDiskThreshold();
        } else {
            this.initialCapacity = in.readLong();
            this.hashesRamToDiskThreshold = in.readLong();
        }
    }

    public int hashCode() {
        return Objects.hash(this.initialCapacity, this.hashesRamToDiskThreshold);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MerkleDbDataSourceBuilder)) {
            return false;
        }
        MerkleDbDataSourceBuilder that = (MerkleDbDataSourceBuilder)obj;
        return this.initialCapacity == that.initialCapacity && this.hashesRamToDiskThreshold == that.hashesRamToDiskThreshold;
    }

    private static class TableMetadata {
        private final int tableId;
        private final String tableName;
        private final MerkleDbTableConfig tableConfig;
        private static final FieldDefinition FIELD_TABLEMETADATA_TABLEID = new FieldDefinition("tableId", FieldType.UINT32, false, true, false, 1);
        private static final FieldDefinition FIELD_TABLEMETADATA_TABLENAME = new FieldDefinition("tableName", FieldType.BYTES, false, false, false, 2);
        private static final FieldDefinition FIELD_TABLEMETADATA_TABLECONFIG = new FieldDefinition("tableConfig", FieldType.MESSAGE, false, false, false, 3);

        public TableMetadata(ReadableSequentialData in) {
            int tableId = 0;
            String tableName = null;
            MerkleDbTableConfig tableConfig = null;
            while (in.hasRemaining()) {
                int len;
                int tag = in.readVarInt(false);
                int fieldNum = tag >> 3;
                if (fieldNum == FIELD_TABLEMETADATA_TABLEID.number()) {
                    tableId = in.readVarInt(false);
                    continue;
                }
                if (fieldNum == FIELD_TABLEMETADATA_TABLENAME.number()) {
                    len = in.readVarInt(false);
                    byte[] bb = new byte[len];
                    in.readBytes(bb);
                    tableName = new String(bb, StandardCharsets.UTF_8);
                    continue;
                }
                if (fieldNum == FIELD_TABLEMETADATA_TABLECONFIG.number()) {
                    len = in.readVarInt(false);
                    long oldLimit = in.limit();
                    in.limit(in.position() + (long)len);
                    tableConfig = new MerkleDbTableConfig(in);
                    in.limit(oldLimit);
                    continue;
                }
                throw new IllegalArgumentException("Unknown table metadata field: " + fieldNum);
            }
            Objects.requireNonNull(tableName, "Null table name");
            Objects.requireNonNull(tableConfig, "Null table config");
            if (tableId < 0) {
                throw new IllegalStateException("Corrupted MerkleDb metadata: wrong table ID");
            }
            this.tableId = tableId;
            this.tableName = tableName;
            this.tableConfig = tableConfig;
        }

        public int getTableId() {
            return this.tableId;
        }

        public String getTableName() {
            return this.tableName;
        }

        public MerkleDbTableConfig getTableConfig() {
            return this.tableConfig;
        }
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;
        public static final int NO_TABLE_CONFIG = 2;

        private ClassVersion() {
        }
    }
}

