/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.metrics.impl;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.metrics.api.IntegerGauge;
import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.snapshot.Snapshot;
import com.swirlds.metrics.impl.AbstractMetric;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultIntegerGauge
extends AbstractMetric
implements IntegerGauge {
    private final AtomicInteger value;

    public DefaultIntegerGauge(@NonNull IntegerGauge.Config config) {
        super((MetricConfig<?, ?>)config);
        this.value = new AtomicInteger(config.getInitialValue());
    }

    @NonNull
    public List<Snapshot.SnapshotEntry> takeSnapshot() {
        return List.of(new Snapshot.SnapshotEntry(Metric.ValueType.VALUE, (Object)this.get()));
    }

    public int get() {
        return this.value.get();
    }

    public void set(int newValue) {
        this.value.set(newValue);
    }

    public void add(int change) {
        this.value.addAndGet(change);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("value", (Object)this.value.get()).toString();
    }
}

