/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.crypto.engine;

import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.CryptographyException;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.SerializableHashable;
import org.hiero.base.crypto.SignatureType;
import org.hiero.base.crypto.TransactionSignature;
import org.hiero.base.crypto.VerificationStatus;
import org.hiero.base.crypto.engine.DigestProvider;
import org.hiero.base.crypto.engine.EcdsaSecp256k1VerificationProvider;
import org.hiero.base.crypto.engine.Ed25519VerificationProvider;
import org.hiero.base.crypto.engine.OperationProvider;
import org.hiero.base.crypto.engine.RunningHashProvider;
import org.hiero.base.crypto.engine.SerializationDigestProvider;
import org.hiero.base.io.SelfSerializable;

public class CryptoEngine
implements Cryptography {
    private final SerializationDigestProvider serializationDigestProvider;
    private final RunningHashProvider runningHashProvider;
    private final DigestProvider digestProvider = new DigestProvider();
    private final Ed25519VerificationProvider ed25519VerificationProvider = new Ed25519VerificationProvider();
    private final EcdsaSecp256k1VerificationProvider ecdsaSecp256k1VerificationProvider = new EcdsaSecp256k1VerificationProvider();

    public CryptoEngine() {
        this.serializationDigestProvider = new SerializationDigestProvider();
        this.runningHashProvider = new RunningHashProvider();
    }

    private static boolean verifySyncInternal(TransactionSignature signature, OperationProvider<TransactionSignature, Void, Boolean, ?, SignatureType> provider) {
        boolean isValid;
        try {
            isValid = provider.compute(signature, signature.getSignatureType());
            signature.setSignatureStatus(isValid ? VerificationStatus.VALID : VerificationStatus.INVALID);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CryptographyException(ex, LogMarker.EXCEPTION);
        }
        return isValid;
    }

    @Override
    @NonNull
    public Hash digestSync(@NonNull byte[] message) {
        return new Hash(this.digestSyncInternal(message, this.digestProvider), DEFAULT_DIGEST_TYPE);
    }

    @Override
    public byte[] digestBytesSync(@NonNull SelfSerializable serializable) {
        Objects.requireNonNull(serializable, "serializable must not be null");
        try {
            return (byte[])this.serializationDigestProvider.compute(serializable, DEFAULT_DIGEST_TYPE);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CryptographyException(ex, LogMarker.EXCEPTION);
        }
    }

    @Override
    public Hash digestSync(@NonNull SerializableHashable serializableHashable, boolean setHash) {
        Hash hash = new Hash(this.digestBytesSync(serializableHashable), DEFAULT_DIGEST_TYPE);
        if (setHash) {
            serializableHashable.setHash(hash);
        }
        return hash;
    }

    @Override
    @NonNull
    public byte[] digestBytesSync(@NonNull byte[] message) {
        return this.digestSyncInternal(message, this.digestProvider);
    }

    @Override
    public boolean verifySync(@NonNull TransactionSignature signature) {
        if (signature.getSignatureType() == SignatureType.ECDSA_SECP256K1) {
            return CryptoEngine.verifySyncInternal(signature, this.ecdsaSecp256k1VerificationProvider);
        }
        return CryptoEngine.verifySyncInternal(signature, this.ed25519VerificationProvider);
    }

    @Override
    public boolean verifySync(@NonNull List<TransactionSignature> signatures) {
        boolean finalOutcome = true;
        Iterator<TransactionSignature> iterator = signatures.iterator();
        while (iterator.hasNext()) {
            TransactionSignature signature;
            OperationProvider provider = (signature = iterator.next()).getSignatureType() == SignatureType.ECDSA_SECP256K1 ? this.ecdsaSecp256k1VerificationProvider : this.ed25519VerificationProvider;
            if (CryptoEngine.verifySyncInternal(signature, provider)) continue;
            finalOutcome = false;
        }
        return finalOutcome;
    }

    @Override
    public boolean verifySync(@NonNull byte[] data, @NonNull byte[] signature, @NonNull byte[] publicKey, @NonNull SignatureType signatureType) {
        if (signatureType == SignatureType.ECDSA_SECP256K1) {
            return this.ecdsaSecp256k1VerificationProvider.compute(data, signature, publicKey, signatureType);
        }
        return this.ed25519VerificationProvider.compute(data, signature, publicKey, signatureType);
    }

    @Override
    @NonNull
    public Hash calcRunningHash(@NonNull Hash runningHash, @NonNull Hash newHashToAdd) {
        try {
            return this.runningHashProvider.compute(runningHash, newHashToAdd, Cryptography.DEFAULT_DIGEST_TYPE);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptographyException(e, LogMarker.EXCEPTION);
        }
    }

    @NonNull
    private byte[] digestSyncInternal(@NonNull byte[] message, @NonNull DigestProvider provider) {
        Objects.requireNonNull(message, "message must not be null");
        Objects.requireNonNull(provider, "provider must not be null");
        try {
            return provider.compute(message, Cryptography.DEFAULT_DIGEST_TYPE);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CryptographyException(ex, LogMarker.EXCEPTION);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

