/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.config.internal;

import com.swirlds.config.api.Configuration;
import com.swirlds.config.extensions.reflection.ConfigReflectionUtils;
import com.swirlds.config.extensions.sources.ConfigMapping;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.config.internal.ConfigMappings;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.RecordComponent;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlatformConfigUtils {
    private static final Logger logger = LogManager.getLogger(PlatformConfigUtils.class);
    public static final String SETTING_USED_FILENAME = "settingsUsed.txt";
    private static final String ERROR_CONFIGURATION_IS_NULL = "configuration should not be null";
    private static final String ERROR_DIRECTORY_IS_NULL = "directory should not be null";
    private static final String ERROR_STRING_BUILDER_IS_NULL = "stringBuilder should not be null";

    private PlatformConfigUtils() {
    }

    public static void checkConfiguration(@NonNull Configuration configuration) {
        Objects.requireNonNull(configuration, ERROR_CONFIGURATION_IS_NULL);
        Set<String> configNames = PlatformConfigUtils.getConfigNames(configuration);
        PlatformConfigUtils.logNotKnownConfigProperties(configuration, configNames);
    }

    private static void logNotKnownConfigProperties(@NonNull Configuration configuration, @NonNull Set<String> configNames) {
        ConfigMappings.MAPPINGS.stream().map(ConfigMapping::originalName).forEach(configNames::add);
        configuration.getPropertyNames().filter(name -> !configNames.contains(name)).forEach(name -> {
            String message = "Configuration property '%s' is not used by any configuration data type".formatted(name);
            logger.debug(LogMarker.CONFIG.getMarker(), message);
        });
    }

    static void logAppliedMappedProperties(@NonNull Set<String> configNames) {
        Map<String, String> mappings = ConfigMappings.MAPPINGS.stream().collect(Collectors.toMap(ConfigMapping::originalName, ConfigMapping::mappedName));
        configNames.stream().filter(mappings::containsKey).forEach(name -> {
            String message = "Configuration property '%s' was renamed to '%s'. This build is currently backwards compatible with the old name, but this may not be true in a future release, so it is important to switch to the new name.".formatted(name, mappings.get(name));
            logger.warn(LogMarker.STARTUP.getMarker(), message);
        });
    }

    @NonNull
    private static Set<String> getConfigNames(@NonNull Configuration configuration) {
        return configuration.getConfigDataTypes().stream().flatMap(configDataType -> {
            String propertyNamePrefix = ConfigReflectionUtils.getNamePrefixForConfigDataRecord((AnnotatedElement)configDataType);
            return Arrays.stream(configDataType.getRecordComponents()).map(component -> ConfigReflectionUtils.getPropertyNameForConfigDataProperty((String)propertyNamePrefix, (RecordComponent)component));
        }).collect(Collectors.toSet());
    }

    public static void writeSettingsUsed(@NonNull Path directory, @NonNull Configuration configuration) {
        Objects.requireNonNull(directory, ERROR_DIRECTORY_IS_NULL);
        Objects.requireNonNull(configuration, ERROR_CONFIGURATION_IS_NULL);
        try (BufferedWriter writer = Files.newBufferedWriter(directory.resolve(SETTING_USED_FILENAME), new OpenOption[0]);){
            StringBuilder stringBuilder = new StringBuilder();
            PlatformConfigUtils.generateSettingsUsed(stringBuilder, configuration);
            writer.write(stringBuilder.toString());
            writer.flush();
        }
        catch (IOException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Error in writing to settingsUsed.txt", (Throwable)e);
        }
    }

    public static void generateSettingsUsed(@NonNull StringBuilder stringBuilder, @NonNull Configuration configuration) {
        Objects.requireNonNull(stringBuilder, ERROR_STRING_BUILDER_IS_NULL);
        Objects.requireNonNull(configuration, ERROR_CONFIGURATION_IS_NULL);
        stringBuilder.append("------------- Configuration Overrides -------------");
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append(System.lineSeparator());
        Set propertyNames = configuration.getPropertyNames().collect(Collectors.toCollection(TreeSet::new));
        for (String propertyName : propertyNames) {
            if (configuration.isListValue(propertyName)) {
                String value = Objects.requireNonNullElse(configuration.getValues(propertyName), List.of()).stream().map(Object::toString).collect(Collectors.joining(", "));
                stringBuilder.append(String.format("%s, %s%n", propertyName, value));
                continue;
            }
            stringBuilder.append(String.format("%s, %s%n", propertyName, configuration.getValue(propertyName)));
        }
    }
}

