/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.signed;

import com.swirlds.common.formatting.TextEffect;
import com.swirlds.common.formatting.TextTable;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.route.MerkleRoute;
import com.swirlds.common.merkle.route.MerkleRouteUtils;

public record MismatchedNodes(MerkleNode nodeA, MerkleNode nodeB) {
    public void appendNodeDescriptions(TextTable table) {
        String nodeBString;
        String nodeAString;
        MerkleRoute route = this.nodeA == null ? this.nodeB.getRoute() : this.nodeA.getRoute();
        String stepString = route.isEmpty() ? "(root)" : Integer.toString(route.getStep(-1));
        String formattedStepString = TextEffect.BRIGHT_CYAN.apply(stepString);
        String nodeATypeString = this.nodeA == null ? "null" : this.nodeA.getClass().getSimpleName();
        String formattedNodeATypeString = TextEffect.BRIGHT_YELLOW.apply(nodeATypeString);
        StringBuilder firstColumnBuilder = new StringBuilder();
        int routeSize = route.size();
        firstColumnBuilder.append("  ".repeat(routeSize)).append(formattedStepString).append(" ").append(formattedNodeATypeString);
        String firstColumn = firstColumnBuilder.toString();
        String routeString = MerkleRouteUtils.merkleRouteToPathFormat((MerkleRoute)route);
        String formattedRouteString = TextEffect.BRIGHT_RED.apply(routeString);
        if (this.nodeA == null) {
            nodeAString = "null";
            nodeBString = this.nodeB.getClass().getSimpleName();
        } else if (this.nodeB == null) {
            nodeAString = this.nodeA.getClass().getSimpleName();
            nodeBString = "null";
        } else if (this.nodeA.getClassId() != this.nodeB.getClassId()) {
            nodeAString = this.nodeA.getClass().getSimpleName();
            nodeBString = this.nodeB.getClass().getSimpleName();
        } else {
            nodeAString = this.nodeA.getHash().toHex(12);
            nodeBString = this.nodeB.getHash().toHex(12);
        }
        String formattedNodeAString = TextEffect.GRAY.apply(nodeAString);
        String formattedNodeBString = TextEffect.GRAY.apply(nodeBString);
        table.addRow(new Object[]{firstColumn, formattedRouteString, formattedNodeAString, formattedNodeBString});
    }
}

