/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.set;

import com.swirlds.common.test.fixtures.set.Hotspot;
import com.swirlds.common.test.fixtures.set.HotspotSetIterator;
import com.swirlds.common.test.fixtures.set.RandomAccessHashSet;
import com.swirlds.common.test.fixtures.set.RandomAccessSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;

public class HotspotHashSet<T>
implements RandomAccessSet<T> {
    private final List<Hotspot> hotspots;
    private final List<RandomAccessHashSet<T>> sets;
    private final double totalWeight;
    private int totalCount;
    private static final int DEFAULT_SET_INDEX = 0;

    public HotspotHashSet(double defaultWeight, Hotspot ... hotspots) {
        int hotspotCount = (hotspots == null ? 0 : hotspots.length) + 1;
        this.hotspots = new ArrayList<Hotspot>(hotspotCount);
        this.sets = new ArrayList<RandomAccessHashSet<T>>(hotspotCount);
        this.hotspots.add(new Hotspot(defaultWeight, Integer.MAX_VALUE));
        this.sets.add(new RandomAccessHashSet());
        double weightSum = defaultWeight;
        if (hotspots != null) {
            for (Hotspot hotspot : hotspots) {
                this.hotspots.add(hotspot);
                weightSum += hotspot.getWeight();
                this.sets.add(new RandomAccessHashSet());
            }
        }
        this.totalWeight = weightSum;
    }

    private int chooseSetIndexByWeight(Random random) {
        double choice = random.nextDouble() * this.totalWeight;
        for (int index = 0; index < this.sets.size(); ++index) {
            if (!((choice -= this.hotspots.get(index).getWeight()) < 0.0)) continue;
            return index;
        }
        return 0;
    }

    private int chooseSetIndexBySize(Random random) {
        double choice = random.nextDouble() * (double)this.totalCount;
        for (int index = 0; index < this.sets.size(); ++index) {
            if (!((choice -= (double)this.sets.get(index).size()) < 0.0)) continue;
            return index;
        }
        return 0;
    }

    public T getWeighted(Random random) {
        RandomAccessHashSet<T> set;
        block3: {
            RandomAccessHashSet<T> defaultSet;
            if (this.totalCount == 0) {
                throw new NoSuchElementException("set is empty, can not get element");
            }
            while (true) {
                int setIndex = this.chooseSetIndexByWeight(random);
                set = this.sets.get(setIndex);
                if (setIndex == 0) {
                    if (set.size() <= 0) continue;
                    return set.get(random);
                }
                Hotspot hotspot = this.hotspots.get(setIndex);
                if (hotspot.getHotspotSize() <= set.size()) break block3;
                defaultSet = this.sets.get(0);
                if (defaultSet.size() > 0) break;
            }
            T element = defaultSet.get(random);
            defaultSet.remove(element);
            set.add(element);
            return element;
        }
        return set.get(random);
    }

    @Override
    public T get(Random random) {
        if (this.totalCount == 0) {
            throw new NoSuchElementException("set is empty, can not get element");
        }
        int setIndex = this.chooseSetIndexBySize(random);
        RandomAccessHashSet<T> set = this.sets.get(setIndex);
        return set.get(random);
    }

    @Override
    public T get(int index) {
        if (index >= this.totalCount || index < 0) {
            throw new IndexOutOfBoundsException("requested index " + index + " is invalid");
        }
        int count = 0;
        for (RandomAccessHashSet<T> set : this.sets) {
            if (count + set.size() > index) {
                return set.get(index - count);
            }
            count += set.size();
        }
        throw new IllegalStateException("unable to find element at index " + index);
    }

    public RandomAccessHashSet<T> getHotspotSet(int index) {
        return this.sets.get(index);
    }

    public int getHotspotCount() {
        return this.sets.size();
    }

    @Override
    public int size() {
        return this.totalCount;
    }

    @Override
    public boolean isEmpty() {
        return this.totalCount == 0;
    }

    @Override
    public boolean contains(Object o) {
        for (Set set : this.sets) {
            if (!set.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new HotspotSetIterator<T>(this.sets);
    }

    private void addSetToArray(Object[] array, int startIndex, RandomAccessHashSet<T> set) {
        for (int index = 0; index < set.size(); ++index) {
            array[index + startIndex] = set.get(index);
        }
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.totalCount];
        int index = 0;
        for (RandomAccessHashSet<T> set : this.sets) {
            this.addSetToArray(array, index, set);
            index += set.size();
        }
        return array;
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(T t) {
        boolean added = this.sets.get(0).add(t);
        if (added) {
            ++this.totalCount;
        }
        return added;
    }

    @Override
    public boolean remove(Object o) {
        for (Set set : this.sets) {
            if (!set.remove(o)) continue;
            --this.totalCount;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        for (Set set : this.sets) {
            set.clear();
        }
        this.totalCount = 0;
    }
}

