/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.iss;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.config.api.Configuration;
import com.swirlds.demo.iss.ISSTestingToolConfig;
import com.swirlds.demo.iss.PlannedIss;
import com.swirlds.demo.iss.PlannedLogError;
import com.swirlds.platform.state.MerkleNodeState;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.system.InitTrigger;
import com.swirlds.platform.system.Platform;
import com.swirlds.platform.test.fixtures.state.TestingAppStateInitializer;
import com.swirlds.state.State;
import com.swirlds.state.merkle.MerkleStateRoot;
import com.swirlds.state.merkle.singleton.StringLeaf;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.hiero.base.constructable.ConstructableIgnored;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.consensus.model.event.ConsensusEvent;

@ConstructableIgnored
public class ISSTestingToolState
extends MerkleStateRoot<ISSTestingToolState>
implements MerkleNodeState {
    private static final long CLASS_ID = -1127809155241545913L;
    private static final int RUNNING_SUM_INDEX = 3;
    private static final int GENESIS_TIMESTAMP_INDEX = 4;
    private static final int PLANNED_ISS_LIST_INDEX = 5;
    private static final int PLANNED_LOG_ERROR_LIST_INDEX = 6;
    private long runningSum = 0L;
    private Instant genesisTimestamp;
    private List<PlannedIss> plannedIssList = new LinkedList<PlannedIss>();
    private List<PlannedLogError> plannedLogErrorList = new LinkedList<PlannedLogError>();

    public ISSTestingToolState() {
    }

    public void initState(InitTrigger trigger, Platform platform) {
        this.throwIfImmutable();
        PlatformContext platformContext = platform.getContext();
        super.init(platformContext.getTime(), platformContext.getConfiguration(), platformContext.getMetrics(), platformContext.getMerkleCryptography(), () -> PlatformStateFacade.DEFAULT_PLATFORM_STATE_FACADE.roundOf((State)this));
        if (trigger == InitTrigger.GENESIS) {
            ISSTestingToolConfig testingToolConfig = (ISSTestingToolConfig)platform.getContext().getConfiguration().getConfigData(ISSTestingToolConfig.class);
            this.plannedIssList = testingToolConfig.getPlannedISSs();
            this.plannedLogErrorList = testingToolConfig.getPlannedLogErrors();
            this.writeObjectByChildIndex(5, this.plannedIssList);
            this.writeObjectByChildIndex(6, this.plannedLogErrorList);
        } else {
            StringLeaf genesisTimestampLeaf;
            StringLeaf runningSumLeaf = (StringLeaf)this.getChild(3);
            if (runningSumLeaf != null) {
                this.runningSum = Long.parseLong(runningSumLeaf.getLabel());
            }
            if ((genesisTimestampLeaf = (StringLeaf)this.getChild(4)) != null) {
                this.genesisTimestamp = Instant.parse(genesisTimestampLeaf.getLabel());
            }
            this.plannedIssList = this.readObjectByChildIndex(5, PlannedIss::new);
            this.plannedLogErrorList = this.readObjectByChildIndex(6, PlannedLogError::new);
        }
    }

    <T extends SelfSerializable> List<T> readObjectByChildIndex(int index, Supplier<T> factory) {
        StringLeaf stringValue = (StringLeaf)this.getChild(index);
        if (stringValue != null) {
            try {
                SerializableDataInputStream in = new SerializableDataInputStream((InputStream)new ByteArrayInputStream(stringValue.getLabel().getBytes(StandardCharsets.UTF_8)));
                return in.readSerializableList(1024, false, factory);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    <T extends SelfSerializable> void writeObjectByChildIndex(int index, List<T> list) {
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            SerializableDataOutputStream out = new SerializableDataOutputStream((OutputStream)byteOut);
            out.writeSerializableList(list, false, true);
            this.setChild(index, (MerkleNode)new StringLeaf(byteOut.toString(StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void captureTimestamp(@NonNull ConsensusEvent event) {
        if (this.genesisTimestamp == null) {
            this.genesisTimestamp = event.getConsensusTimestamp();
            this.setChild(4, (MerkleNode)new StringLeaf(this.genesisTimestamp.toString()));
        }
    }

    void incrementRunningSum(long delta) {
        this.runningSum += delta;
        this.setChild(3, (MerkleNode)new StringLeaf(Long.toString(this.runningSum)));
    }

    Instant getGenesisTimestamp() {
        return this.genesisTimestamp;
    }

    List<PlannedIss> getPlannedIssList() {
        return this.plannedIssList;
    }

    List<PlannedLogError> getPlannedLogErrorList() {
        return this.plannedLogErrorList;
    }

    private ISSTestingToolState(ISSTestingToolState that) {
        super((MerkleStateRoot)that);
        this.runningSum = that.runningSum;
        this.genesisTimestamp = that.genesisTimestamp;
        this.plannedIssList = new ArrayList<PlannedIss>(that.plannedIssList);
        this.plannedLogErrorList = new ArrayList<PlannedLogError>(that.plannedLogErrorList);
    }

    @NonNull
    public synchronized ISSTestingToolState copy() {
        this.throwIfImmutable();
        this.setImmutable(true);
        return new ISSTestingToolState(this);
    }

    public long getClassId() {
        return -1127809155241545913L;
    }

    public int getVersion() {
        return 1;
    }

    public int getMinimumSupportedVersion() {
        return 1;
    }

    protected ISSTestingToolState copyingConstructor() {
        return new ISSTestingToolState(this);
    }

    public MerkleNode migrate(@NonNull Configuration configuration, int version) {
        return this;
    }

    static {
        TestingAppStateInitializer.registerMerkleStateRootClassIds();
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

