/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction;

import com.hedera.hapi.node.base.SignatureMap;
import com.hedera.hapi.node.transaction.codec.SignedTransactionJsonCodec;
import com.hedera.hapi.node.transaction.codec.SignedTransactionProtoCodec;
import com.hedera.hapi.node.transaction.schema.SignedTransactionSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class SignedTransaction {
    public static final Codec<SignedTransaction> PROTOBUF = new SignedTransactionProtoCodec();
    public static final JsonCodec<SignedTransaction> JSON = new SignedTransactionJsonCodec();
    public static final SignedTransaction DEFAULT = SignedTransaction.newBuilder().build();
    @NonNull
    private final Bytes bodyBytes;
    @Nullable
    private final SignatureMap sigMap;
    private final boolean useSerializedTxMessageHashAlgorithm;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public SignedTransaction(Bytes bodyBytes, SignatureMap sigMap, boolean useSerializedTxMessageHashAlgorithm) {
        this.$unknownFields = null;
        this.bodyBytes = bodyBytes != null ? bodyBytes : Bytes.EMPTY;
        this.sigMap = sigMap;
        this.useSerializedTxMessageHashAlgorithm = useSerializedTxMessageHashAlgorithm;
    }

    public SignedTransaction(Bytes bodyBytes, SignatureMap sigMap, boolean useSerializedTxMessageHashAlgorithm, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.bodyBytes = bodyBytes != null ? bodyBytes : Bytes.EMPTY;
        this.sigMap = sigMap;
        this.useSerializedTxMessageHashAlgorithm = useSerializedTxMessageHashAlgorithm;
    }

    public Bytes bodyBytes() {
        return this.bodyBytes;
    }

    public SignatureMap sigMap() {
        return this.sigMap;
    }

    public boolean useSerializedTxMessageHashAlgorithm() {
        return this.useSerializedTxMessageHashAlgorithm;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)SignedTransactionSchema.BODY_BYTES, (RandomAccessData)this.bodyBytes, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)SignedTransactionSchema.SIG_MAP, (Object)this.sigMap, SignatureMap.PROTOBUF);
            _size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)SignedTransactionSchema.USE_SERIALIZED_TX_MESSAGE_HASH_ALGORITHM, (boolean)this.useSerializedTxMessageHashAlgorithm, (boolean)true);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.bodyBytes != null && !this.bodyBytes.equals((Object)SignedTransaction.DEFAULT.bodyBytes)) {
                result = 31 * result + this.bodyBytes.hashCode();
            }
            if (this.sigMap != null && !this.sigMap.equals(SignedTransaction.DEFAULT.sigMap)) {
                result = 31 * result + this.sigMap.hashCode();
            }
            if (this.useSerializedTxMessageHashAlgorithm != SignedTransaction.DEFAULT.useSerializedTxMessageHashAlgorithm) {
                result = 31 * result + Boolean.hashCode(this.useSerializedTxMessageHashAlgorithm);
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        SignedTransaction thatObj = (SignedTransaction)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.bodyBytes == null && thatObj.bodyBytes != null) {
            return false;
        }
        if (this.bodyBytes != null && !this.bodyBytes.equals((Object)thatObj.bodyBytes)) {
            return false;
        }
        if (this.sigMap == null && thatObj.sigMap != null) {
            return false;
        }
        if (this.sigMap != null && !this.sigMap.equals(thatObj.sigMap)) {
            return false;
        }
        if (this.useSerializedTxMessageHashAlgorithm != thatObj.useSerializedTxMessageHashAlgorithm) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "SignedTransaction[bodyBytes=" + String.valueOf(this.bodyBytes) + ", sigMap=" + String.valueOf(this.sigMap) + ", useSerializedTxMessageHashAlgorithm=" + this.useSerializedTxMessageHashAlgorithm + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasSigMap() {
        return this.sigMap != null;
    }

    public SignatureMap sigMapOrElse(@NonNull SignatureMap defaultValue) {
        return this.hasSigMap() ? this.sigMap : defaultValue;
    }

    @NonNull
    public SignatureMap sigMapOrThrow() {
        return Objects.requireNonNull(this.sigMap, "Field sigMap is null");
    }

    public void ifSigMap(@NonNull Consumer<SignatureMap> ifPresent) {
        if (this.hasSigMap()) {
            ifPresent.accept(this.sigMap);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.bodyBytes, this.sigMap, this.useSerializedTxMessageHashAlgorithm, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @NonNull
        private Bytes bodyBytes = Bytes.EMPTY;
        @Nullable
        private SignatureMap sigMap = null;
        private boolean useSerializedTxMessageHashAlgorithm = false;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(Bytes bodyBytes, SignatureMap sigMap, boolean useSerializedTxMessageHashAlgorithm) {
            this.$unknownFields = null;
            this.bodyBytes = bodyBytes != null ? bodyBytes : Bytes.EMPTY;
            this.sigMap = sigMap;
            this.useSerializedTxMessageHashAlgorithm = useSerializedTxMessageHashAlgorithm;
        }

        public Builder(Bytes bodyBytes, SignatureMap sigMap, boolean useSerializedTxMessageHashAlgorithm, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.bodyBytes = bodyBytes != null ? bodyBytes : Bytes.EMPTY;
            this.sigMap = sigMap;
            this.useSerializedTxMessageHashAlgorithm = useSerializedTxMessageHashAlgorithm;
        }

        public SignedTransaction build() {
            return new SignedTransaction(this.bodyBytes, this.sigMap, this.useSerializedTxMessageHashAlgorithm);
        }

        public Builder bodyBytes(@NonNull Bytes bodyBytes) {
            this.bodyBytes = bodyBytes != null ? bodyBytes : Bytes.EMPTY;
            return this;
        }

        public Builder sigMap(@Nullable SignatureMap sigMap) {
            this.sigMap = sigMap;
            return this;
        }

        public Builder sigMap(SignatureMap.Builder builder) {
            this.sigMap = builder.build();
            return this;
        }

        public Builder useSerializedTxMessageHashAlgorithm(boolean useSerializedTxMessageHashAlgorithm) {
            this.useSerializedTxMessageHashAlgorithm = useSerializedTxMessageHashAlgorithm;
            return this;
        }
    }
}

