/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.addressbook;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.swirlds.platform.test.fixtures.addressbook.RandomRosterEntryBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Random;

public class RosterTestUtils {
    private RosterTestUtils() {
    }

    public static Roster dropRosterEntryFromRoster(@NonNull Roster roster, long nodeId) {
        Roster.Builder builder = Roster.newBuilder();
        ArrayList rosterEntries = new ArrayList();
        roster.rosterEntries().stream().filter(entry -> entry.nodeId() != nodeId).forEach(rosterEntries::add);
        builder.rosterEntries(rosterEntries);
        return builder.build();
    }

    public static Roster addRandomRosterEntryToRoster(@NonNull Roster roster, long nodeId, @NonNull Random random) {
        Roster.Builder builder = Roster.newBuilder();
        ArrayList<RosterEntry> rosterEntries = new ArrayList<RosterEntry>(roster.rosterEntries());
        RosterEntry entry = RandomRosterEntryBuilder.create(random).withNodeId(nodeId).build();
        rosterEntries.add(entry);
        builder.rosterEntries(rosterEntries);
        return builder.build();
    }
}

