/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.event.source;

import com.swirlds.base.utility.Pair;
import com.swirlds.platform.test.fixtures.event.source.EventSource;
import com.swirlds.platform.test.fixtures.event.source.ForkingEventSource;
import com.swirlds.platform.test.fixtures.event.source.StandardEventSource;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class EventSourceFactory {
    private final int numNodes;
    private final List<Pair<Predicate<Long>, Supplier<EventSource>>> customSources;

    public EventSourceFactory(int numNodes) {
        this.numNodes = numNodes;
        this.customSources = new LinkedList<Pair<Predicate<Long>, Supplier<EventSource>>>();
    }

    public void addCustomSource(Predicate<Long> indexPredicate, Supplier<EventSource> sourceSupplier) {
        this.customSources.add((Pair<Predicate<Long>, Supplier<EventSource>>)Pair.of(indexPredicate, sourceSupplier));
    }

    public List<EventSource> generateSources() {
        LinkedList<EventSource> list = new LinkedList<EventSource>();
        block0: for (long i = 0L; i < (long)this.numNodes; ++i) {
            for (Pair<Predicate<Long>, Supplier<EventSource>> customSource : this.customSources) {
                if (!((Predicate)customSource.left()).test(i)) continue;
                list.add((EventSource)((Supplier)customSource.right()).get());
                continue block0;
            }
            list.add(EventSourceFactory.newStandardEventSource());
        }
        return list;
    }

    public static StandardEventSource newStandardEventSource() {
        return new StandardEventSource(false);
    }

    public static ForkingEventSource newForkingEventSource() {
        return new ForkingEventSource(false);
    }
}

