/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading.manager;

import com.swirlds.base.state.LifecyclePhase;
import com.swirlds.common.threading.framework.config.ThreadConfiguration;
import com.swirlds.common.threading.manager.ThreadManager;
import java.util.concurrent.ThreadFactory;

public class StandardThreadManager
implements ThreadManager {
    private LifecyclePhase phase = LifecyclePhase.NOT_STARTED;

    @Override
    public Thread createThread(ThreadGroup threadGroup, Runnable runnable) {
        this.throwIfNotInPhase(LifecyclePhase.STARTED);
        return new Thread(threadGroup, runnable);
    }

    @Override
    public ThreadFactory createThreadFactory(String component, String threadName) {
        return ((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(this).setComponent(component)).setThreadName(threadName)).buildFactory();
    }

    public void start() {
        this.throwIfNotInPhase(LifecyclePhase.NOT_STARTED);
        this.phase = LifecyclePhase.STARTED;
    }

    public void stop() {
        this.throwIfNotInPhase(LifecyclePhase.STARTED);
        this.phase = LifecyclePhase.STOPPED;
    }

    public LifecyclePhase getLifecyclePhase() {
        return this.phase;
    }
}

