/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.test.fixtures;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.primitives.ProtoBytes;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.lifecycle.StateMetadata;
import com.swirlds.state.spi.ReadableSingletonState;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.test.fixtures.FunctionReadableSingletonState;
import com.swirlds.state.test.fixtures.FunctionWritableSingletonState;
import com.swirlds.state.test.fixtures.ListReadableQueueState;
import com.swirlds.state.test.fixtures.ListWritableQueueState;
import com.swirlds.state.test.fixtures.MapReadableKVState;
import com.swirlds.state.test.fixtures.MapWritableKVState;
import com.swirlds.state.test.fixtures.TestBase;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.concurrent.atomic.AtomicReference;
import org.mockito.ArgumentMatchers;

public class StateTestBase
extends TestBase {
    public static final SemanticVersion TEST_VERSION = SemanticVersion.newBuilder().major(1).build();
    public static final String FIRST_SERVICE = "First-Service";
    public static final String SECOND_SERVICE = "Second-Service";
    public static final String UNKNOWN_SERVICE = "Bogus-Service";
    protected static final String UNKNOWN_STATE_KEY = "BOGUS_STATE_KEY";
    protected static final int UNKNOWN_STATE_ID = -1;
    protected static final ProtoBytes UNKNOWN_KEY = new ProtoBytes(Bytes.wrap((String)"BOGUS_KEY"));
    protected static final String FRUIT_SERVICE_NAME = "Plants";
    protected static final String FRUIT_STATE_KEY = "FRUIT";
    protected static final int FRUIT_STATE_ID = 3;
    protected static final String FRUIT_STATE_LABEL = StateMetadata.computeLabel((String)"Plants", (String)"FRUIT");
    protected static final String STEAM_SERVICE_NAME = "Learning";
    protected static final String STEAM_STATE_KEY = "STEAM";
    protected static final int STEAM_STATE_ID = 10001;
    protected static final String STEAM_STATE_LABEL = StateMetadata.computeLabel((String)"Learning", (String)"STEAM");
    public static final String COUNTRY_SERVICE_NAME = "Planets";
    public static final String COUNTRY_STATE_KEY = "COUNTRY";
    protected static final int COUNTRY_STATE_ID = 11;
    protected static final String COUNTRY_STATE_LABEL = StateMetadata.computeLabel((String)"Planets", (String)"COUNTRY");
    protected static final ProtoBytes A_KEY = StateTestBase.toProtoBytes("A");
    protected static final ProtoBytes B_KEY = StateTestBase.toProtoBytes("B");
    protected static final ProtoBytes C_KEY = StateTestBase.toProtoBytes("C");
    protected static final ProtoBytes D_KEY = StateTestBase.toProtoBytes("D");
    protected static final ProtoBytes E_KEY = StateTestBase.toProtoBytes("E");
    protected static final ProtoBytes F_KEY = StateTestBase.toProtoBytes("F");
    protected static final ProtoBytes G_KEY = StateTestBase.toProtoBytes("G");
    protected static final ProtoBytes APPLE = StateTestBase.toProtoBytes("Apple");
    protected static final ProtoBytes ACAI = StateTestBase.toProtoBytes("Acai");
    protected static final ProtoBytes BANANA = StateTestBase.toProtoBytes("Banana");
    protected static final ProtoBytes BLACKBERRY = StateTestBase.toProtoBytes("BlackBerry");
    protected static final ProtoBytes BLUEBERRY = StateTestBase.toProtoBytes("BlueBerry");
    protected static final ProtoBytes CHERRY = StateTestBase.toProtoBytes("Cherry");
    protected static final ProtoBytes CRANBERRY = StateTestBase.toProtoBytes("Cranberry");
    protected static final ProtoBytes DATE = StateTestBase.toProtoBytes("Date");
    protected static final ProtoBytes DRAGONFRUIT = StateTestBase.toProtoBytes("DragonFruit");
    protected static final ProtoBytes EGGPLANT = StateTestBase.toProtoBytes("Eggplant");
    protected static final ProtoBytes ELDERBERRY = StateTestBase.toProtoBytes("ElderBerry");
    protected static final ProtoBytes FIG = StateTestBase.toProtoBytes("Fig");
    protected static final ProtoBytes FEIJOA = StateTestBase.toProtoBytes("Feijoa");
    protected static final ProtoBytes GRAPE = StateTestBase.toProtoBytes("Grape");
    protected static final ProtoBytes ART = StateTestBase.toProtoBytes("Art");
    protected static final ProtoBytes BIOLOGY = StateTestBase.toProtoBytes("Biology");
    protected static final ProtoBytes CHEMISTRY = StateTestBase.toProtoBytes("Chemistry");
    protected static final ProtoBytes DISCIPLINE = StateTestBase.toProtoBytes("Discipline");
    protected static final ProtoBytes ECOLOGY = StateTestBase.toProtoBytes("Ecology");
    protected static final ProtoBytes FIELDS = StateTestBase.toProtoBytes("Fields");
    protected static final ProtoBytes GEOMETRY = StateTestBase.toProtoBytes("Geometry");
    protected static final ProtoBytes AUSTRALIA = StateTestBase.toProtoBytes("Australia");
    protected static final ProtoBytes BRAZIL = StateTestBase.toProtoBytes("Brazil");
    protected static final ProtoBytes CHAD = StateTestBase.toProtoBytes("Chad");
    protected static final ProtoBytes DENMARK = StateTestBase.toProtoBytes("Denmark");
    protected static final ProtoBytes ESTONIA = StateTestBase.toProtoBytes("Estonia");
    protected static final ProtoBytes FRANCE = StateTestBase.toProtoBytes("France");
    protected static final ProtoBytes GHANA = StateTestBase.toProtoBytes("Ghana");

    @NonNull
    protected MapReadableKVState<ProtoBytes, ProtoBytes> readableFruitState() {
        return MapReadableKVState.builder(3, FRUIT_STATE_LABEL).value(A_KEY, APPLE).value(B_KEY, BANANA).value(C_KEY, CHERRY).value(D_KEY, DATE).value(E_KEY, EGGPLANT).value(F_KEY, FIG).value(G_KEY, GRAPE).build();
    }

    @NonNull
    protected MapWritableKVState<ProtoBytes, ProtoBytes> writableFruitState() {
        return MapWritableKVState.builder(3, FRUIT_STATE_LABEL).value(A_KEY, APPLE).value(B_KEY, BANANA).value(C_KEY, CHERRY).value(D_KEY, DATE).value(E_KEY, EGGPLANT).value(F_KEY, FIG).value(G_KEY, GRAPE).build();
    }

    @NonNull
    protected ListReadableQueueState<ProtoBytes> readableSTEAMState() {
        return ListReadableQueueState.builder(10001, STEAM_STATE_LABEL).value(ART).value(BIOLOGY).value(CHEMISTRY).value(DISCIPLINE).value(ECOLOGY).value(FIELDS).value(GEOMETRY).build();
    }

    @NonNull
    protected ListWritableQueueState<ProtoBytes> writableSTEAMState() {
        return ListWritableQueueState.builder(10001, StateMetadata.computeLabel((String)STEAM_SERVICE_NAME, (String)STEAM_STATE_KEY)).value(ART).value(BIOLOGY).value(CHEMISTRY).value(DISCIPLINE).value(ECOLOGY).value(FIELDS).value(GEOMETRY).build();
    }

    @NonNull
    protected ReadableSingletonState<ProtoBytes> readableCountryState() {
        return new FunctionReadableSingletonState<ProtoBytes>(11, COUNTRY_STATE_LABEL, () -> AUSTRALIA);
    }

    @NonNull
    protected WritableSingletonState<ProtoBytes> writableCountryState() {
        AtomicReference<ProtoBytes> backingValue = new AtomicReference<ProtoBytes>(AUSTRALIA);
        return new FunctionWritableSingletonState<ProtoBytes>(11, StateMetadata.computeLabel((String)COUNTRY_STATE_KEY, (String)COUNTRY_STATE_LABEL), backingValue::get, backingValue::set);
    }

    protected SemanticVersion version(int major, int minor, int patch) {
        return new SemanticVersion(major, minor, patch, null, null);
    }

    protected static ProtoBytes anyProtoBytes() {
        return (ProtoBytes)ArgumentMatchers.any(ProtoBytes.class);
    }

    protected static ProtoBytes toProtoBytes(String value) {
        return new ProtoBytes(Bytes.wrap((String)value));
    }
}

